/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;

public class XRPackager
implements DBWSPackager {
    public static NullOutputStream __nullStream = new NullOutputStream();
    protected DBWSBuilder builder;
    protected String[] additionalArgs;
    protected File stageDir;
    protected String sessionsFileName;
    protected boolean hasAttachments;
    protected DBWSPackager.Archiver archiver;
    protected String packagerLabel;
    protected DBWSPackager.ArchiveUse archiveUse;

    public XRPackager() {
        this(null, "xr", DBWSPackager.ArchiveUse.noArchive);
    }

    protected XRPackager(DBWSPackager.Archiver archiver, String string, DBWSPackager.ArchiveUse archiveUse) {
        this.archiver = archiver;
        if (archiver != null) {
            archiver.setPackager(this);
        }
        this.packagerLabel = string;
        this.archiveUse = archiveUse;
    }

    @Override
    public void setDBWSBuilder(DBWSBuilder dBWSBuilder) {
        this.builder = dBWSBuilder;
    }

    @Override
    public void setAdditionalArgs(String[] stringArray) {
        this.additionalArgs = stringArray;
        if (stringArray != null) {
            this.processAdditionalArgs();
        }
    }

    public void processAdditionalArgs() {
        if (this.additionalArgs.length > 0) {
            this.setArchiveFilename(this.additionalArgs[0]);
        } else {
            this.setArchiveFilename(this.builder.getProjectName());
        }
    }

    @Override
    public File getStageDir() {
        return this.stageDir;
    }

    @Override
    public void setStageDir(File file) {
        this.stageDir = file;
    }

    @Override
    public String getSessionsFileName() {
        return this.sessionsFileName;
    }

    @Override
    public void setSessionsFileName(String string) {
        this.sessionsFileName = string;
    }

    @Override
    public boolean hasAttachments() {
        return this.hasAttachments;
    }

    @Override
    public void setHasAttachments(boolean bl) {
        this.hasAttachments = bl;
    }

    public DBWSPackager.Archiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(DBWSPackager.Archiver archiver) {
        this.archiver = archiver;
    }

    @Override
    public void setArchiveUse(DBWSPackager.ArchiveUse archiveUse) {
        this.archiveUse = archiveUse;
        this.processArchiveUse();
    }

    public void processArchiveUse() {
        switch (this.archiveUse) {
            case archive: {
                this.setArchiver(this.buildDefaultArchiver());
                break;
            }
            case noArchive: {
                this.setArchiver(null);
            }
        }
    }

    public DBWSPackager.Archiver buildDefaultArchiver() {
        return null;
    }

    @Override
    public String getArchiveFilename() {
        if (this.archiver != null) {
            return this.archiver.getFilename();
        }
        return null;
    }

    @Override
    public void setArchiveFilename(String string) {
        if (this.archiver != null) {
            this.archiver.setFilename(string);
        }
    }

    @Override
    public String getPackagerLabel() {
        return this.packagerLabel;
    }

    public String getArchiverLabel() {
        return this.archiveUse.name();
    }

    @Override
    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder("-packageAs:[default=");
        stringBuilder.append(this.getArchiverLabel());
        stringBuilder.append("] ");
        stringBuilder.append(this.getPackagerLabel());
        String string = this.getAdditionalUsage();
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getAdditionalUsage() {
        return " [jarFilename]";
    }

    @Override
    public void start() {
        if (this.stageDir == null) {
            throw new DBWSException(this.getClass().getSimpleName() + " stageDir cannot be null");
        }
    }

    @Override
    public OutputStream getSchemaStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-schema.xsd"));
    }

    @Override
    public void closeSchemaStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getSessionsStream(String string) throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, string));
    }

    @Override
    public SessionConfigs buildSessionsXML(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
        SessionConfigs sessionConfigs = new SessionConfigs();
        sessionConfigs.setVersion(Version.getVersion());
        DatabaseSessionConfig databaseSessionConfig = new DatabaseSessionConfig();
        String string = dBWSBuilder.getProjectName();
        databaseSessionConfig.setName(string + "-" + "dbws-or-session");
        ProjectConfig projectConfig = dBWSBuilder.buildORProjectConfig();
        databaseSessionConfig.setPrimaryProject(projectConfig);
        String string2 = dBWSBuilder.getOrSessionCustomizerClassName();
        if (string2 != null && !"".equals(string2)) {
            databaseSessionConfig.setSessionCustomizerClass(string2);
        }
        DatabaseLoginConfig databaseLoginConfig = new DatabaseLoginConfig();
        databaseLoginConfig.setBindAllParameters(true);
        databaseLoginConfig.setJdbcBatchWriting(true);
        databaseLoginConfig.setConnectionURL(dBWSBuilder.getUrl());
        databaseLoginConfig.setDriverClass(dBWSBuilder.getDriver());
        databaseLoginConfig.setUsername(dBWSBuilder.getUsername());
        databaseLoginConfig.setEncryptedPassword(dBWSBuilder.getPassword());
        databaseLoginConfig.setPlatformClass(dBWSBuilder.getPlatformClassname());
        databaseSessionConfig.setLoginConfig((LoginConfig)databaseLoginConfig);
        DefaultSessionLogConfig defaultSessionLogConfig = new DefaultSessionLogConfig();
        defaultSessionLogConfig.setLogLevel(dBWSBuilder.getLogLevel());
        databaseSessionConfig.setLogConfig((LogConfig)defaultSessionLogConfig);
        sessionConfigs.addSessionConfig((SessionConfig)databaseSessionConfig);
        DatabaseSessionConfig databaseSessionConfig2 = new DatabaseSessionConfig();
        databaseSessionConfig2.setName(string + "-" + "dbws-ox-session");
        ProjectConfig projectConfig2 = dBWSBuilder.buildOXProjectConfig();
        databaseSessionConfig2.setPrimaryProject(projectConfig2);
        DefaultSessionLogConfig defaultSessionLogConfig2 = new DefaultSessionLogConfig();
        defaultSessionLogConfig2.setLogLevel("off");
        databaseSessionConfig2.setLogConfig((LogConfig)defaultSessionLogConfig2);
        String string3 = dBWSBuilder.getOxSessionCustomizerClassName();
        if (string3 != null && !"".equals(string3)) {
            databaseSessionConfig2.setSessionCustomizerClass(string3);
        }
        sessionConfigs.addSessionConfig((SessionConfig)databaseSessionConfig2);
        return sessionConfigs;
    }

    @Override
    public void closeSessionsStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getServiceStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws.xml"));
    }

    @Override
    public void closeServiceStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getOrStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-or.xml"));
    }

    @Override
    public String getOrProjectPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getOrProjectPathPrefix();
    }

    @Override
    public void closeOrStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getOxStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-ox.xml"));
    }

    @Override
    public String getOxProjectPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getOxProjectPathPrefix();
    }

    @Override
    public void closeOxStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getWSDLStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public String getWSDLPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getWSDLPathPrefix();
    }

    @Override
    public void closeWSDLStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getSWARefStream() throws FileNotFoundException {
        if (!this.hasAttachments) {
            return __nullStream;
        }
        return new FileOutputStream(new File(this.stageDir, "swaref.xsd"));
    }

    @Override
    public void closeSWARefStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getWebXmlStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void writeWebXml(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
    }

    @Override
    public void closeWebXmlStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getProviderClassStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void writeProviderClass(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
    }

    @Override
    public void closeProviderClassStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    @Override
    public OutputStream getProviderSourceStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void writeProviderSource(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
    }

    @Override
    public void closeProviderSourceStream(OutputStream outputStream) {
        this.closeStream(outputStream);
    }

    protected void closeStream(OutputStream outputStream) {
        if (outputStream != null && outputStream != __nullStream) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() {
        if (this.archiver != null) {
            this.archiver.archive();
        }
    }

    protected static class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] byArray) {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
        }

        @Override
        public void write(int n) {
        }
    }
}

