/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;

public class DbStoredProcedure {
    protected String catalog;
    protected String schema;
    protected String name;
    protected List<DbStoredArgument> arguments = new ArrayList<DbStoredArgument>();
    protected int overload = 0;

    public DbStoredProcedure(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public List<DbStoredArgument> getArguments() {
        return this.arguments;
    }

    public boolean isFunction() {
        return false;
    }

    public int getOverload() {
        return this.overload;
    }

    public void setOverload(int n) {
        this.overload = n;
    }

    public String getStoredType() {
        return "PROCEDURE";
    }

    public boolean matches(String string, String string2, String string3, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        boolean bl5 = this.catalog == null ? (bl ? true : string == null) : (bl4 = this.catalog.equals(string));
        if (bl2) {
            bl4 = true;
        }
        boolean bl6 = this.schema == null ? string2 == null : (bl3 = this.schema.equals(string2));
        boolean bl7 = this.name == null ? string3 == null : this.name.equals(string3);
        return bl4 && bl3 && bl7;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.overload > 0) {
            stringBuilder.append('(');
            stringBuilder.append(this.overload);
            stringBuilder.append(')');
        }
        stringBuilder.append(this.getStoredType());
        stringBuilder.append(' ');
        if (this.schema != null && this.schema.length() > 0) {
            stringBuilder.append(this.schema);
            stringBuilder.append('.');
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            stringBuilder.append(this.catalog);
            stringBuilder.append('.');
        }
        stringBuilder.append(this.name);
        if (this.arguments.size() > 0) {
            stringBuilder.append(" (");
            for (DbStoredArgument dbStoredArgument : this.arguments) {
                stringBuilder.append("\n\t");
                stringBuilder.append(dbStoredArgument);
            }
            stringBuilder.append("\n)");
        } else {
            stringBuilder.append("()\n");
        }
        return stringBuilder.toString();
    }
}

