/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class OracleHelper {
    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, String string, DatabasePlatform databasePlatform, String string2, String string3, String string4, DBWSBuilder dBWSBuilder) {
        ArrayList<DbStoredProcedure> arrayList = null;
        String string5 = Util.escapePunctuation(string2, true);
        String string6 = Util.escapePunctuation(string3, true);
        final String string7 = Util.escapePunctuation(string4, true);
        if (string6 == null || string6.length() == 0) {
            string6 = string;
        }
        SqlReflector sqlReflector = new SqlReflector(connection, string);
        try {
            SqlTypeWithMethods sqlTypeWithMethods;
            ProcedureMethod[] procedureMethodArray;
            int n = 4;
            if ("TOPLEVEL".equalsIgnoreCase(string5)) {
                n = 12;
                string5 = "";
            }
            if ((procedureMethodArray = (sqlTypeWithMethods = (SqlTypeWithMethods)sqlReflector.addSqlUserType(string6, string5, n, true, 0, 0, new MethodFilter(){

                @Override
                public boolean acceptMethod(ProcedureMethod procedureMethod, boolean bl) {
                    String string = procedureMethod.getName();
                    return Util.sqlMatch(string7, string);
                }
            })).getDeclaredMethods()).length > 0) {
                dBWSBuilder.setSqlType(sqlTypeWithMethods);
                arrayList = new ArrayList<DbStoredProcedure>();
                for (ProcedureMethod procedureMethod : procedureMethodArray) {
                    String string8;
                    DbStoredProcedure dbStoredProcedure = null;
                    TypeClass typeClass = procedureMethod.getReturnType();
                    if (typeClass == null) {
                        dbStoredProcedure = new DbStoredProcedure(procedureMethod.getName());
                    } else {
                        dbStoredProcedure = new DbStoredFunction(procedureMethod.getName());
                        DbStoredArgument dbStoredArgument = new DbStoredArgument(typeClass.getName());
                        dbStoredArgument.setInOut(Util.InOut.RETURN);
                        dbStoredArgument.setSeq(0);
                        dbStoredArgument.setJdbcType(typeClass.getJdbcTypecode());
                        Name name = typeClass.getNameObject();
                        string8 = name instanceof SqlName ? ((SqlName)name).getTypeName() : name.getSimpleName();
                        dbStoredArgument.setJdbcTypeName(string8);
                        ((DbStoredFunction)dbStoredProcedure).setReturnArg(dbStoredArgument);
                    }
                    dbStoredProcedure.setCatalog(string5);
                    dbStoredProcedure.setSchema(string3);
                    int n2 = procedureMethod.getParamNames().length;
                    for (int i = 0; i < n2; ++i) {
                        string8 = procedureMethod.getParamNames()[i];
                        TypeClass typeClass2 = procedureMethod.getParamTypes()[i];
                        DbStoredArgument dbStoredArgument = null;
                        dbStoredArgument = typeClass2.isPrimitive() ? new DbStoredArgument(string8) : new PLSQLStoredArgument(string8);
                        int n3 = procedureMethod.getParamModes()[i];
                        Util.InOut inOut = Util.InOut.IN;
                        if (n3 == 2) {
                            inOut = Util.InOut.OUT;
                        } else if (n3 == 3) {
                            inOut = Util.InOut.INOUT;
                        }
                        dbStoredArgument.setInOut(inOut);
                        dbStoredArgument.setSeq(i);
                        dbStoredArgument.setJdbcType(typeClass2.getJdbcTypecode());
                        Name name = typeClass2.getNameObject();
                        String string9 = name instanceof SqlName ? ((SqlName)name).getTypeName() : name.getSimpleName();
                        if (typeClass2.isPrimitive()) {
                            dbStoredArgument.setJdbcTypeName(string9);
                        } else {
                            PLSQLStoredArgument pLSQLStoredArgument = (PLSQLStoredArgument)dbStoredArgument;
                            pLSQLStoredArgument.setPlSqlTypeName(string9);
                            pLSQLStoredArgument.setJdbcTypeName(name.getSimpleName());
                        }
                        dbStoredProcedure.getArguments().add(dbStoredArgument);
                    }
                    arrayList.add(dbStoredProcedure);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static QName getXMLTypeFromJDBCType(DbStoredArgument dbStoredArgument, String string) {
        QName qName = null;
        if (2003 == dbStoredArgument.getJdbcType() || 2002 == dbStoredArgument.getJdbcType()) {
            qName = new QName(string, dbStoredArgument.getJdbcTypeName());
        } else {
            int n = dbStoredArgument.getJdbcType();
            if (dbStoredArgument.isPLSQLArgument()) {
                PLSQLStoredArgument pLSQLStoredArgument = (PLSQLStoredArgument)dbStoredArgument;
                String string2 = pLSQLStoredArgument.getPlSqlTypeName();
                n = "BOOLEAN".equals(string2) ? OraclePLSQLTypes.PLSQLBoolean.getConversionCode() : OraclePLSQLTypes.BinaryInteger.getConversionCode();
            }
            qName = Util.getXMLTypeFromJDBCType(n);
        }
        return qName;
    }
}

