/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;

public class PLSQLHelperObjectsBuilder
extends PublisherDefaultListener {
    protected Map<String, DatabaseType[]> methodTypeMap = new HashMap<String, DatabaseType[]>();
    protected Stack<DatabaseType> typeStack = new Stack();
    protected String packageName = null;
    protected String schemaName = null;
    protected String currentMethodName = null;
    protected int currentMethodArgIdx = -1;

    protected String trimOffSchemaName(String string) {
        if (string.startsWith(this.schemaName)) {
            return string.substring(this.schemaName.length() + 1);
        }
        return string;
    }

    public DatabaseType[] getTypesForMethod(String string) {
        return this.methodTypeMap.get(string);
    }

    public Map<String, DatabaseType[]> getMethodTypeMap() {
        return this.methodTypeMap;
    }

    @Override
    public void beginPackage(String string) {
        int n = string.indexOf(46);
        if (n > -1) {
            this.schemaName = string.substring(0, n);
            this.packageName = string.substring(n + 1);
        }
    }

    @Override
    public void beginPlsqlTable(String string, String string2) {
        PLSQLCollection pLSQLCollection = null;
        boolean bl = false;
        block0: for (DatabaseType[] databaseTypeArray : this.methodTypeMap.values()) {
            if (bl) break;
            for (DatabaseType databaseType : databaseTypeArray) {
                PLSQLCollection pLSQLCollection2;
                ComplexDatabaseType complexDatabaseType;
                if (databaseType == null || !databaseType.isComplexDatabaseType() || !(complexDatabaseType = (ComplexDatabaseType)databaseType).isCollection() || !(pLSQLCollection2 = (PLSQLCollection)complexDatabaseType).getCompatibleType().equalsIgnoreCase(string2)) continue;
                bl = true;
                pLSQLCollection = pLSQLCollection2;
                continue block0;
            }
        }
        if (pLSQLCollection == null) {
            pLSQLCollection = new PLSQLCollection();
            pLSQLCollection.setTypeName(this.trimOffSchemaName(string));
            pLSQLCollection.setCompatibleType(string2);
        }
        this.typeStack.push((DatabaseType)pLSQLCollection);
    }

    @Override
    public void endPlsqlTable(String string) {
        PLSQLCollection pLSQLCollection = (PLSQLCollection)this.typeStack.pop();
        pLSQLCollection.setJavaTypeName(pLSQLCollection.getTypeName().toLowerCase() + "_CollectionWrapper");
        if (!this.typeStack.empty()) {
            DatabaseType databaseType = this.typeStack.peek();
            if (databaseType.isComplexDatabaseType()) {
                ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)databaseType;
                if (complexDatabaseType.isCollection()) {
                    ((PLSQLCollection)complexDatabaseType).setNestedType((DatabaseType)pLSQLCollection);
                } else if (complexDatabaseType.isRecord()) {
                    List list = ((PLSQLrecord)complexDatabaseType).getFields();
                    PLSQLargument pLSQLargument = (PLSQLargument)list.get(list.size() - 1);
                    if (pLSQLargument.databaseType == null) {
                        pLSQLargument.databaseType = pLSQLCollection;
                    }
                }
            }
        } else {
            this.typeStack.push((DatabaseType)pLSQLCollection);
        }
    }

    @Override
    public void beginPlsqlRecord(String string, String string2, int n) {
        PLSQLrecord pLSQLrecord = null;
        boolean bl = false;
        block0: for (DatabaseType[] databaseTypeArray : this.methodTypeMap.values()) {
            if (bl) break;
            for (DatabaseType databaseType : databaseTypeArray) {
                PLSQLrecord pLSQLrecord2;
                ComplexDatabaseType complexDatabaseType;
                if (databaseType == null || !databaseType.isComplexDatabaseType() || !(complexDatabaseType = (ComplexDatabaseType)databaseType).isRecord() || !(pLSQLrecord2 = (PLSQLrecord)complexDatabaseType).getCompatibleType().equalsIgnoreCase(string2)) continue;
                bl = true;
                pLSQLrecord = pLSQLrecord2;
                continue block0;
            }
        }
        if (pLSQLrecord == null) {
            pLSQLrecord = new PLSQLrecord();
            pLSQLrecord.setTypeName(this.trimOffSchemaName(string));
            pLSQLrecord.setCompatibleType(string2);
            pLSQLrecord.setJavaTypeName(pLSQLrecord.getTypeName().toLowerCase());
        }
        this.typeStack.push((DatabaseType)pLSQLrecord);
    }

    @Override
    public void beginPlsqlRecordField(String string, int n) {
        PLSQLrecord pLSQLrecord = (PLSQLrecord)this.typeStack.peek();
        boolean bl = false;
        for (PLSQLargument pLSQLargument : pLSQLrecord.getFields()) {
            if (!pLSQLargument.name.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            pLSQLrecord.addField(string, null);
        }
    }

    @Override
    public void endPlsqlRecord(String string) {
        PLSQLrecord pLSQLrecord = (PLSQLrecord)this.typeStack.pop();
        if (!this.typeStack.empty()) {
            DatabaseType databaseType = this.typeStack.peek();
            if (databaseType.isComplexDatabaseType()) {
                ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)databaseType;
                if (complexDatabaseType.isCollection()) {
                    PLSQLCollection pLSQLCollection = (PLSQLCollection)complexDatabaseType;
                    if (pLSQLCollection.getNestedType() == null) {
                        pLSQLCollection.setNestedType((DatabaseType)pLSQLrecord);
                    }
                } else if (complexDatabaseType.isRecord()) {
                    PLSQLrecord pLSQLrecord2 = (PLSQLrecord)complexDatabaseType;
                    List list = pLSQLrecord2.getFields();
                    PLSQLargument pLSQLargument = (PLSQLargument)list.get(list.size() - 1);
                    if (pLSQLargument.databaseType == null) {
                        pLSQLargument.databaseType = pLSQLrecord;
                    }
                }
            }
        } else {
            this.typeStack.push((DatabaseType)pLSQLrecord);
        }
    }

    @Override
    public void beginMethod(String string, int n) {
        this.methodTypeMap.put(string, new DatabaseType[n]);
        this.currentMethodName = string;
    }

    @Override
    public void beginMethodArg(String string, String string2, int n) {
        this.currentMethodArgIdx = n;
    }

    @Override
    public void endMethodArg(String string) {
        DatabaseType[] databaseTypeArray = this.methodTypeMap.get(this.currentMethodName);
        databaseTypeArray[this.currentMethodArgIdx] = this.typeStack.pop();
    }

    @Override
    public void endMethod(String string) {
        this.currentMethodName = null;
        this.currentMethodArgIdx = -1;
    }

    @Override
    public void handleSqlType(String string, int n, String string2) {
        DatabaseType databaseType = JDBCTypes.getDatabaseTypeForCode((int)n);
        if (databaseType == null) {
            databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)string);
        }
        if (!this.typeStack.empty()) {
            DatabaseType databaseType2 = this.typeStack.peek();
            if (databaseType2.isComplexDatabaseType()) {
                ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)databaseType2;
                if (complexDatabaseType.isCollection()) {
                    PLSQLCollection pLSQLCollection = (PLSQLCollection)complexDatabaseType;
                    if (pLSQLCollection.getNestedType() == null) {
                        pLSQLCollection.setNestedType(databaseType);
                    }
                } else if (complexDatabaseType.isRecord()) {
                    PLSQLrecord pLSQLrecord = (PLSQLrecord)complexDatabaseType;
                    List list = pLSQLrecord.getFields();
                    PLSQLargument pLSQLargument = (PLSQLargument)list.get(list.size() - 1);
                    if (pLSQLargument.databaseType == null) {
                        pLSQLargument.databaseType = databaseType;
                    }
                }
            }
        } else {
            this.typeStack.push(databaseType);
        }
    }

    @Override
    public void handleObjectType(String string, String string2) {
        DatabaseType databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)string);
        if (!this.typeStack.empty()) {
            DatabaseType databaseType2 = this.typeStack.peek();
            if (databaseType2.isComplexDatabaseType()) {
                ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)databaseType2;
                if (complexDatabaseType.isCollection()) {
                    PLSQLCollection pLSQLCollection = (PLSQLCollection)complexDatabaseType;
                    if (pLSQLCollection.getNestedType() == null) {
                        pLSQLCollection.setNestedType(databaseType);
                    }
                } else if (complexDatabaseType.isRecord()) {
                    PLSQLrecord pLSQLrecord = (PLSQLrecord)complexDatabaseType;
                    List list = pLSQLrecord.getFields();
                    PLSQLargument pLSQLargument = (PLSQLargument)list.get(list.size() - 1);
                    if (pLSQLargument.databaseType == null) {
                        pLSQLargument.databaseType = databaseType;
                    }
                }
            }
        } else {
            this.typeStack.push(databaseType);
        }
    }
}

