/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.ReadOnlyFilesException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ProjectWriter {
    private ProjectIOManager ioManager;
    private MWProject project;
    private FileNotFoundListener listener;
    private SubComponentWriter[] subComponentWriters;
    private Collection changes;

    ProjectWriter(ProjectIOManager projectIOManager, MWProject mWProject, FileNotFoundListener fileNotFoundListener) {
        this.ioManager = projectIOManager;
        this.project = mWProject;
        if (mWProject.getSaveDirectory() == null) {
            throw new NullPointerException("The project's save directory must be set before it is written.");
        }
        this.listener = fileNotFoundListener;
    }

    void write() throws ReadOnlyFilesException {
        this.subComponentWriters = this.buildSubComponentWriters();
        this.changes = this.buildProposedChanges();
        this.checkForReadOnlyFiles();
        this.commit();
        this.resetProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.project.getName());
    }

    private SubComponentWriter[] buildSubComponentWriters() {
        return new SubComponentWriter[]{new SubComponentWriter(this.project.getClassRepository()), new SubComponentWriter(this.project.getMetaDataSubComponentContainer()), new SubComponentWriter(this.project.getDescriptorRepository())};
    }

    private Collection buildProposedChanges() {
        ArrayList<Write> arrayList = new ArrayList<Write>();
        if (this.project.hasChangedMainProjectSaveFile()) {
            arrayList.add(new Write(this.project, this.project.saveFile()));
        }
        for (int i = 0; i < this.subComponentWriters.length; ++i) {
            this.subComponentWriters[i].addChangesTo(arrayList);
        }
        return arrayList;
    }

    private void checkForReadOnlyFiles() throws ReadOnlyFilesException {
        ArrayList arrayList = new ArrayList(this.changes.size());
        for (Change change : this.changes) {
            change.addReadOnlyFilesTo(arrayList);
        }
        if (!arrayList.isEmpty()) {
            throw new ReadOnlyFilesException(arrayList);
        }
    }

    private void commit() {
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            ((Change)iterator.next()).commit();
        }
    }

    private void resetProject() {
        this.project.markEntireBranchClean();
        for (int i = 0; i < this.subComponentWriters.length; ++i) {
            this.subComponentWriters[i].resetContainer();
        }
    }

    File baseDirectory() {
        return this.project.getSaveDirectory();
    }

    XMLMarshaller marshaller() {
        return this.ioManager.getMarshaller();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object object) {
        return this.ioManager.subDirectoryNameFor(object);
    }

    void fireFileNotFound(File file) {
        this.ioManager.fireFileNotFound(this.listener, file);
    }

    private class Write
    extends Change {
        private Object object;

        Write(Object object, File file) {
            super(file);
            this.object = object;
        }

        void commit() {
            try {
                this.commit2();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit2() throws IOException {
            this.checkDirectory();
            if (this.file.exists()) {
                this.file.delete();
            }
            OutputStream outputStream = null;
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(this.file), 2048);
                this.marshaller().marshal(this.object, outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }

        private void checkDirectory() {
            File file = this.file.getParentFile();
            if (!file.exists() && !file.mkdirs()) {
                throw new RuntimeException("unable to create directory: " + file.getAbsolutePath());
            }
        }
    }

    private class Delete
    extends Change {
        Delete(File file) {
            super(file);
        }

        void commit() {
            if (this.file.exists()) {
                this.file.delete();
            } else {
                ProjectWriter.this.fireFileNotFound(this.file);
            }
        }
    }

    private abstract class Change {
        protected File file;

        Change(File file) {
            this.file = file;
        }

        void addReadOnlyFilesTo(Collection collection) {
            if (this.file.exists() && !this.file.canWrite()) {
                collection.add(this.file);
            }
        }

        abstract void commit();

        public String toString() {
            return StringTools.buildToStringFor(this, this.file);
        }

        XMLMarshaller marshaller() {
            return ProjectWriter.this.marshaller();
        }
    }

    private class SubComponentWriter {
        private ProjectSubFileComponentContainer container;

        SubComponentWriter(ProjectSubFileComponentContainer projectSubFileComponentContainer) {
            this.container = projectSubFileComponentContainer;
        }

        void addChangesTo(Collection collection) {
            File file;
            String string;
            Object object;
            Object object2;
            String string2 = ProjectWriter.this.defaultFileNameExtension();
            String string3 = ProjectWriter.this.subDirectoryNameFor(this.container);
            File file2 = new File(ProjectWriter.this.baseDirectory(), string3);
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<File> hashSet2 = new HashSet<File>();
            Object object3 = this.container.projectSubFileComponents();
            while (object3.hasNext()) {
                object2 = (MWModel)object3.next();
                object = ((MWNominative)object2).getName();
                hashSet.add((String)object);
                string = FileTools.FILE_NAME_ENCODER.encode((String)object);
                file = new File(file2, string + string2);
                hashSet2.add(file);
                if (!((AbstractNodeModel)object2).isDirtyBranch()) continue;
                collection.add(new Write(object2, file));
            }
            object3 = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            object2 = this.calculateDeleted((Collection)object3, hashSet);
            object = object2.iterator();
            while (object.hasNext()) {
                string = FileTools.FILE_NAME_ENCODER.encode((String)object.next());
                file = new File(file2, string + string2);
                if (hashSet2.contains(file)) continue;
                collection.add(new Delete(file));
            }
        }

        private Collection calculateDeleted(Collection collection, Collection collection2) {
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(collection2);
            return hashSet;
        }

        void resetContainer() {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.container.projectSubFileComponents();
            while (iterator.hasNext()) {
                hashSet.add(((MWNominative)iterator.next()).getName());
            }
            this.container.setOriginalProjectSubFileComponentNames(hashSet);
        }
    }
}

