/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio.legacy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.legacy.Project60IOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class Project60Reader {
    private Project60IOManager ioManager;
    private File file;
    private Preferences preferences;
    private FileNotFoundListener listener;

    Project60Reader(Project60IOManager project60IOManager, File file, Preferences preferences, FileNotFoundListener fileNotFoundListener) {
        this.ioManager = project60IOManager;
        this.file = file;
        this.preferences = preferences;
        this.listener = fileNotFoundListener;
    }

    MWProject read() {
        return this.readProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.file);
    }

    private MWProject readProject() {
        MWProject mWProject;
        try {
            mWProject = (MWProject)this.readObject(this.file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.injectSPIManager(mWProject, new DefaultSPIManager(this.preferences, mWProject.getName()));
        SubComponentReader[] subComponentReaderArray = this.buildSubComponentReaders(mWProject);
        for (int i = 0; i < subComponentReaderArray.length; ++i) {
            subComponentReaderArray[i].read();
        }
        mWProject.postProjectBuild();
        return mWProject;
    }

    private SubComponentReader[] buildSubComponentReaders(MWProject mWProject) {
        return new SubComponentReader[]{new SubComponentReader(mWProject.getClassRepository()), new SubComponentReader(mWProject.getMetaDataSubComponentContainer()), new SubComponentReader(mWProject.getDescriptorRepository())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readObject(File file) throws IOException {
        InputStream inputStream = null;
        Object object = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            object = this.ioManager.getUnmarshaller().unmarshal(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return object;
    }

    File baseDirectory() {
        return this.file.getParentFile();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object object) {
        return this.ioManager.subDirectoryNameFor(object);
    }

    void fireFileNotFound(File file) {
        this.ioManager.fireFileNotFound(this.listener, file);
    }

    private void injectSPIManager(MWProject mWProject, SPIManager sPIManager) {
        ClassTools.invokeMethod((Object)mWProject, "setSPIManagerForIOManager", SPIManager.class, sPIManager);
    }

    private class SubComponentReader {
        private ProjectSubFileComponentContainer container;

        SubComponentReader(ProjectSubFileComponentContainer projectSubFileComponentContainer) {
            this.container = projectSubFileComponentContainer;
        }

        void read() {
            String string = Project60Reader.this.defaultFileNameExtension();
            String string2 = Project60Reader.this.subDirectoryNameFor(this.container);
            File file = new File(this.baseDirectory(), string2);
            Set set = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            Vector<MWModel> vector = new Vector<MWModel>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = FileTools.FILE_NAME_ENCODER.encode(string3);
                File file2 = new File(file, string4 + string);
                MWModel mWModel = (MWModel)this.readObject(file2);
                if (mWModel == null) {
                    Project60Reader.this.fireFileNotFound(file2);
                    iterator.remove();
                    continue;
                }
                mWModel.setParent((Node)((Object)this.container));
                vector.add(mWModel);
            }
            this.container.setProjectSubFileComponents(vector);
        }

        private File baseDirectory() {
            return Project60Reader.this.baseDirectory();
        }

        private Object readObject(File file) {
            try {
                return Project60Reader.this.readObject(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

