/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWModel
extends AbstractNodeModel
implements MWNode {
    protected MWModel() {
    }

    protected MWModel(MWNode mWNode) {
        super(mWNode);
    }

    public final MWNode getMWParent() {
        return (MWNode)this.getParent();
    }

    public final MWProject getProject() {
        if (this.getParent() == null) {
            try {
                return (MWProject)this;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("This object is missing a parent: " + this);
            }
        }
        return this.getMWParent().getProject();
    }

    public final MWDatabase getDatabase() {
        MWRelationalProject mWRelationalProject;
        try {
            mWRelationalProject = (MWRelationalProject)this.getProject();
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("This object is not in a relational project: " + this);
        }
        return mWRelationalProject.getTableRepository();
    }

    public final MWClassRepository getRepository() {
        return this.getProject().getClassRepository();
    }

    public final MWClass typeNamed(String string) {
        return this.getRepository().typeNamedInternal(string);
    }

    public final MWClass typeFor(Class clazz) {
        return this.typeNamed(clazz.getName());
    }

    protected boolean removeNodeFromCollection(Node node, Collection collection, String string) {
        boolean bl = this.removeItemFromCollection(node, collection, string);
        if (bl) {
            this.getProject().nodeRemoved(node);
        }
        return bl;
    }

    protected boolean removeNodeFromCollection(Node node, Collection collection) {
        boolean bl = collection.remove(node);
        if (bl) {
            this.getProject().nodeRemoved(node);
        }
        return bl;
    }

    protected void nodesRemoved(Collection collection) {
        this.nodesRemoved(collection.iterator());
    }

    protected void nodesRemoved(Iterator iterator) {
        while (iterator.hasNext()) {
            this.getProject().nodeRemoved((Node)iterator.next());
        }
    }

    protected boolean removeNodesFromCollection(Collection collection, Collection collection2, String string) {
        return this.removeNodesFromCollection(collection.iterator(), collection2, string);
    }

    protected boolean removeNodesFromCollection(Iterator iterator, Collection collection, String string) {
        Collection collection2 = CollectionTools.collection(iterator);
        collection2.retainAll(collection);
        boolean bl = this.removeItemsFromCollection(iterator, collection, string);
        this.nodesRemoved(collection2);
        return bl;
    }

    protected boolean removeNodesFromCollection(Collection collection, Collection collection2) {
        return this.removeNodesFromCollection(collection.iterator(), collection2);
    }

    protected boolean removeNodesFromCollection(Iterator iterator, Collection collection) {
        Collection collection2 = CollectionTools.collection(iterator);
        collection2.retainAll(collection);
        boolean bl = collection.removeAll(collection2);
        this.nodesRemoved(collection2);
        return bl;
    }

    protected void clearNodeCollection(Collection collection, String string) {
        ArrayList arrayList = new ArrayList(collection);
        this.clearCollection(collection, string);
        this.nodesRemoved(arrayList);
    }

    protected void clearNodeCollection(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        collection.clear();
        this.nodesRemoved(arrayList);
    }

    protected Object removeNodeFromList(int n, List list, String string) {
        Node node = (Node)this.removeItemFromList(n, list, string);
        this.getProject().nodeRemoved(node);
        return node;
    }

    protected Object removeNodeFromList(int n, List list) {
        Node node = (Node)list.remove(n);
        this.getProject().nodeRemoved(node);
        return node;
    }

    protected void clearNodeList(List list, String string) {
        ArrayList arrayList = new ArrayList(list);
        this.clearList(list, string);
        this.nodesRemoved(arrayList);
    }

    protected void clearNodeList(List list) {
        this.clearNodeCollection(list);
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).mappingReplaced(mWMapping, mWMapping2);
        }
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).descriptorReplaced(mWDescriptor, mWDescriptor2);
        }
    }

    public void descriptorUnmapped(Collection collection) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            MWNode mWNode = (MWNode)iterator.next();
            mWNode.descriptorUnmapped(collection);
        }
    }

    public final void resolveClassHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveClassHandles();
        }
    }

    public final void resolveMetadataHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveMetadataHandles();
        }
    }

    public final void resolveColumnHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveColumnHandles();
        }
    }

    public final void resolveReferenceHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveReferenceHandles();
        }
    }

    public final void resolveDescriptorHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveDescriptorHandles();
        }
    }

    public final void resolveMethodHandles() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).resolveMethodHandles();
        }
    }

    public void postProjectBuild() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            ((MWNode)iterator.next()).postProjectBuild();
        }
    }

    public String displayString() {
        return this.toString();
    }

    protected void legacy60PostBuild(DescriptorEvent descriptorEvent) {
    }

    protected static XMLDescriptor legacy60BuildStandardDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.getEventManager().setPostBuildSelector("legacy60PostBuild");
        return xMLDescriptor;
    }

    public SortedSet buildBasicTypes() {
        TreeSet<MWTypeDeclaration> treeSet = new TreeSet<MWTypeDeclaration>(this.buildBasicTypesComparator());
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Boolean.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Byte.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Character.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Double.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Float.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Integer.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Long.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Short.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(String.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(BigDecimal.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(BigInteger.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Date.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Time.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Timestamp.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Calendar.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(java.util.Date.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Blob.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Clob.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Number.class)));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Byte.TYPE), 1));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Byte.class), 1));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Character.TYPE), 1));
        treeSet.add(new MWTypeDeclaration(this, this.typeFor(Character.class), 1));
        return treeSet;
    }

    private Comparator buildBasicTypesComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                MWTypeDeclaration mWTypeDeclaration = (MWTypeDeclaration)object;
                MWTypeDeclaration mWTypeDeclaration2 = (MWTypeDeclaration)object2;
                int n = Collator.getInstance().compare(mWTypeDeclaration.shortTypeName(), mWTypeDeclaration2.shortTypeName());
                if (n != 0) {
                    return n;
                }
                n = Collator.getInstance().compare(mWTypeDeclaration.typeName(), mWTypeDeclaration2.typeName());
                if (n != 0) {
                    return n;
                }
                return mWTypeDeclaration.getDimensionality() - mWTypeDeclaration2.getDimensionality();
            }
        };
    }

    public static String legacyReplaceToplinkDeprecatedClassReferences(String string) {
        if ("org.eclipse.persistence.publicinterface.Descriptor".equals(string)) {
            return "org.eclipse.persistence.descriptors.ClassDescriptor";
        }
        if ("org.eclipse.persistence.publicinterface.DescriptorEvent".equals(string)) {
            return "org.eclipse.persistence.descriptors.DescriptorEvent";
        }
        return string;
    }

    public static String legacyReplaceToplinkDepracatedClassReferencesFromSignature(String string) {
        if (string != null && string.contains("org.eclipse.persistence.publicinterface.Descriptor")) {
            string = string.contains("DescriptorEvent") ? string.replace("org.eclipse.persistence.publicinterface.DescriptorEvent", "org.eclipse.persistence.descriptors.DescriptorEvent") : string.replace("org.eclipse.persistence.publicinterface.Descriptor", "org.eclipse.persistence.descriptors.ClassDescriptor");
        }
        return string;
    }
}

