/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class DatabaseTypeHandle
extends MWHandle {
    private volatile DatabaseType databaseType;
    private volatile String databaseTypeName;

    DatabaseTypeHandle(MWColumn mWColumn) {
        super(mWColumn, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
    }

    DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    protected Node node() {
        return this.getDatabaseType();
    }

    private DatabasePlatform databasePlatform() {
        return this.getDatabase().getDatabasePlatform();
    }

    public void postProjectBuild() {
        if (this.databaseTypeName == null) {
            this.databaseType = this.databasePlatform().defaultDatabaseType();
        } else {
            try {
                this.databaseType = this.databasePlatform().databaseTypeNamed(this.databaseTypeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.databaseType = this.databasePlatform().defaultDatabaseType();
            }
        }
        this.databaseTypeName = null;
    }

    public int compareTo(Object object) {
        return this.databaseType.compareTo(((DatabaseTypeHandle)object).databaseType);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.databaseType == null) {
            stringBuffer.append("null");
        } else {
            this.databaseType.toString(stringBuffer);
        }
    }

    String getDatabaseTypeNameForTopLink() {
        return this.databaseType == null ? null : this.databaseType.getName();
    }

    void setDatabaseTypeNameForTopLink(String string) {
        this.databaseTypeName = string;
    }
}

