/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.DatabaseTypeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumn
extends MWModel
implements MWDataField {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private DatabaseTypeHandle databaseTypeHandle;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";
    private volatile int size;
    public static final String SIZE_PROPERTY = "size";
    private volatile int subSize;
    public static final String SUB_SIZE_PROPERTY = "subSize";
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";
    private volatile boolean unique;
    public static final String UNIQUE_PROPERTY = "unique";
    private volatile boolean primaryKey;
    public static final String PRIMARY_KEY_PROPERTY = "primaryKey";
    private volatile boolean identity;
    public static final String IDENTITY_PROPERTY = "identity";

    public static String parseTableNameFromQualifiedName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String parseColumnNameFromQualifiedName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static boolean nameIsQualified(String string) {
        return string.indexOf(".") != -1;
    }

    private MWColumn() {
    }

    MWColumn(MWTable mWTable, String string) {
        super(mWTable);
        this.name = string;
    }

    protected void initialize() {
        super.initialize();
        this.databaseTypeHandle = new DatabaseTypeHandle(this);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        DatabaseType databaseType = this.defaultDatabaseType();
        this.databaseTypeHandle.setDatabaseType(databaseType);
        this.size = databaseType.requiresSize() ? databaseType.getInitialSize() : 0;
        this.subSize = 0;
        this.allowsNull = databaseType.allowsNull();
        this.unique = false;
        this.primaryKey = false;
        this.identity = false;
    }

    public MWTable getTable() {
        return (MWTable)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.getTable().checkColumnName(string);
        String string2 = this.name;
        this.name = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(NAME_PROPERTY, string2, string);
            this.qualifiedNameChanged();
            this.getProject().nodeRenamed(this);
        }
    }

    void qualifiedNameChanged() {
        String string = this.qualifiedName();
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, string);
        this.firePropertyChanged("fieldName", string);
    }

    public DatabaseType getDatabaseType() {
        return this.databaseTypeHandle.getDatabaseType();
    }

    public void setDatabaseType(DatabaseType databaseType) {
        if (databaseType == null) {
            throw new NullPointerException();
        }
        DatabaseType databaseType2 = this.databaseTypeHandle.getDatabaseType();
        this.databaseTypeHandle.setDatabaseType(databaseType);
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, databaseType2, databaseType);
        if (this.attributeValueHasChanged(databaseType2, databaseType)) {
            this.synchronizeWithNewDatabaseType();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        if (!this.getDatabaseType().allowsSize() && n != 0) {
            throw new IllegalArgumentException("size must be 0 when size is not allowed");
        }
        int n2 = this.size;
        this.size = n;
        this.firePropertyChanged(SIZE_PROPERTY, n2, n);
    }

    public int getSubSize() {
        return this.subSize;
    }

    public void setSubSize(int n) {
        if (!this.getDatabaseType().allowsSubSize() && n != 0) {
            throw new IllegalArgumentException("sub-size must be 0 when sub-size is not allowed");
        }
        int n2 = this.subSize;
        this.subSize = n;
        this.firePropertyChanged(SUB_SIZE_PROPERTY, n2, n);
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean bl) {
        if (!this.getDatabaseType().allowsNull() && bl) {
            throw new IllegalArgumentException("allows null must be false when allows null is not allowed");
        }
        boolean bl2 = this.allowsNull;
        this.allowsNull = bl;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, bl2, bl);
        if (bl) {
            this.setPrimaryKey(false);
            this.setIdentity(false);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        boolean bl2 = this.unique;
        this.unique = bl;
        this.firePropertyChanged(UNIQUE_PROPERTY, bl2, bl);
        if (!bl) {
            this.setPrimaryKey(false);
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean bl) {
        boolean bl2 = this.primaryKey;
        this.primaryKey = bl;
        this.firePropertyChanged(PRIMARY_KEY_PROPERTY, bl2, bl);
        if (bl) {
            this.setAllowsNull(false);
            this.setUnique(true);
        }
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean bl) {
        if (!this.supportsIdentityClause() && bl) {
            throw new IllegalArgumentException("the current platform does not support the IDENTITY clause");
        }
        boolean bl2 = this.identity;
        this.identity = bl;
        this.firePropertyChanged(IDENTITY_PROPERTY, bl2, bl);
        if (bl) {
            this.setAllowsNull(false);
        }
    }

    public DatabasePlatform databasePlatform() {
        return this.getTable().databasePlatform();
    }

    public String qualifiedName() {
        return this.getTable().qualifiedName() + '.' + this.getName();
    }

    private DatabaseType defaultDatabaseType() {
        return this.databasePlatform().defaultDatabaseType();
    }

    public JavaTypeDeclaration javaTypeDeclaration() {
        return this.getDatabaseType().javaTypeDeclaration();
    }

    public boolean supportsIdentityClause() {
        return this.getDatabase().supportsIdentityClause();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.databaseTypeHandle);
    }

    void databasePlatformChanged() {
        this.setDatabaseType(this.databasePlatform().databaseTypeFor(this.getDatabaseType()));
    }

    private void synchronizeWithNewDatabaseType() {
        DatabaseType databaseType = this.getDatabaseType();
        if (databaseType.allowsSize()) {
            if (!databaseType.allowsSubSize()) {
                this.setSubSize(0);
            }
            if (databaseType.requiresSize()) {
                if (this.size == 0) {
                    this.setSize(databaseType.getInitialSize());
                }
            } else if (this.subSize == 0) {
                this.setSize(0);
            }
        } else {
            this.setSize(0);
            this.setSubSize(0);
        }
        if (!databaseType.allowsNull()) {
            this.setAllowsNull(false);
        }
        if (!databaseType.getPlatform().supportsIdentityClause()) {
            this.setIdentity(false);
        }
    }

    void copySettingsFrom(MWColumn mWColumn) {
        this.setDatabaseType(mWColumn.getDatabaseType());
        this.setSize(mWColumn.getSize());
        this.setSubSize(mWColumn.getSubSize());
        this.setAllowsNull(mWColumn.allowsNull());
        this.setUnique(mWColumn.isUnique());
        this.setPrimaryKey(mWColumn.isPrimaryKey());
        this.setIdentity(mWColumn.isIdentity());
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.getDatabaseType().requiresSize() && this.size == 0) {
            list.add(this.buildProblem("0702", this.qualifiedName()));
        }
    }

    public String fieldName() {
        return this.qualifiedName();
    }

    public DatabaseField runtimeField() {
        return new DatabaseField(this.qualifiedName());
    }

    void refresh(ExternalColumn externalColumn) {
        this.setDatabaseType(this.databaseTypeFrom(externalColumn));
        this.setSize(this.sizeFrom(externalColumn));
        this.setSubSize(this.subSizeFrom(externalColumn));
        this.setAllowsNull(this.allowsNullFrom(externalColumn));
        this.setPrimaryKey(externalColumn.isPrimaryKey());
    }

    private DatabaseType databaseTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeNamed(externalColumn.getTypeName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.databaseTypeFromJDBCTypeFrom(externalColumn);
        }
    }

    private DatabaseType databaseTypeFromJDBCTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeForJDBCTypeCode(externalColumn.getJDBCTypeCode());
        }
        catch (Exception exception) {
            return this.databasePlatform().defaultDatabaseType();
        }
    }

    private int sizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSize()) {
            return 0;
        }
        return externalColumn.getSize();
    }

    private int subSizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSubSize()) {
            return 0;
        }
        return externalColumn.getScale();
    }

    private boolean allowsNullFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsNull()) {
            return false;
        }
        return externalColumn.isNullable();
    }

    FieldDefinition buildRuntimeFieldDefinition() {
        FieldDefinition fieldDefinition = new FieldDefinition(this.name, this.getDatabaseType().getName());
        fieldDefinition.setSize(this.size);
        fieldDefinition.setSubSize(this.subSize);
        if (this.primaryKey) {
            fieldDefinition.setIsPrimaryKey(true);
        } else {
            fieldDefinition.setIsPrimaryKey(false);
            fieldDefinition.setShouldAllowNull(this.allowsNull);
            fieldDefinition.setUnique(this.unique);
        }
        fieldDefinition.setIsIdentity(this.identity);
        return fieldDefinition;
    }

    public String displayString() {
        return this.qualifiedName();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.qualifiedName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWColumn.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        xMLDescriptor.addDirectMapping("databaseTypeName", "getDatabaseTypeNameForTopLink", "setDatabaseTypeNameForTopLink", "type/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(SIZE_PROPERTY, "size/text()")).setNullValue((Object)new Integer(0));
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(SUB_SIZE_PROPERTY, "sub-size/text()")).setNullValue((Object)new Integer(0));
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(UNIQUE_PROPERTY, "unique/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(PRIMARY_KEY_PROPERTY, "primary-key/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(IDENTITY_PROPERTY, "identity/text()")).setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    private String getDatabaseTypeNameForTopLink() {
        return this.databaseTypeHandle.getDatabaseTypeNameForTopLink();
    }

    private void setDatabaseTypeNameForTopLink(String string) {
        this.databaseTypeHandle.setDatabaseTypeNameForTopLink(string);
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.primaryKey) {
            this.allowsNull = false;
            this.unique = true;
        }
        if (this.identity) {
            this.allowsNull = false;
        }
    }
}

