/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpecHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabaseFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDatabase
extends MWModel
implements ProjectSubFileComponentContainer {
    private volatile DatabasePlatform databasePlatform;
    public static final String DATABASE_PLATFORM_PROPERTY = "databasePlatform";
    private Collection loginSpecs;
    public static final String LOGIN_SPECS_COLLECTION = "loginSpecs";
    private MWLoginSpecHandle deploymentLoginSpecHandle;
    public static final String DEPLOYMENT_LOGIN_SPEC_PROPERTY = "deploymentLoginSpec";
    private MWLoginSpecHandle developmentLoginSpecHandle;
    public static final String DEVELOPMENT_LOGIN_SPEC_PROPERTY = "developmentLoginSpec";
    private Collection tables;
    public static final String TABLES_COLLECTION = "tables";
    private volatile ExternalDatabase externalDatabase;
    private volatile Driver driver;
    private volatile Connection connection;
    public static final String CONNECTED_PROPERTY = "connected";
    private volatile SchemaManager schemaManager;
    private Collection tableNames;
    private static final String TABLE_NAMES_COLLECTION = "tableNames";
    private static final String SUB_DIRECTORY_NAME = "tables";

    private MWDatabase() {
    }

    public MWDatabase(MWRelationalProject mWRelationalProject, DatabasePlatform databasePlatform) {
        super(mWRelationalProject);
        this.databasePlatform = databasePlatform;
    }

    public void initialize() {
        super.initialize();
        this.tables = new Vector();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.loginSpecs = new Vector();
        this.deploymentLoginSpecHandle = new MWLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.developmentLoginSpecHandle = new MWLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.tableNames = new HashSet();
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        if (databasePlatform == null) {
            throw new NullPointerException();
        }
        DatabasePlatform databasePlatform2 = this.databasePlatform;
        this.databasePlatform = databasePlatform;
        this.firePropertyChanged(DATABASE_PLATFORM_PROPERTY, databasePlatform2, databasePlatform);
        if (this.attributeValueHasChanged(databasePlatform2, databasePlatform)) {
            this.databasePlatformChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void databasePlatformChanged() {
        Collection collection = this.tables;
        synchronized (collection) {
            Iterator iterator = this.tables.iterator();
            while (iterator.hasNext()) {
                ((MWTable)iterator.next()).databasePlatformChanged();
            }
        }
    }

    public Iterator loginSpecs() {
        return new CloneIterator(this.loginSpecs){

            protected void remove(Object object) {
                MWDatabase.this.removeLoginSpec((MWLoginSpec)object);
            }
        };
    }

    public int loginSpecsSize() {
        return this.loginSpecs.size();
    }

    public MWLoginSpec addLoginSpec(String string) {
        this.checkLoginSpecName(string);
        return this.addLoginSpec(new MWLoginSpec(this, string));
    }

    private MWLoginSpec addLoginSpec(MWLoginSpec mWLoginSpec) {
        this.addItemToCollection(mWLoginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION);
        if (this.loginSpecs.size() == 1) {
            this.setDeploymentLoginSpec(mWLoginSpec);
            this.setDevelopmentLoginSpec(mWLoginSpec);
        }
        return mWLoginSpec;
    }

    public void removeLoginSpec(MWLoginSpec mWLoginSpec) {
        if (this.removeItemFromCollection(mWLoginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION)) {
            this.loginSpecRemoved(mWLoginSpec);
        }
    }

    public boolean containsLoginSpecNamed(String string) {
        return this.loginSpecNamed(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWLoginSpec loginSpecNamed(String string) {
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            for (MWLoginSpec mWLoginSpec : this.loginSpecs) {
                if (!mWLoginSpec.getName().equals(string)) continue;
                return mWLoginSpec;
            }
        }
        return null;
    }

    public Iterator loginSpecNames() {
        return new TransformationIterator(this.loginSpecs()){

            protected Object transform(Object object) {
                return ((MWLoginSpec)object).getName();
            }
        };
    }

    public MWLoginSpec getDeploymentLoginSpec() {
        return this.deploymentLoginSpecHandle.getLoginSpec();
    }

    public void setDeploymentLoginSpec(MWLoginSpec mWLoginSpec) {
        MWLoginSpec mWLoginSpec2 = this.deploymentLoginSpecHandle.getLoginSpec();
        this.deploymentLoginSpecHandle.setLoginSpec(mWLoginSpec);
        this.firePropertyChanged(DEPLOYMENT_LOGIN_SPEC_PROPERTY, mWLoginSpec2, mWLoginSpec);
    }

    public MWLoginSpec getDevelopmentLoginSpec() {
        return this.developmentLoginSpecHandle.getLoginSpec();
    }

    public void setDevelopmentLoginSpec(MWLoginSpec mWLoginSpec) {
        MWLoginSpec mWLoginSpec2 = this.developmentLoginSpecHandle.getLoginSpec();
        this.developmentLoginSpecHandle.setLoginSpec(mWLoginSpec);
        this.firePropertyChanged(DEVELOPMENT_LOGIN_SPEC_PROPERTY, mWLoginSpec2, mWLoginSpec);
    }

    public Iterator tables() {
        return new CloneIterator(this.tables){

            protected void remove(Object object) {
                MWDatabase.this.removeTable((MWTable)object);
            }
        };
    }

    public int tablesSize() {
        return this.tables.size();
    }

    public MWTable addTable(String string) {
        return this.addTable(null, string);
    }

    public MWTable addTable(String string, String string2) {
        return this.addTable(null, string, string2);
    }

    public MWTable addTable(String string, String string2, String string3) {
        this.checkTableName(string, string2, string3, null);
        return this.addTable(new MWTable(this, string, string2, string3));
    }

    public MWTable addTableWithFullyQualifiedName(String string) {
        String[] stringArray = (String[])CollectionTools.removeAllOccurrences(string.split("\\."), (Object)"");
        if (stringArray.length == 3) {
            return this.addTable(stringArray[0], stringArray[1], stringArray[2]);
        }
        if (stringArray.length == 2) {
            return this.addTable(stringArray[0], stringArray[1]);
        }
        return this.addTable(stringArray[0]);
    }

    private MWTable addTable(MWTable mWTable) {
        this.addItemToCollection(mWTable, this.tables, "tables");
        return mWTable;
    }

    public void removeTable(MWTable mWTable) {
        this.removeNodeFromCollection(mWTable, this.tables, "tables");
    }

    public boolean containsTableNamed(String string, String string2, String string3) {
        return this.tableNamed(string, string2, string3) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamed(String string, String string2, String string3) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable mWTable : this.tables) {
                if (!mWTable.nameMatches(string, string2, string3)) continue;
                return mWTable;
            }
        }
        return null;
    }

    public boolean containsTableNamedIgnoreCase(String string, String string2, String string3) {
        return this.tableNamedIgnoreCase(string, string2, string3) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamedIgnoreCase(String string, String string2, String string3) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable mWTable : this.tables) {
                if (!mWTable.nameMatchesIgnoreCase(string, string2, string3)) continue;
                return mWTable;
            }
        }
        return null;
    }

    public boolean containsTableNamed(String string) {
        return this.tableNamed(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamed(String string) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable mWTable : this.tables) {
                if (!mWTable.qualifiedName().equals(string)) continue;
                return mWTable;
            }
        }
        return null;
    }

    public Iterator tableNames() {
        return new TransformationIterator(this.tables()){

            protected Object transform(Object object) {
                return ((MWTable)object).getName();
            }
        };
    }

    public MWColumn columnNamed(String string) {
        MWTable mWTable = this.tableNamed(MWColumn.parseTableNameFromQualifiedName(string));
        if (mWTable == null) {
            return null;
        }
        return mWTable.columnNamed(MWColumn.parseColumnNameFromQualifiedName(string));
    }

    private ExternalDatabase getExternalDatabase() {
        if (this.externalDatabase == null) {
            this.externalDatabase = this.buildExternalDatabase();
        }
        return this.externalDatabase;
    }

    private ExternalDatabase buildExternalDatabase() {
        return this.externalDatabaseFactory().buildDatabase(this.connection);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            throw new IllegalStateException("not connected");
        }
        return this.schemaManager;
    }

    private ExternalDatabaseFactory externalDatabaseFactory() {
        return this.getProject().getSPIManager().getExternalDatabaseFactory();
    }

    boolean supportsIdentityClause() {
        return this.databasePlatform.supportsIdentityClause();
    }

    protected void addTransientAspectNamesTo(Set set) {
        super.addTransientAspectNamesTo(set);
        set.add(CONNECTED_PROPERTY);
    }

    void checkLoginSpecName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsLoginSpecNamed(string)) {
            throw new IllegalArgumentException("duplicate login spec name: " + string);
        }
    }

    void checkTableName(String string, String string2, String string3, MWTable mWTable) {
        this.checkTableNameQualifier(string);
        this.checkTableNameQualifier(string2);
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException();
        }
        MWTable mWTable2 = this.tableNamed(string, string2, string3);
        if (mWTable2 != null) {
            throw new IllegalArgumentException("duplicate table name: " + mWTable2.qualifiedName());
        }
        MWTable mWTable3 = this.tableNamedIgnoreCase(string, string2, string3);
        if (mWTable3 != null && mWTable3 != mWTable) {
            throw new IllegalArgumentException("duplicate table name: " + mWTable3.qualifiedName());
        }
    }

    private void checkTableNameQualifier(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            list.addAll(this.loginSpecs);
        }
        list.add(this.deploymentLoginSpecHandle);
        list.add(this.developmentLoginSpecHandle);
        collection = this.tables;
        synchronized (collection) {
            list.addAll(this.tables);
        }
    }

    private void loginSpecRemoved(MWLoginSpec mWLoginSpec) {
        if (this.getDeploymentLoginSpec() == mWLoginSpec) {
            this.setDeploymentLoginSpec(null);
        }
        if (this.getDevelopmentLoginSpec() == mWLoginSpec) {
            this.setDevelopmentLoginSpec(null);
        }
    }

    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    void tableRenamed() {
        this.fireCollectionChanged(TABLE_NAMES_COLLECTION);
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
    }

    public void descriptorUnmapped(Collection collection) {
    }

    public void login() throws SQLException, ClassNotFoundException {
        String string;
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        MWLoginSpec mWLoginSpec = this.getDevelopmentLoginSpec();
        if (mWLoginSpec == null) {
            throw new IllegalStateException("missing development login spec");
        }
        try {
            this.driver = mWLoginSpec.buildDriver();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        String string2 = mWLoginSpec.getURL();
        if (string2 == null || string2.length() == 0) {
            throw new IllegalStateException("missing database URL");
        }
        Properties properties = new Properties();
        String string3 = mWLoginSpec.getUserName();
        if (string3 != null) {
            properties.put("user", string3);
        }
        if ((string = mWLoginSpec.getPassword()) != null) {
            properties.put("password", string);
        }
        this.connection = this.driver.connect(string2, properties);
        this.schemaManager = this.buildSchemaManager();
        this.firePropertyChanged(CONNECTED_PROPERTY, false, true);
    }

    public void logout() throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
        this.connection.close();
        this.schemaManager = null;
        this.connection = null;
        this.driver = null;
        this.externalDatabase = null;
        this.firePropertyChanged(CONNECTED_PROPERTY, true, false);
    }

    private SchemaManager buildSchemaManager() {
        return new SchemaManager(this.buildRuntimeDatabaseSession());
    }

    private DatabaseSession buildRuntimeDatabaseSession() {
        DatabaseSession databaseSession = this.buildRuntimeProject().createDatabaseSession();
        databaseSession.dontLogMessages();
        databaseSession.login();
        return databaseSession;
    }

    private Project buildRuntimeProject() {
        return new Project(this.getDevelopmentLoginSpec().buildDevelopmentRuntimeDatabaseLogin());
    }

    Connector buildRuntimeConnector() {
        return new LocalConnectorAdapter(this.connection);
    }

    public Iterator catalogNames() {
        return new ArrayIterator(this.getExternalDatabase().getCatalogNames());
    }

    public Iterator schemaNames() {
        return new ArrayIterator(this.getExternalDatabase().getSchemaNames());
    }

    public Iterator tableTypeNames() {
        return new ArrayIterator(this.getExternalDatabase().getTableTypeNames());
    }

    public Iterator externalTableDescriptions(String string, String string2, String string3, String[] stringArray) {
        return new ArrayIterator(this.getExternalDatabase().getTableDescriptions(string, string2, string3, stringArray));
    }

    public Iterator externalTableDescriptions() {
        return new ArrayIterator(this.getExternalDatabase().getTableDescriptions());
    }

    public void importQualifiedTablesFor(Collection collection) {
        for (ExternalTableDescription externalTableDescription : collection) {
            this.qualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : collection) {
            this.qualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    public void refreshQualifiedTablesFor(Collection collection) {
        MWTable mWTable;
        for (ExternalTableDescription externalTableDescription : collection) {
            mWTable = this.tableNamed(externalTableDescription.getQualifiedName());
            if (mWTable == null) {
                mWTable = this.tableNamed(externalTableDescription.getName());
            }
            if (mWTable == null) continue;
            mWTable.refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : collection) {
            mWTable = this.tableNamed(externalTableDescription.getQualifiedName());
            if (mWTable == null) {
                mWTable = this.tableNamed(externalTableDescription.getName());
            }
            if (mWTable == null) continue;
            mWTable.refreshReferences(externalTableDescription.getTable());
        }
    }

    private MWTable qualifiedTableFor(ExternalTableDescription externalTableDescription) {
        return this.tableNamedForImport(externalTableDescription.getCatalogName(), externalTableDescription.getSchemaName(), externalTableDescription.getName());
    }

    private MWTable tableNamedForImport(String string, String string2, String string3) {
        MWTable mWTable = this.tableNamed(string, string2, string3);
        if (mWTable == null) {
            mWTable = this.addTable(string, string2, string3);
        }
        return mWTable;
    }

    public void importUnqualifiedTablesFor(Collection collection) {
        for (ExternalTableDescription externalTableDescription : collection) {
            this.unqualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : collection) {
            this.unqualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    private MWTable unqualifiedTableFor(ExternalTableDescription externalTableDescription) {
        return this.tableNamedForImport(null, null, externalTableDescription.getName());
    }

    private String runtimePlatformClassName() {
        return this.getDatabasePlatform().getRuntimePlatformClassName();
    }

    public DatabaseLogin buildDeploymentRuntimeDatabaseLogin() {
        MWLoginSpec mWLoginSpec = this.getDeploymentLoginSpec();
        if (mWLoginSpec == null) {
            DatabaseLogin databaseLogin = new DatabaseLogin();
            databaseLogin.setPlatformClassName(this.runtimePlatformClassName());
            return databaseLogin;
        }
        return mWLoginSpec.buildDeploymentRuntimeDatabaseLogin();
    }

    public Iterator runtimeTableDefinitions() {
        return new TransformationIterator(this.tables()){

            protected Object transform(Object object) {
                return ((MWTable)object).buildRuntimeTableDefinition();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTables() {
        ArrayList arrayList;
        Collection collection = this.tables;
        synchronized (collection) {
            arrayList = new ArrayList(this.tables);
        }
        this.generateTables(arrayList);
    }

    public void generateTables(Collection collection) throws EclipseLinkException {
        this.getSchemaManager().outputDDLToDatabase();
        this.buildTables(collection);
    }

    public String ddlFor(Collection collection) {
        StringWriter stringWriter = new StringWriter(2000);
        this.writeDDLOn(collection, stringWriter);
        return ((Object)stringWriter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDDLOn(Writer writer) {
        ArrayList arrayList;
        Collection collection = this.tables;
        synchronized (collection) {
            arrayList = new ArrayList(this.tables);
        }
        this.writeDDLOn(arrayList, writer);
    }

    public void writeDDLOn(Collection collection, Writer writer) {
        this.getSchemaManager().outputDDLToWriter(writer);
        this.buildTables(collection);
    }

    private void buildTables(Collection collection) throws EclipseLinkException {
        ArrayList<TableDefinition> arrayList = new ArrayList<TableDefinition>(collection.size());
        SchemaManager schemaManager = collection.iterator();
        while (schemaManager.hasNext()) {
            arrayList.add(((MWTable)schemaManager.next()).buildRuntimeTableDefinition());
        }
        schemaManager = this.getSchemaManager();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            schemaManager.replaceObject((DatabaseObjectDefinition)((TableDefinition)iterator.next()));
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            schemaManager.createConstraints((TableDefinition)iterator.next());
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getDatabasePlatform().getName());
        stringBuffer.append(" : ");
        stringBuffer.append(this.tables.size());
        stringBuffer.append(" tables");
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Database (");
        stringBuffer.append(this.getDatabasePlatform().getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Iterator projectSubFileComponents() {
        return this.tables();
    }

    public void setProjectSubFileComponents(Collection collection) {
        this.tables = collection;
    }

    public Iterator originalProjectSubFileComponentNames() {
        return this.tableNames.iterator();
    }

    public void setOriginalProjectSubFileComponentNames(Collection collection) {
        this.tableNames = collection;
    }

    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object object) {
        if (this.tables.contains(object)) {
            return false;
        }
        return ((Node)object).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDatabase.class);
        xMLDescriptor.addDirectMapping("databasePlatformName", "getDatabasePlatformNameForTopLink", "setDatabasePlatformNameForTopLink", "platform-name/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(LOGIN_SPECS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getLoginSpecsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setLoginSpecsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWLoginSpec.class);
        xMLCompositeCollectionMapping.setXPath("login-infos/login-info");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("deploymentLoginSpecHandle");
        xMLCompositeObjectMapping.setGetMethodName("getDeploymentLoginSpecHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setDeploymentLoginSpecHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWLoginSpecHandle.class);
        xMLCompositeObjectMapping.setXPath("deployment-login-spec-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("developmentLoginSpecHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getDevelopmentLoginSpecHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setDevelopmentLoginSpecHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWLoginSpecHandle.class);
        xMLCompositeObjectMapping2.setXPath("development-login-spec-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(TABLE_NAMES_COLLECTION);
        xMLCompositeDirectCollectionMapping.setGetMethodName("getTableNamesForTopLink");
        xMLCompositeDirectCollectionMapping.setSetMethodName("setTableNamesForTopLink");
        xMLCompositeDirectCollectionMapping.useCollectionClass(HashSet.class);
        xMLCompositeDirectCollectionMapping.setXPath("table-names/name/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        return xMLDescriptor;
    }

    private String getDatabasePlatformNameForTopLink() {
        return this.databasePlatform.getName();
    }

    private void setDatabasePlatformNameForTopLink(String string) {
        this.databasePlatform = DatabasePlatformRepository.getDefault().platformNamed(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getLoginSpecsForTopLink() {
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            return new TreeSet(this.loginSpecs);
        }
    }

    private void setLoginSpecsForTopLink(Collection collection) {
        this.loginSpecs = collection;
    }

    private MWLoginSpecHandle getDeploymentLoginSpecHandleForTopLink() {
        return this.deploymentLoginSpecHandle.getLoginSpec() == null ? null : this.deploymentLoginSpecHandle;
    }

    private void setDeploymentLoginSpecHandleForTopLink(MWLoginSpecHandle mWLoginSpecHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = MWHandle.NodeReferenceScrubber.NULL_INSTANCE;
        this.deploymentLoginSpecHandle = mWLoginSpecHandle == null ? new MWLoginSpecHandle(this, nodeReferenceScrubber) : mWLoginSpecHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWLoginSpecHandle getDevelopmentLoginSpecHandleForTopLink() {
        return this.developmentLoginSpecHandle.getLoginSpec() == null ? null : this.developmentLoginSpecHandle;
    }

    private void setDevelopmentLoginSpecHandleForTopLink(MWLoginSpecHandle mWLoginSpecHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = MWHandle.NodeReferenceScrubber.NULL_INSTANCE;
        this.developmentLoginSpecHandle = mWLoginSpecHandle == null ? new MWLoginSpecHandle(this, nodeReferenceScrubber) : mWLoginSpecHandle.setScrubber(nodeReferenceScrubber);
    }

    private Collection getTableNamesForTopLink() {
        ArrayList arrayList = new ArrayList(this.tables.size());
        CollectionTools.addAll(arrayList, this.tableNames());
        return CollectionTools.sort(arrayList, (Comparator)Collator.getInstance());
    }

    private void setTableNamesForTopLink(Collection collection) {
        this.tableNames = collection;
    }

    private static class LocalConnectorAdapter
    implements Connector {
        private Connection connection;

        LocalConnectorAdapter(Connection connection) {
            this.connection = connection;
        }

        public Connection connect(Properties properties, Session session) {
            return this.connection;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public String getConnectionDetails() {
            return "MWDatabase.LocalConnectorAdapter";
        }

        public void toString(PrintWriter printWriter) {
            printWriter.print(this.getConnectionDetails());
        }
    }
}

