/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWLoginSpec
extends MWModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile String driverClassName;
    public static final String DRIVER_CLASS_NAME_PROPERTY = "driverClassName";
    public static final String CANDIDATE_URLS_COLLECTION = "candidateURLs";
    private volatile String url;
    public static final String URL_PROPERTY = "url";
    private volatile String userName;
    public static final String USER_NAME_PROPERTY = "userName";
    private volatile String password;
    public static final String PASSWORD_PROPERTY = "password";
    private volatile boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private List driverClasspathEntries;
    public static final String DRIVER_CLASSPATH_ENTRIES_LIST = "driverClasspathEntries";
    private static Collection driverSpecs;
    private static JCEEncryptor encryptor;
    public static final String DB_DRIVER_CLASS_PREFERENCE = "database driver class";
    public static final String DB_CONNECTION_URL_PREFERENCE = "database connection url";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWLoginSpec.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(DRIVER_CLASS_NAME_PROPERTY, "driver-class/text()")).setNullValue((Object)"");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(URL_PROPERTY, "url/text()")).setNullValue((Object)"");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(USER_NAME_PROPERTY, "user-name/text()")).setNullValue((Object)"");
        xMLDescriptor.addDirectMapping(PASSWORD_PROPERTY, "getPasswordForTopLink", "setPasswordForTopLink", "password/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(SAVE_PASSWORD_PROPERTY, "save-password/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(DRIVER_CLASSPATH_ENTRIES_LIST);
        xMLCompositeDirectCollectionMapping.setXPath("driver-classpath-entries/entry/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        return xMLDescriptor;
    }

    public static Iterator commonDriverClassNames() {
        return new TransformationIterator(MWLoginSpec.driverSpecs()){

            protected Object transform(Object object) {
                return ((DriverSpec)object).getDriverClassName();
            }
        };
    }

    public static int commonDriverClassNamesSize() {
        return MWLoginSpec.getDriverSpecs().size();
    }

    private static Iterator urlsForDriverClassNamed(String string) {
        DriverSpec driverSpec = MWLoginSpec.driverSpecFor(string);
        return driverSpec == null ? NullIterator.instance() : driverSpec.urls();
    }

    private static int urlsForDriverClassNamedSize(String string) {
        DriverSpec driverSpec = MWLoginSpec.driverSpecFor(string);
        return driverSpec == null ? 0 : driverSpec.urlsSize();
    }

    private static boolean urlsForDriverClassNamedContains(String string, String string2) {
        DriverSpec driverSpec = MWLoginSpec.driverSpecFor(string);
        return driverSpec == null ? false : driverSpec.containsURL(string2);
    }

    private static String defaultURLForDriverClassNamed(String string) {
        DriverSpec driverSpec = MWLoginSpec.driverSpecFor(string);
        return driverSpec == null ? null : driverSpec.defaultURL();
    }

    private static DriverSpec driverSpecFor(String string) {
        Iterator iterator = MWLoginSpec.driverSpecs();
        while (iterator.hasNext()) {
            DriverSpec driverSpec = (DriverSpec)iterator.next();
            if (!driverSpec.getDriverClassName().equals(string)) continue;
            return driverSpec;
        }
        return null;
    }

    private static Iterator driverSpecs() {
        return MWLoginSpec.getDriverSpecs().iterator();
    }

    private static synchronized Collection getDriverSpecs() {
        if (driverSpecs == null) {
            driverSpecs = MWLoginSpec.buildDriverSpecs();
        }
        return driverSpecs;
    }

    private static Collection buildDriverSpecs() {
        ArrayList<DriverSpec> arrayList = new ArrayList<DriverSpec>(30);
        arrayList.add(new DriverSpec("com.neon.jdbc.Driver", "jdbc:neon:"));
        arrayList.add(new DriverSpec("com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase:"));
        arrayList.add(new DriverSpec("com.sybase.jdbc3.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        arrayList.add(new DriverSpec("com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        arrayList.add(new DriverSpec("com.sybase.jdbc.SybDriver", "jdbc:sybase:Tds:"));
        arrayList.add(new DriverSpec("COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:"));
        arrayList.add(new DriverSpec("COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2:"));
        arrayList.add(new DriverSpec("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://"));
        arrayList.add(new DriverSpec("com.mysql.jdbc.Driver", "jdbc:mysql://"));
        arrayList.add(new DriverSpec("borland.jdbc.Bridge.LocalDriver", "jdbc:BorlandBridge:"));
        arrayList.add(new DriverSpec("borland.jdbc.Broker.RemoteDriver", "jdbc:BorlandBridge:"));
        arrayList.add(new DriverSpec("intersolv.jdbc.sequelink.SequeLinkDriver", "jdbc:sequelink:"));
        String[] stringArray = new String[]{"jdbc:oracle:thin:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci7:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>"};
        arrayList.add(new DriverSpec("oracle.jdbc.OracleDriver", stringArray));
        arrayList.add(new DriverSpec("oracle.jdbc.driver.OracleDriver", stringArray));
        arrayList.add(new DriverSpec("com.oracle.ias.jdbc.db2.DB2Driver", "jdbc:oracle:db2://"));
        arrayList.add(new DriverSpec("com.oracle.ias.jdbc.sqlserver.SQLServerDriver", "jdbc:oracle:sqlserver://"));
        arrayList.add(new DriverSpec("com.oracle.ias.jdbc.sybase.SybaseDriver", "jdbc:oracle:sybase://"));
        arrayList.add(new DriverSpec("org.hsqldb.jdbcDriver", "jdbc:hsqldb:"));
        arrayList.add(new DriverSpec("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.oci.Driver", "jdbc:weblogic:oracle:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.dblib.Driver", new String[]{"jdbc:weblogic:mssqlserver:", "jdbc:weblogic:sybase"}));
        arrayList.add(new DriverSpec("weblogic.jdbc.informix4.Driver", "jdbc:weblogic:informix4:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.jts.Driver", "jdbc:weblogic:jts:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.mssqlserver4.Driver", "jdbc:weblogic:mssqlserver4:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.pool.Driver", "jdbc:weblogic:pool:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.t3client.Driver", "jdbc:weblogic:t3Client:"));
        arrayList.add(new DriverSpec("weblogic.jdbc.t3.Driver", "jdbc:weblogic:t3:"));
        arrayList.add(new DriverSpec("com.timesten.jdbc.TimesTenDriver", "jdbc:timesten:direct:<SID>"));
        return arrayList;
    }

    private static JCEEncryptor getEncryptor() {
        if (encryptor == null) {
            try {
                encryptor = new JCEEncryptor();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return encryptor;
    }

    private MWLoginSpec() {
    }

    MWLoginSpec(MWDatabase mWDatabase, String string) {
        super(mWDatabase);
        this.name = string;
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.savePassword = false;
        this.driverClasspathEntries = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        String string2 = this.driverClassName;
        this.driverClassName = string;
        this.firePropertyChanged(DRIVER_CLASS_NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            if (this.url == null || MWLoginSpec.urlsForDriverClassNamedContains(string2, this.url)) {
                this.setURL(MWLoginSpec.defaultURLForDriverClassNamed(string));
            }
            this.fireCollectionChanged(CANDIDATE_URLS_COLLECTION);
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        String string2 = this.url;
        this.url = string;
        this.firePropertyChanged(URL_PROPERTY, string2, string);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        String string2 = this.userName;
        this.userName = string;
        this.firePropertyChanged(USER_NAME_PROPERTY, string2, string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        String string2 = this.password;
        this.password = string;
        this.firePropertyChanged(PASSWORD_PROPERTY, string2, string);
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean bl) {
        boolean bl2 = this.savePassword;
        this.savePassword = bl;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, bl2, bl);
    }

    public ListIterator driverClasspathEntries() {
        return new CloneListIterator(this.driverClasspathEntries);
    }

    public int driverClasspathEntriesSize() {
        return this.driverClasspathEntries.size();
    }

    public String getDriverClasspathEntry(int n) {
        return (String)this.driverClasspathEntries.get(n);
    }

    public void addDriverClasspathEntry(int n, String string) {
        this.addItemToList(n, string, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public void addDriverClasspathEntry(String string) {
        this.addDriverClasspathEntry(this.driverClasspathEntriesSize(), string);
    }

    public void addDriverClasspathEntries(int n, List list) {
        this.addItemsToList(n, list, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public void addDriverClasspathEntries(List list) {
        this.addDriverClasspathEntries(this.driverClasspathEntriesSize(), list);
    }

    public void addDriverClasspathEntries(ListIterator listIterator) {
        this.addDriverClasspathEntries(CollectionTools.list(listIterator));
    }

    public String removeDriverClasspathEntry(int n) {
        return (String)this.removeItemFromList(n, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public List removeDriverClasspathEntries(int n, int n2) {
        return this.removeItemsFromList(n, n2, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    public String replaceDriverClasspathEntry(int n, String string) {
        return (String)this.setItemInList(n, string, this.driverClasspathEntries, DRIVER_CLASSPATH_ENTRIES_LIST);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (StringTools.stringIsEmpty(this.getURL())) {
            list.add(this.buildProblem("0721", this.getName()));
        }
        if (StringTools.stringIsEmpty(this.getDriverClassName())) {
            list.add(this.buildProblem("0720", this.getName()));
        }
    }

    public String defaultURL() {
        return MWLoginSpec.defaultURLForDriverClassNamed(this.driverClassName);
    }

    public Iterator candidateURLs() {
        return MWLoginSpec.urlsForDriverClassNamed(this.driverClassName);
    }

    public int candidateURLsSize() {
        return MWLoginSpec.urlsForDriverClassNamedSize(this.driverClassName);
    }

    protected void addTransientAspectNamesTo(Set set) {
        super.addTransientAspectNamesTo(set);
        set.add(CANDIDATE_URLS_COLLECTION);
    }

    File driverClasspathBaseDirectory() {
        return this.getProject().getSaveDirectory();
    }

    public Iterator fullyQualifiedDriverClasspathFiles() {
        return new TransformationIterator(this.driverClasspathEntries()){

            protected Object transform(Object object) {
                File file = new File((String)object);
                if (!file.isAbsolute()) {
                    file = new File(MWLoginSpec.this.driverClasspathBaseDirectory(), file.getPath());
                }
                return file;
            }
        };
    }

    private URL[] driverClasspathURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>(this.driverClasspathEntriesSize());
        Iterator iterator = this.fullyQualifiedDriverClasspathFiles();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                arrayList.add(file.toURL());
            }
            catch (IOException iOException) {}
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    Driver buildDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.driverClassName == null || this.driverClassName.length() == 0) {
            throw new IllegalStateException("missing database driver class name");
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(this.driverClasspathURLs());
        Class<?> clazz = Class.forName(this.driverClassName, true, uRLClassLoader);
        return (Driver)clazz.newInstance();
    }

    public Connector buildConnector() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new MWConnector(this.buildDriver(), this.getURL());
    }

    private DatabasePlatform databasePlatform() {
        return this.getDatabase().getDatabasePlatform();
    }

    DatabaseLogin buildDevelopmentRuntimeDatabaseLogin() {
        DatabaseLogin databaseLogin = this.buildRuntimeDatabaseLogin();
        databaseLogin.setConnector(this.getDatabase().buildRuntimeConnector());
        return databaseLogin;
    }

    DatabaseLogin buildDeploymentRuntimeDatabaseLogin() {
        DatabaseLogin databaseLogin = this.buildRuntimeDatabaseLogin();
        if (!this.savePassword) {
            databaseLogin.setPassword(null);
        }
        return databaseLogin;
    }

    private DatabaseLogin buildRuntimeDatabaseLogin() {
        DatabaseLogin databaseLogin = new DatabaseLogin();
        databaseLogin.setDriverClassName(this.driverClassName);
        databaseLogin.setDriverURLHeader("");
        databaseLogin.setDatabaseURL(this.url);
        databaseLogin.setUserName(this.userName);
        databaseLogin.setPassword(this.password);
        databaseLogin.setPlatformClassName(this.databasePlatform().getRuntimePlatformClassName());
        return databaseLogin;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }

    public String displayString() {
        return this.name;
    }

    private String getPasswordForTopLink() {
        return this.savePassword ? this.encryptedPassword() : null;
    }

    private String encryptedPassword() {
        return this.password == null ? null : MWLoginSpec.getEncryptor().encryptPassword(this.password);
    }

    private void setPasswordForTopLink(String string) {
        this.password = string == null ? null : MWLoginSpec.getEncryptor().decryptPassword(string);
    }

    private void legacySetPasswordForTopLink(String string) {
        this.password = string;
    }

    private static class MWConnector
    implements Connector {
        private Driver driver;
        private String url;

        public MWConnector(Driver driver, String string) {
            this.driver = driver;
            this.url = string;
        }

        public Connection connect(Properties properties, Session session) {
            try {
                return this.driver.connect(this.url, properties);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException((SQLException)sQLException);
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                throw new InternalError("clone failed");
            }
        }

        public String getConnectionDetails() {
            return "MWConnector: " + this.url;
        }

        public void toString(PrintWriter printWriter) {
            printWriter.println(this.getConnectionDetails());
        }
    }

    private static final class DriverSpec {
        private String driverClassName;
        private String[] urls;

        DriverSpec(String string, String[] stringArray) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.driverClassName = string;
            if (stringArray == null || stringArray.length == 0) {
                throw new IllegalArgumentException();
            }
            this.urls = stringArray;
        }

        DriverSpec(String string, String string2) {
            this(string, new String[]{string2});
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String[] getUrls() {
            return this.urls;
        }

        public Iterator urls() {
            return new ArrayIterator(this.urls);
        }

        public int urlsSize() {
            return this.urls.length;
        }

        public boolean containsURL(String string) {
            int n = this.urls.length;
            while (n-- > 0) {
                if (!this.urls[n].equals(string)) continue;
                return true;
            }
            return false;
        }

        public String defaultURL() {
            return this.urls[0];
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.driverClassName);
        }
    }
}

