/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReference
extends MWModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWTableHandle targetTableHandle;
    public static final String TARGET_TABLE_PROPERTY = "targetTable";
    private Collection columnPairs;
    public static final String COLUMN_PAIRS_COLLECTION = "columnPairs";
    private volatile boolean onDatabase;
    public static final String ON_DATABASE_PROPERTY = "onDatabase";

    private MWReference() {
    }

    MWReference(MWTable mWTable, String string, MWTable mWTable2) {
        super(mWTable);
        this.name = string;
        this.targetTableHandle.setTable(mWTable2);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.targetTableHandle = new MWTableHandle(this, this.buildTargetTableScrubber());
        this.columnPairs = new Vector();
        this.onDatabase = false;
    }

    public MWTable getSourceTable() {
        return (MWTable)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.getSourceTable().checkReferenceName(string);
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public MWTable getTargetTable() {
        return this.targetTableHandle.getTable();
    }

    public void setTargetTable(MWTable mWTable) {
        MWTable mWTable2 = this.targetTableHandle.getTable();
        this.targetTableHandle.setTable(mWTable);
        this.firePropertyChanged(TARGET_TABLE_PROPERTY, mWTable2, mWTable);
        if (this.attributeValueHasChanged(mWTable2, mWTable)) {
            this.clearColumnPairs();
        }
    }

    public boolean isOnDatabase() {
        return this.onDatabase;
    }

    public void setOnDatabase(boolean bl) {
        boolean bl2 = this.onDatabase;
        this.onDatabase = bl;
        this.firePropertyChanged(ON_DATABASE_PROPERTY, bl2, bl);
    }

    public Iterator columnPairs() {
        return new CloneIterator(this.columnPairs){

            protected void remove(Object object) {
                MWReference.this.removeColumnPair((MWColumnPair)object);
            }
        };
    }

    public int columnPairsSize() {
        return this.columnPairs.size();
    }

    public MWColumnPair addColumnPair(MWColumn mWColumn, MWColumn mWColumn2) {
        if (mWColumn.getTable() != this.getSourceTable()) {
            throw new IllegalArgumentException("invalid source column: " + mWColumn);
        }
        if (mWColumn2.getTable() != this.getTargetTable()) {
            throw new IllegalArgumentException("invalid target column: " + mWColumn2);
        }
        return this.addColumnPair(new MWColumnPair(this, mWColumn, mWColumn2));
    }

    private MWColumnPair addColumnPair(MWColumnPair mWColumnPair) {
        this.addItemToCollection(mWColumnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
        return mWColumnPair;
    }

    public void removeColumnPair(MWColumnPair mWColumnPair) {
        this.removeItemFromCollection(mWColumnPair, this.columnPairs, COLUMN_PAIRS_COLLECTION);
    }

    public void removeColumnPairs(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeColumnPair((MWColumnPair)iterator.next());
        }
    }

    public void removeColumnPairs(Collection collection) {
        this.removeColumnPairs(collection.iterator());
    }

    private void clearColumnPairs() {
        Iterator iterator = this.columnPairs();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumnPair columnPairNamed(String string) {
        Collection collection = this.columnPairs;
        synchronized (collection) {
            for (MWColumnPair mWColumnPair : this.columnPairs) {
                if (!mWColumnPair.getName().equals(string)) continue;
                return mWColumnPair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumnPair columnPairFor(MWColumn mWColumn, MWColumn mWColumn2) {
        Collection collection = this.columnPairs;
        synchronized (collection) {
            for (MWColumnPair mWColumnPair : this.columnPairs) {
                if (!mWColumnPair.pairs(mWColumn, mWColumn2)) continue;
                return mWColumnPair;
            }
        }
        return null;
    }

    public boolean isForeignKeyReference() {
        return !this.isPrimaryKeyReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimaryKeyReference() {
        Collection collection = CollectionTools.collection(this.getSourceTable().primaryKeyColumns());
        if (collection.size() != this.columnPairs.size()) {
            return false;
        }
        Collection collection2 = CollectionTools.collection(this.getTargetTable().primaryKeyColumns());
        if (collection2.size() != this.columnPairs.size()) {
            return false;
        }
        Collection collection3 = this.columnPairs;
        synchronized (collection3) {
            for (MWColumnPair mWColumnPair : this.columnPairs) {
                if (!collection.remove(mWColumnPair.getSourceColumn())) {
                    return false;
                }
                if (collection2.remove(mWColumnPair.getTargetColumn())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.targetTableHandle);
        Collection collection = this.columnPairs;
        synchronized (collection) {
            list.addAll(this.columnPairs);
        }
    }

    private MWHandle.NodeReferenceScrubber buildTargetTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWReference.this.setTargetTable(null);
            }

            public String toString() {
                return "MWReference.buildTargetTableScrubber()";
            }
        };
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.columnPairs.isEmpty()) {
            list.add(this.buildProblem("0703", this.getName()));
        }
        if (this.getTargetTable() == null) {
            list.add(this.buildProblem("0707", this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumnPairs(ExternalForeignKey externalForeignKey) {
        ExternalForeignKeyColumnPair[] externalForeignKeyColumnPairArray = this.columnPairs;
        synchronized (this.columnPairs) {
            HashSet hashSet = new HashSet(this.columnPairs);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            externalForeignKeyColumnPairArray = externalForeignKey.getColumnPairs();
            int n = externalForeignKeyColumnPairArray.length;
            while (n-- > 0) {
                this.refreshColumnPair(externalForeignKeyColumnPairArray[n], hashSet);
            }
            this.removeColumnPairs(hashSet);
            return;
        }
    }

    private void refreshColumnPair(ExternalForeignKeyColumnPair externalForeignKeyColumnPair, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((MWColumnPair)iterator.next()).matches(externalForeignKeyColumnPair)) continue;
            iterator.remove();
            return;
        }
        this.addColumnPair(this.sourceColumn(externalForeignKeyColumnPair), this.targetColumn(externalForeignKeyColumnPair));
    }

    MWColumn sourceColumn(ExternalForeignKeyColumnPair externalForeignKeyColumnPair) {
        return this.getSourceTable().column(externalForeignKeyColumnPair.getSourceColumn());
    }

    MWColumn targetColumn(ExternalForeignKeyColumnPair externalForeignKeyColumnPair) {
        return this.getTargetTable().column(externalForeignKeyColumnPair.getTargetColumn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesColumnPairs(ExternalForeignKey externalForeignKey) {
        HashSet hashSet;
        ExternalForeignKeyColumnPair[] externalForeignKeyColumnPairArray = externalForeignKey.getColumnPairs();
        int n = externalForeignKeyColumnPairArray.length;
        if (this.columnPairs.size() != n) {
            return false;
        }
        Collection collection = this.columnPairs;
        synchronized (collection) {
            hashSet = new HashSet(this.columnPairs);
        }
        int n2 = n;
        while (n2-- > 0) {
            ExternalForeignKeyColumnPair externalForeignKeyColumnPair = externalForeignKeyColumnPairArray[n2];
            boolean bl = false;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (!((MWColumnPair)iterator.next()).matches(externalForeignKeyColumnPair)) continue;
                iterator.remove();
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ForeignKeyConstraint buildRuntimeConstraint() {
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        foreignKeyConstraint.setName(this.getName());
        if (this.getTargetTable() != null) {
            foreignKeyConstraint.setTargetTable(this.getTargetTable().getName());
        }
        Collection collection = this.columnPairs;
        synchronized (collection) {
            Iterator iterator = this.columnPairs.iterator();
            while (iterator.hasNext()) {
                ((MWColumnPair)iterator.next()).configureRuntimeConstraint(foreignKeyConstraint);
            }
        }
        return foreignKeyConstraint;
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
        stringBuffer.append(" : ");
        this.printTableNameOn(this.getSourceTable(), stringBuffer);
        stringBuffer.append("=>");
        this.printTableNameOn(this.getTargetTable(), stringBuffer);
    }

    private void printTableNameOn(MWTable mWTable, StringBuffer stringBuffer) {
        stringBuffer.append(mWTable == null ? "null" : mWTable.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWReference.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("targetTableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("target-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(ON_DATABASE_PROPERTY, "on-database/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(COLUMN_PAIRS_COLLECTION);
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnPair.class);
        xMLCompositeCollectionMapping.setXPath("column-pairs/column-pair");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private MWTableHandle getTargetTableHandleForTopLink() {
        return this.targetTableHandle.getTable() == null ? null : this.targetTableHandle;
    }

    private void setTargetTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTargetTableScrubber();
        this.targetTableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }
}

