/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWTable
extends MWModel
implements MWNominative {
    private volatile String catalog;
    public static final String CATALOG_PROPERTY = "catalog";
    private volatile String schema;
    public static final String SCHEMA_PROPERTY = "schema";
    private volatile String shortName;
    public static final String SHORT_NAME_PROPERTY = "shortName";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private Date lastRefreshTimestamp;
    public static final String LAST_REFRESH_TIMESTAMP_PROPERTY = "lastRefreshTimestamp";
    private Collection columns;
    public static final String COLUMNS_COLLECTION = "columns";
    private Collection references;
    public static final String REFERENCES_COLLECTION = "references";
    private boolean legacyIsFullyQualified;

    private MWTable() {
    }

    MWTable(MWDatabase mWDatabase, String string, String string2, String string3) {
        super(mWDatabase);
        this.catalog = string;
        this.schema = string2;
        this.shortName = string3;
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.lastRefreshTimestamp = null;
        this.columns = new Vector();
        this.references = new Vector();
    }

    public String getCatalog() {
        return this.catalog;
    }

    private void setCatalog(String string) {
        String string2 = this.catalog;
        this.catalog = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(CATALOG_PROPERTY, string2, string);
            this.qualifiedNameChanged();
        }
    }

    public String getSchema() {
        return this.schema;
    }

    private void setSchema(String string) {
        String string2 = this.schema;
        this.schema = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(SCHEMA_PROPERTY, string2, string);
            this.qualifiedNameChanged();
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    private void setShortName(String string) {
        String string2 = this.shortName;
        this.shortName = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(SHORT_NAME_PROPERTY, string2, string);
            this.qualifiedNameChanged();
        }
    }

    private void qualifiedNameChanged() {
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, this.qualifiedName());
        this.getProject().nodeRenamed(this);
        Iterator iterator = this.columns();
        while (iterator.hasNext()) {
            ((MWColumn)iterator.next()).qualifiedNameChanged();
        }
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    private void setLastRefreshTimestamp(Date date) {
        Date date2 = this.lastRefreshTimestamp;
        this.lastRefreshTimestamp = date;
        this.firePropertyChanged(LAST_REFRESH_TIMESTAMP_PROPERTY, date2, date);
    }

    public Iterator columns() {
        return new CloneIterator(this.columns){

            protected void remove(Object object) {
                MWTable.this.removeColumn((MWColumn)object);
            }
        };
    }

    public int columnsSize() {
        return this.columns.size();
    }

    public MWColumn addColumn(String string) {
        this.checkColumnName(string);
        return this.addColumn(new MWColumn(this, string));
    }

    private MWColumn addColumn(MWColumn mWColumn) {
        this.addItemToCollection(mWColumn, this.columns, COLUMNS_COLLECTION);
        return mWColumn;
    }

    public void removeColumn(MWColumn mWColumn) {
        this.removeNodeFromCollection(mWColumn, this.columns, COLUMNS_COLLECTION);
    }

    public void removeColumns(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeColumn((MWColumn)iterator.next());
        }
    }

    public void removeColumns(Collection collection) {
        this.removeColumns(collection.iterator());
    }

    public boolean containsColumnNamed(String string) {
        return this.columnNamed(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWColumn columnNamed(String string) {
        Collection collection = this.columns;
        synchronized (collection) {
            for (MWColumn mWColumn : this.columns) {
                if (!mWColumn.getName().equals(string)) continue;
                return mWColumn;
            }
        }
        return null;
    }

    public MWColumn columnWithQualifiedName(String string) {
        if (!MWColumn.parseTableNameFromQualifiedName(string).equals(this.getName())) {
            throw new IllegalArgumentException();
        }
        return this.columnNamed(MWColumn.parseColumnNameFromQualifiedName(string));
    }

    public Iterator columnNames() {
        return new TransformationIterator(this.columns()){

            protected Object transform(Object object) {
                return ((MWColumn)object).getName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int primaryKeyColumnsSize() {
        int n = 0;
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                if (!((MWColumn)iterator.next()).isPrimaryKey()) continue;
                ++n;
            }
        }
        return n;
    }

    public Iterator primaryKeyColumns() {
        return new FilteringIterator(this.columns()){

            protected boolean accept(Object object) {
                return ((MWColumn)object).isPrimaryKey();
            }
        };
    }

    public Iterator primaryKeyColumnNames() {
        return new TransformationIterator(this.primaryKeyColumns()){

            protected Object transform(Object object) {
                return ((MWColumn)object).getName();
            }
        };
    }

    public Iterator nonPrimaryKeyColumns() {
        return new FilteringIterator(this.columns()){

            protected boolean accept(Object object) {
                return !((MWColumn)object).isPrimaryKey();
            }
        };
    }

    public MWColumn addColumnLike(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.addColumn(mWColumn.getName());
        mWColumn2.copySettingsFrom(mWColumn);
        return mWColumn2;
    }

    public Iterator references() {
        return new CloneIterator(this.references){

            protected void remove(Object object) {
                MWTable.this.removeReference((MWReference)object);
            }
        };
    }

    public int referencesSize() {
        return this.references.size();
    }

    public MWReference addReference(String string, MWTable mWTable) {
        this.checkReferenceName(string);
        return this.addReference(new MWReference(this, string, mWTable));
    }

    private MWReference addReference(MWReference mWReference) {
        this.addItemToCollection(mWReference, this.references, REFERENCES_COLLECTION);
        return mWReference;
    }

    public void removeReference(MWReference mWReference) {
        this.removeNodeFromCollection(mWReference, this.references, REFERENCES_COLLECTION);
    }

    public void removeReferences(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeReference((MWReference)iterator.next());
        }
    }

    public void removeReferences(Collection collection) {
        this.removeReferences(collection.iterator());
    }

    private void removeDatabaseReferences(Iterator iterator) {
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            if (!mWReference.isOnDatabase()) continue;
            this.removeReference(mWReference);
        }
    }

    private void removeDatabaseReferences(Collection collection) {
        this.removeDatabaseReferences(collection.iterator());
    }

    public boolean containsReferenceNamed(String string) {
        return this.referenceNamed(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWReference referenceNamed(String string) {
        Collection collection = this.references;
        synchronized (collection) {
            for (MWReference mWReference : this.references) {
                if (!mWReference.getName().equals(string)) continue;
                return mWReference;
            }
            return null;
        }
    }

    public Iterator referenceNames() {
        return new TransformationIterator(this.references()){

            protected Object transform(Object object) {
                return ((MWReference)object).getName();
            }
        };
    }

    public Iterator databaseReferences() {
        return new FilteringIterator(this.references()){

            protected boolean accept(Object object) {
                return ((MWReference)object).isOnDatabase();
            }
        };
    }

    public Iterator referencesBetween(MWTable mWTable) {
        return new CompositeIterator(this.referencesTo(mWTable), mWTable.referencesTo(this));
    }

    public Iterator referencesTo(final MWTable mWTable) {
        return new FilteringIterator(this.references()){

            protected boolean accept(Object object) {
                return ((MWReference)object).getTargetTable() == mWTable;
            }
        };
    }

    public String getName() {
        return this.qualifiedName();
    }

    public DatabasePlatform databasePlatform() {
        return this.getDatabase().getDatabasePlatform();
    }

    boolean nameMatches(String string, String string2, String string3) {
        return this.valuesAreEqual(this.catalog, string) && this.valuesAreEqual(this.schema, string2) && this.valuesAreEqual(this.shortName, string3);
    }

    boolean nameMatchesIgnoreCase(String string, String string2, String string3) {
        return StringTools.stringsAreEqualIgnoreCase(this.catalog, string) && StringTools.stringsAreEqualIgnoreCase(this.schema, string2) && StringTools.stringsAreEqualIgnoreCase(this.shortName, string3);
    }

    public boolean nameIsQualified() {
        if (this.catalog != null) {
            return true;
        }
        return this.schema != null;
    }

    public boolean nameIsUnqualified() {
        return !this.nameIsQualified();
    }

    public String qualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName(this.catalog, this.schema, this.shortName);
    }

    public String unqualifiedName() {
        return this.shortName;
    }

    private String qualifier() {
        if (this.nameIsUnqualified()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.catalog != null) {
            stringBuffer.append(this.catalog);
        }
        if (this.schema != null) {
            if (this.catalog != null) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.schema);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.columns;
        synchronized (collection) {
            list.addAll(this.columns);
        }
        collection = this.references;
        synchronized (collection) {
            list.addAll(this.references);
        }
    }

    public void rename(String string, String string2, String string3) {
        if (this.nameMatches(string, string2, string3)) {
            return;
        }
        this.getDatabase().checkTableName(string, string2, string3, this);
        this.setCatalog(string);
        this.setSchema(string2);
        this.setShortName(string3);
        this.getDatabase().tableRenamed();
    }

    void checkColumnName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsColumnNamed(string)) {
            throw new IllegalArgumentException("duplicate column name: " + string);
        }
    }

    void checkReferenceName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsReferenceNamed(string)) {
            throw new IllegalArgumentException("duplicate reference name: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void databasePlatformChanged() {
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                ((MWColumn)iterator.next()).databasePlatformChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        int n = 0;
        Collection collection = this.columns;
        synchronized (collection) {
            for (MWColumn mWColumn : this.columns) {
                if (!mWColumn.isIdentity()) continue;
                ++n;
            }
        }
        if (n > 1) {
            list.add(this.buildProblem("0701"));
        }
    }

    public Iterator matchingExternalTableDescriptions() {
        return this.getDatabase().externalTableDescriptions(this.catalog, this.schema, this.shortName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumns(ExternalTable externalTable) {
        ExternalColumn[] externalColumnArray = this.columns;
        synchronized (this.columns) {
            HashSet hashSet = new HashSet(this.columns);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            externalColumnArray = externalTable.getColumns();
            int n = externalColumnArray.length;
            while (n-- > 0) {
                this.refreshColumn(externalColumnArray[n], hashSet);
            }
            this.removeColumns(hashSet);
            this.setLastRefreshTimestamp(new Date());
            return;
        }
    }

    private void refreshColumn(ExternalColumn externalColumn, Collection collection) {
        MWColumn mWColumn = this.columnNamed(externalColumn.getName());
        if (mWColumn == null) {
            mWColumn = this.addColumn(externalColumn.getName());
        } else {
            collection.remove(mWColumn);
        }
        mWColumn.refresh(externalColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshReferences(ExternalTable externalTable) {
        ExternalForeignKey[] externalForeignKeyArray = this.references;
        synchronized (this.references) {
            HashSet hashSet = new HashSet(this.references);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            externalForeignKeyArray = externalTable.getForeignKeys();
            int n = externalForeignKeyArray.length;
            while (n-- > 0) {
                this.refreshReference(externalForeignKeyArray[n], hashSet);
            }
            this.removeDatabaseReferences(hashSet);
            return;
        }
    }

    private void refreshReference(ExternalForeignKey externalForeignKey, Collection collection) {
        Object object2;
        ExternalTableDescription externalTableDescription = externalForeignKey.getTargetTableDescription();
        MWTable mWTable = this.getDatabase().tableNamed(externalTableDescription.getCatalogName(), externalTableDescription.getSchemaName(), externalTableDescription.getName());
        if (mWTable == null) {
            mWTable = this.getDatabase().tableNamed(null, null, externalTableDescription.getName());
        }
        if (mWTable == null) {
            return;
        }
        for (Object object2 : collection) {
            if (!object2.getName().equals(externalForeignKey.getName())) continue;
            object2.setTargetTable(mWTable);
            object2.refreshColumnPairs(externalForeignKey);
            object2.setOnDatabase(true);
            collection.remove(object2);
            return;
        }
        for (Object object2 : collection) {
            if (!object2.matchesColumnPairs(externalForeignKey)) continue;
            object2.setName(externalForeignKey.getName());
            object2.setTargetTable(mWTable);
            object2.setOnDatabase(true);
            collection.remove(object2);
            return;
        }
        MWReference mWReference = this.addReference(externalForeignKey.getName(), mWTable);
        object2 = externalForeignKey.getColumnPairs();
        int n = ((ExternalForeignKeyColumnPair[])object2).length;
        while (n-- > 0) {
            mWReference.addColumnPair(this.column(object2[n].getSourceColumn()), mWTable.column(object2[n].getTargetColumn()));
        }
        mWReference.setOnDatabase(true);
    }

    MWColumn column(ExternalColumn externalColumn) {
        return externalColumn == null ? null : this.columnNamed(externalColumn.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableDefinition buildRuntimeTableDefinition() {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(this.shortName);
        tableDefinition.setQualifier(this.qualifier());
        Collection collection = this.columns;
        synchronized (collection) {
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                tableDefinition.addField(((MWColumn)iterator.next()).buildRuntimeFieldDefinition());
            }
        }
        collection = this.references;
        synchronized (collection) {
            for (MWReference mWReference : this.references) {
                if (!mWReference.isOnDatabase()) continue;
                tableDefinition.addForeignKeyConstraint(mWReference.buildRuntimeConstraint());
            }
        }
        return tableDefinition;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.qualifiedName());
    }

    public String displayString() {
        return this.qualifiedName();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWTable.class);
        xMLDescriptor.setDefaultRootElement("table");
        xMLDescriptor.addDirectMapping(CATALOG_PROPERTY, "catalog/text()");
        xMLDescriptor.addDirectMapping(SCHEMA_PROPERTY, "schema/text()");
        xMLDescriptor.addDirectMapping(SHORT_NAME_PROPERTY, "short-name/text()");
        xMLDescriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(COLUMNS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getColumnsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setColumnsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWColumn.class);
        xMLCompositeCollectionMapping.setXPath("columns/column");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(REFERENCES_COLLECTION);
        xMLCompositeCollectionMapping2.setGetMethodName("getReferencesForTopLink");
        xMLCompositeCollectionMapping2.setSetMethodName("setReferencesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWReference.class);
        xMLCompositeCollectionMapping2.setXPath("references/table-association");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getColumnsForTopLink() {
        Collection collection = this.columns;
        synchronized (collection) {
            return new TreeSet(this.columns);
        }
    }

    private void setColumnsForTopLink(Collection collection) {
        this.columns = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getReferencesForTopLink() {
        Collection collection = this.references;
        synchronized (collection) {
            return new TreeSet(this.references);
        }
    }

    private void setReferencesForTopLink(Collection collection) {
        this.references = collection;
    }
}

