/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassIndicatorExtractionMethodPolicy
extends MWAbstractClassIndicatorPolicy {
    private MWMethodHandle methodHandle;
    public static final String METHOD_PROPERTY = "classExtractionMethod";

    private MWClassIndicatorExtractionMethodPolicy() {
    }

    public MWClassIndicatorExtractionMethodPolicy(MWClassIndicatorPolicy.Parent parent) {
        super(parent);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
    }

    public String getType() {
        return "classExtractionMethodClassIndicatorPolicy";
    }

    public MWMethod getClassExtractionMethod() {
        return this.methodHandle.getMethod();
    }

    public void setClassExtractionMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getClassExtractionMethod();
        this.methodHandle.setMethod(mWMethod);
        this.firePropertyChanged(METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassIndicatorExtractionMethodPolicy.this.setClassExtractionMethod(null);
            }

            public String toString() {
                return "MWClassIndicatorExtractionMethodPolicy.buildMethodScrubber()";
            }
        };
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkClassExtractionMethod(list);
    }

    private void checkClassExtractionMethod(List list) {
        if (this.getClassExtractionMethod() == null) {
            list.add(this.buildProblem("0327"));
        } else if (!CollectionTools.contains(this.getContainingDescriptor().getMWClass().methods(), (Object)this.getClassExtractionMethod())) {
            list.add(this.buildProblem("0328"));
        } else if (!this.getClassExtractionMethod().isCandidateClassExtractionMethod()) {
            list.add(this.buildProblem("0329"));
        }
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy inheritancePolicy) {
        if (this.getClassExtractionMethod() != null) {
            inheritancePolicy.setClassExtractionMethodName(this.getClassExtractionMethod().getName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassIndicatorExtractionMethodPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractClassIndicatorPolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("methodHandle");
        xMLCompositeObjectMapping.setGetMethodName("getMethodHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setMethodHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping.setXPath("method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildMethodScrubber();
        this.methodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

