/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWCompositeEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWDescriptor
extends MWModel
implements MWNominative {
    private MWClassHandle mwClassHandle;
    public static final String MW_CLASS_PROPERTY = "mwClass";
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile boolean active;
    public static final String ACTIVE_PROPERTY = "active";
    protected MWTransactionalPolicy transactionalPolicy;
    protected Map legacyValuesMap;

    protected MWDescriptor() {
    }

    protected MWDescriptor(MWProject mWProject, MWClass mWClass, String string) {
        super(mWProject);
        this.initialize(mWClass, string);
    }

    protected void initialize() {
        super.initialize();
        this.legacyValuesMap = new HashMap();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.mwClassHandle = new MWClassHandle(this, this.buildMWClassScrubber());
        this.active = true;
    }

    protected void initialize(MWClass mWClass, String string) {
        this.mwClassHandle.setType(mWClass);
        this.name = string;
        this.transactionalPolicy = this.buildDefaultTransactionalPolicy();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.mwClassHandle);
        list.add(this.transactionalPolicy);
    }

    private MWHandle.NodeReferenceScrubber buildMWClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptor.this.setMWClass(null);
            }

            public String toString() {
                return "MWDescriptor.buildMWClassScrubber()";
            }
        };
    }

    protected MWTransactionalPolicy buildDefaultTransactionalPolicy() {
        return new MWNullTransactionalPolicy(this);
    }

    public MWTransactionalPolicy getTransactionalPolicy() {
        return this.transactionalPolicy;
    }

    public abstract void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy var1);

    public MWClass getMWClass() {
        return this.mwClassHandle.getType();
    }

    public void setMWClass(MWClass mWClass) {
        if (mWClass == null) {
            throw new NullPointerException();
        }
        MWClass mWClass2 = this.mwClassHandle.getType();
        this.mwClassHandle.setType(mWClass);
        this.firePropertyChanged(MW_CLASS_PROPERTY, mWClass2, mWClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public boolean isRootDescriptor() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.active;
    }

    public void setActive(boolean bl) {
        boolean bl2 = this.active;
        this.active = bl;
        this.firePropertyChanged(ACTIVE_PROPERTY, bl2, bl);
    }

    public boolean supportsCachingPolicy() {
        return false;
    }

    public String packageName() {
        return this.getMWClass().packageName();
    }

    public String shortName() {
        return this.getMWClass().shortName();
    }

    public Iterator mappings() {
        return NullIterator.instance();
    }

    public int inheritedAttributesSize() {
        return 0;
    }

    public int mappingsSize() {
        return 0;
    }

    public MWMapping mappingNamed(String string) {
        return null;
    }

    public Iterator mappingsIncludingInherited() {
        return NullIterator.instance();
    }

    protected List getMappingsIncludingInherited() {
        return new Vector();
    }

    public Collection getAllQueryKeysIncludingInherited() {
        return new ArrayList();
    }

    public Collection getAutoGeneratedQueryKeysIncludingInherited() {
        return new ArrayList();
    }

    public Collection writableMappingsForField(MWDataField mWDataField) {
        return Collections.EMPTY_LIST;
    }

    void inheritanceChanged() {
        this.transactionalPolicy.descriptorInheritanceChanged();
    }

    public void unmap() {
    }

    public abstract boolean canHaveInheritance();

    public abstract MWInheritancePolicy getInheritancePolicy();

    public abstract boolean hasDefinedInheritance();

    public abstract boolean hasActiveInstantiationPolicy();

    public Iterator inheritanceHierarchy() {
        return this.getInheritancePolicy().descriptorLineage();
    }

    public boolean usesSequencingInDescriptorHierarchy() {
        return false;
    }

    public abstract void initializeOn(MWDescriptor var1);

    protected void initializeDescriptorAfterMorphing(MWDescriptor mWDescriptor) {
        this.initializeOn(mWDescriptor);
        mWDescriptor.setChildBackpointers();
        this.getProject().replaceDescriptor(this, mWDescriptor);
    }

    protected void initializeFromMWDescriptor(MWDescriptor mWDescriptor) {
        this.setActive(mWDescriptor.isActive());
        this.setName(mWDescriptor.getName());
    }

    protected void initializeFromMWMappingDescriptor(MWMappingDescriptor mWMappingDescriptor) {
        this.initializeFromMWDescriptor(mWMappingDescriptor);
    }

    public void refreshClass(ExternalClassLoadFailureContainer externalClassLoadFailureContainer, DescriptorCreationFailureListener descriptorCreationFailureListener) {
        this.refreshClass(externalClassLoadFailureContainer, this.buildMWClassRefreshPolicy(), descriptorCreationFailureListener);
    }

    public void refreshClass() throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        this.refreshClass(this.buildMWClassRefreshPolicy());
    }

    protected MWClassRefreshPolicy buildMWClassRefreshPolicy() {
        return DefaultMWClassRefreshPolicy.instance();
    }

    protected void refreshClass(ExternalClassLoadFailureContainer externalClassLoadFailureContainer, MWClassRefreshPolicy mWClassRefreshPolicy, DescriptorCreationFailureListener descriptorCreationFailureListener) {
        try {
            this.refreshClass(mWClassRefreshPolicy);
        }
        catch (ExternalClassNotFoundException externalClassNotFoundException) {
            externalClassLoadFailureContainer.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, this.getName(), externalClassNotFoundException));
        }
        catch (InterfaceDescriptorCreationException interfaceDescriptorCreationException) {
            descriptorCreationFailureListener.descriptorCreationFailure(new DescriptorCreationFailureEvent(this, this.getName(), "DESCRIPTOR_REFRESH_ERROR_MESSAGE"));
        }
    }

    protected void refreshClass(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        this.getMWClass().refresh(mWClassRefreshPolicy);
    }

    public boolean validateBranchInternal() {
        return this.isActive() ? super.validateBranchInternal() : this.clearAllBranchProblemsInternal();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkForFinalSuperClass(list);
        this.checkForPublicClass(list);
        this.getMWClass().addDescriptorProblemsTo(list);
    }

    private void checkForPublicClass(List list) {
        if (!this.getMWClass().getModifier().isPublic()) {
            list.add(this.buildProblem("0200"));
        }
    }

    private void checkForFinalSuperClass(List list) {
        MWClass mWClass = this.getMWClass().getSuperclass();
        if (mWClass != null && mWClass.getModifier().isFinal()) {
            list.add(this.buildProblem("0201"));
        }
    }

    public final void automapInheritanceHierarchy(Collection collection) {
        if (this.isActive() && this.canHaveInheritance() && !this.hasDefinedInheritance()) {
            this.automapInheritanceHierarchyInternal(collection);
        }
    }

    protected void automapInheritanceHierarchyInternal(Collection collection) {
    }

    public final boolean autoMapRequiresMetaData() {
        return this.isActive() && this.autoMapRequiresMetaDataInternal();
    }

    protected boolean autoMapRequiresMetaDataInternal() {
        return false;
    }

    public final void automap() {
        if (this.isActive()) {
            this.automapInternal();
        }
    }

    protected void automapInternal() {
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor classDescriptor = this.buildBasicRuntimeDescriptor();
        this.transactionalPolicy.adjustRuntimeDescriptor(classDescriptor);
        return classDescriptor;
    }

    protected abstract ClassDescriptor buildBasicRuntimeDescriptor();

    public String displayString() {
        return this.getMWClass().shortName();
    }

    public String displayStringWithPackage() {
        String string = this.packageName();
        if (StringTools.stringIsEmpty(string)) {
            string = "default package";
        }
        return this.getMWClass().shortName() + " (" + string + ")";
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptor.class);
        xMLDescriptor.setDefaultRootElement("descriptor");
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWTableDescriptor.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWAggregateDescriptor.class, (Object)"aggregate");
        inheritancePolicy.addClassIndicator(MWInterfaceDescriptor.class, (Object)"interface");
        inheritancePolicy.addClassIndicator(MWRootEisDescriptor.class, (Object)"eis-root");
        inheritancePolicy.addClassIndicator(MWCompositeEisDescriptor.class, (Object)"eis-composite");
        inheritancePolicy.addClassIndicator(MWOXDescriptor.class, (Object)"o-x");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(ACTIVE_PROPERTY, "active/text()")).setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("mwClassHandle");
        xMLCompositeObjectMapping.setGetMethodName("getMWClassHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setMWClassHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("transactionalPolicy");
        xMLCompositeObjectMapping2.setGetMethodName("getTransactionalPolicyForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setTransactionalPolicyForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWAbstractTransactionalPolicy.class);
        xMLCompositeObjectMapping2.setXPath("transactional-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWClassHandle getMWClassHandleForTopLink() {
        return this.mwClassHandle.getType() == null ? null : this.mwClassHandle;
    }

    private void setMWClassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildMWClassScrubber();
        this.mwClassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWAbstractTransactionalPolicy getTransactionalPolicyForTopLink() {
        return this.transactionalPolicy.getValueForTopLink();
    }

    private void setTransactionalPolicyForTopLink(MWAbstractTransactionalPolicy mWAbstractTransactionalPolicy) {
        this.transactionalPolicy = mWAbstractTransactionalPolicy == null ? new MWNullTransactionalPolicy(this) : mWAbstractTransactionalPolicy;
    }
}

