/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorAfterLoadingPolicy
extends MWAbstractDescriptorPolicy {
    private MWMethodHandle postLoadMethodHandle;
    public static final String POST_LOAD_METHOD_PROPERTY = "postLoadMethod";
    private MWClassHandle postLoadMethodClassHandle;
    public static final String POST_LOAD_METHOD_CLASS_PROPERTY = "postLoadMethodClass";

    private MWDescriptorAfterLoadingPolicy() {
    }

    MWDescriptorAfterLoadingPolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.postLoadMethodHandle = new MWMethodHandle(this, this.buildPostLoadMethodScrubber());
        this.postLoadMethodClassHandle = new MWClassHandle(this, this.buildPostLoadMethodClassScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.postLoadMethodHandle);
        list.add(this.postLoadMethodClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildPostLoadMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorAfterLoadingPolicy.this.setPostLoadMethod(null);
            }

            public String toString() {
                return "MWDescriptorAfterLoadingPolicy.buildPostLoadMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildPostLoadMethodClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorAfterLoadingPolicy.this.setPostLoadMethodClass(null);
            }

            public String toString() {
                return "MWDescriptorAfterLoadingPolicy.buildPostLoadMethodClassScrubber()";
            }
        };
    }

    public MWMethod getPostLoadMethod() {
        return this.postLoadMethodHandle.getMethod();
    }

    public void setPostLoadMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.postLoadMethodHandle.getMethod();
        this.postLoadMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(POST_LOAD_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public MWClass getPostLoadMethodClass() {
        return this.postLoadMethodClassHandle.getType();
    }

    public void setPostLoadMethodClass(MWClass mWClass) {
        MWClass mWClass2 = this.postLoadMethodClassHandle.getType();
        this.postLoadMethodClassHandle.setType(mWClass);
        this.firePropertyChanged(POST_LOAD_METHOD_CLASS_PROPERTY, mWClass2, mWClass);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        if (this.getPostLoadMethod() != null) {
            classDescriptor.setAmendmentMethodName(this.getPostLoadMethod().getName());
        }
        if (this.getPostLoadMethodClass() != null) {
            classDescriptor.setAmendmentClassName(this.getPostLoadMethodClass().getName());
        }
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public boolean isActive() {
        return true;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkAfterLoadClass(list);
        this.checkAfterLoadMethod(list);
    }

    private void checkAfterLoadClass(List list) {
        if (this.getPostLoadMethodClass() == null) {
            list.add(this.buildProblem("0322"));
        } else if (this.getPostLoadMethod() != null && !CollectionTools.contains(this.getPostLoadMethodClass().methods(), (Object)this.getPostLoadMethod())) {
            list.add(this.buildProblem("0342"));
        }
    }

    private void checkAfterLoadMethod(List list) {
        if (this.getPostLoadMethod() == null) {
            list.add(this.buildProblem("0323"));
        } else if (!this.getPostLoadMethod().isCandidateDescriptorAfterLoadMethod()) {
            list.add(this.buildProblem("0372"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorAfterLoadingPolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("postLoadMethodClassHandle");
        xMLCompositeObjectMapping.setGetMethodName("getPostLoadMethodClassHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setPostLoadMethodClassHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("post-load-class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("postLoadMethodHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getPostLoadMethodHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setPostLoadMethodHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping2.setXPath("post-load-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private void setPostLoadMethodClassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildPostLoadMethodClassScrubber();
        this.postLoadMethodClassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWClassHandle getPostLoadMethodClassHandleForTopLink() {
        return this.postLoadMethodClassHandle.getType() == null ? null : this.postLoadMethodClassHandle;
    }

    private void setPostLoadMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildPostLoadMethodScrubber();
        this.postLoadMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getPostLoadMethodHandleForTopLink() {
        return this.postLoadMethodHandle.getMethod() == null ? null : this.postLoadMethodHandle;
    }
}

