/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCopyPolicy
extends MWAbstractDescriptorPolicy {
    private MWMethodHandle methodHandle;
    private volatile String policyType;
    public static final String COPY_POLICY_PROPERTY = "copyPolicy";
    public static final String CLONE = "clone";
    public static final String INSTANTIATION_POLICY = "instantiation";
    public static final String CONSTRUCTOR = "constructor";
    public static final String CONSTRUCTOR_PROPERTY = "constructor";
    public static final String COPY_POLICY_TYPE_PROPERTY = "copyPolicyType";
    public static final String COPY_METHOD_PROPERTY = "copyMethod";

    private MWDescriptorCopyPolicy() {
    }

    public MWDescriptorCopyPolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
        this.policyType = INSTANTIATION_POLICY;
    }

    public MWMethod getMethod() {
        return this.methodHandle.getMethod();
    }

    public void setMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.methodHandle.getMethod();
        this.methodHandle.setMethod(mWMethod);
        this.firePropertyChanged(COPY_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String string) {
        String string2 = this.policyType;
        this.policyType = string;
        this.firePropertyChanged(COPY_POLICY_TYPE_PROPERTY, string2, this.policyType);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorCopyPolicy.this.setMethod(null);
            }

            public String toString() {
                return "MWDescriptorCopyPolicy.buildMethodScrubber()";
            }
        };
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public boolean isActive() {
        return true;
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        MWMethod mWMethod;
        if (this.policyType == INSTANTIATION_POLICY) {
            classDescriptor.useInstantiationCopyPolicy();
        } else if (this.policyType == CLONE && (mWMethod = this.getMethod()) != null) {
            classDescriptor.useCloneCopyPolicy(mWMethod.getName());
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkCloneCopyPolicy(list);
    }

    private void checkCloneCopyPolicy(List list) {
        if (this.getPolicyType() == CLONE) {
            if (this.getMethod() == null) {
                list.add(this.buildProblem("0317"));
            } else if (!this.checkIfMethodIsInOwningClass()) {
                list.add(this.buildProblem("0318"));
            } else if (!this.getMethod().isCandidateCloneMethod()) {
                list.add(this.buildProblem("0346"));
            }
        }
    }

    public boolean checkIfMethodIsInOwningClass() {
        return CollectionTools.contains(this.getOwningDescriptor().getMWClass().allMethods(), (Object)this.getMethod());
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getPolicyType());
        stringBuffer.append(", method=");
        stringBuffer.append(this.getMethod());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorCopyPolicy.class);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)INSTANTIATION_POLICY, (Object)INSTANTIATION_POLICY);
        objectTypeConverter.addConversionValue((Object)CLONE, (Object)CLONE);
        objectTypeConverter.setDefaultAttributeValue((Object)INSTANTIATION_POLICY);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("policyType");
        xMLDirectMapping.setXPath("policy-type/text()");
        xMLDirectMapping.setNullValue((Object)INSTANTIATION_POLICY);
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("methodHandle");
        xMLCompositeObjectMapping.setGetMethodName("getMethodHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setMethodHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping.setXPath("copy-policy-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildMethodScrubber();
        this.methodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

