/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorInstantiationPolicy
extends MWAbstractDescriptorPolicy {
    private volatile String policyType;
    public static final String POLICY_TYPE_PROPERTY = "policyType";
    public static final String DEFAULT_CONSTRUCTOR = "Default constructor";
    public static final String METHOD = "Method";
    public static final String FACTORY = "Factory";
    private MWClassHandle factoryTypeHandle;
    public static final String FACTORY_TYPE_PROPERTY = "factoryType";
    private MWMethodHandle useMethodHandle;
    public static final String USE_METHOD_PROPERTY = "useMethod";
    private MWMethodHandle factoryMethodHandle;
    public static final String FACTORY_METHOD_PROPERTY = "factoryMethod";
    private MWMethodHandle instantiationMethodHandle;
    public static final String INSTANTIATION_METHOD_PROPERTY = "instantiationMethod";

    private MWDescriptorInstantiationPolicy() {
    }

    MWDescriptorInstantiationPolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.policyType = DEFAULT_CONSTRUCTOR;
        this.factoryTypeHandle = new MWClassHandle(this, this.buildFactoryTypeScrubber());
        this.useMethodHandle = new MWMethodHandle(this, this.buildUseMethodScrubber());
        this.factoryMethodHandle = new MWMethodHandle(this, this.buildFactoryMethodScrubber());
        this.instantiationMethodHandle = new MWMethodHandle(this, this.buildInstantiationMethodScrubber());
    }

    public MWMethod getFactoryMethod() {
        return this.factoryMethodHandle.getMethod();
    }

    public void setFactoryMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getFactoryMethod();
        this.factoryMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(FACTORY_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public MWClass getFactoryType() {
        return this.factoryTypeHandle.getType();
    }

    public void setFactoryType(MWClass mWClass) {
        MWClass mWClass2 = this.factoryTypeHandle.getType();
        this.factoryTypeHandle.setType(mWClass);
        this.firePropertyChanged(FACTORY_TYPE_PROPERTY, mWClass2, mWClass);
    }

    public MWMethod getInstantiationMethod() {
        return this.instantiationMethodHandle.getMethod();
    }

    public void setInstantiationMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getInstantiationMethod();
        this.instantiationMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(INSTANTIATION_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public MWMethod getUseMethod() {
        return this.useMethodHandle.getMethod();
    }

    public void setUseMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getUseMethod();
        this.useMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(USE_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String string) {
        String string2 = this.policyType;
        this.policyType = string;
        this.firePropertyChanged(POLICY_TYPE_PROPERTY, string2, string);
    }

    public boolean checkUseMethodLegitimacy() {
        return CollectionTools.contains(this.getOwningDescriptor().getMWClass().allMethods(), (Object)this.getUseMethod());
    }

    public boolean checkFactoryInstantiationMethodLegitimacy() {
        return CollectionTools.contains(this.getFactoryType().allMethods(), (Object)this.getInstantiationMethod());
    }

    public boolean checkFactoryMethodLegitimacy() {
        return CollectionTools.contains(this.getFactoryType().allMethods(), (Object)this.getFactoryMethod());
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getPolicyType());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.useMethodHandle);
        list.add(this.factoryMethodHandle);
        list.add(this.instantiationMethodHandle);
        list.add(this.factoryTypeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildUseMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorInstantiationPolicy.this.setUseMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildUseMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildFactoryMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorInstantiationPolicy.this.setFactoryMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildFactoryMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildInstantiationMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorInstantiationPolicy.this.setInstantiationMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildInstantiationMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildFactoryTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorInstantiationPolicy.this.setFactoryType(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildFactoryTypeScrubber()";
            }
        };
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        String string = this.getPolicyType();
        if (string == DEFAULT_CONSTRUCTOR) {
            classDescriptor.useDefaultConstructorInstantiationPolicy();
        } else if (string == METHOD) {
            MWMethod mWMethod = this.getUseMethod();
            if (mWMethod != null) {
                classDescriptor.useMethodInstantiationPolicy(mWMethod.getName());
            }
        } else if (string == FACTORY) {
            MWClass mWClass = this.getFactoryType();
            if (mWClass == null) {
                return;
            }
            MWMethod mWMethod = this.getInstantiationMethod();
            if (mWMethod == null) {
                return;
            }
            String string2 = mWClass.getName();
            MWMethod mWMethod2 = this.getFactoryMethod();
            if (mWMethod2 == null) {
                classDescriptor.useFactoryInstantiationPolicy(string2, mWMethod.getName());
            } else {
                classDescriptor.useFactoryInstantiationPolicy(string2, mWMethod.getName(), mWMethod2.getName());
            }
        } else {
            throw new IllegalStateException(string);
        }
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public boolean isActive() {
        return true;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkDefaultConstructor(list);
        this.checkInstantiationMethod(list);
        this.checkFactoryMethod(list);
        this.checkFactoryInstantiationMethod(list);
    }

    private void checkDefaultConstructor(List list) {
        if (this.getPolicyType() == DEFAULT_CONSTRUCTOR && !this.getOwningDescriptor().getMWClass().hasAccessibleZeroArgumentConstructor()) {
            list.add(this.buildProblem("0316"));
        }
    }

    private void checkInstantiationMethod(List list) {
        if (this.getPolicyType() == METHOD) {
            if (this.getUseMethod() == null) {
                list.add(this.buildProblem("0315"));
            } else if (!this.checkUseMethodLegitimacy()) {
                list.add(this.buildProblem("0311"));
            } else if (!this.getUseMethod().isCandidateInstantiationMethod()) {
                list.add(this.buildProblem("0343"));
            }
        }
    }

    private void checkFactoryMethod(List list) {
        if (this.getPolicyType() == FACTORY && this.getFactoryMethod() != null && this.getFactoryType() != null) {
            if (!this.checkFactoryMethodLegitimacy()) {
                list.add(this.buildProblem("0313"));
            } else if (!this.getFactoryMethod().isCandidateFactoryMethod()) {
                list.add(this.buildProblem("0345"));
            }
        }
    }

    private void checkFactoryInstantiationMethod(List list) {
        if (this.getPolicyType() == FACTORY) {
            if (this.getInstantiationMethod() == null) {
                list.add(this.buildProblem("0314"));
            } else if (this.getFactoryType() != null) {
                if (!this.checkFactoryInstantiationMethodLegitimacy()) {
                    list.add(this.buildProblem("0312"));
                } else if (!this.getInstantiationMethod().isCandidateFactoryInstantiationMethodFor(this.getFactoryType())) {
                    list.add(this.buildProblem("0344"));
                }
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorInstantiationPolicy.class);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)DEFAULT_CONSTRUCTOR, (Object)DEFAULT_CONSTRUCTOR);
        objectTypeConverter.addConversionValue((Object)FACTORY, (Object)FACTORY);
        objectTypeConverter.addConversionValue((Object)METHOD, (Object)METHOD);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(POLICY_TYPE_PROPERTY);
        xMLDirectMapping.setXPath("policy-type/text()");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("factoryTypeHandle");
        xMLCompositeObjectMapping.setSetMethodName("setFactoryTypeHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getFactoryTypeHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("factory-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("useMethodHandle");
        xMLCompositeObjectMapping2.setSetMethodName("setUseMethodHandleForTopLink");
        xMLCompositeObjectMapping2.setGetMethodName("getUseMethodHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping2.setXPath("use-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("factoryMethodHandle");
        xMLCompositeObjectMapping3.setSetMethodName("setFactoryMethodHandleForTopLink");
        xMLCompositeObjectMapping3.setGetMethodName("getFactoryMethodHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping3.setXPath("factory-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping4 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping4.setAttributeName("instantiationMethodHandle");
        xMLCompositeObjectMapping4.setSetMethodName("setInstantiationMethodHandleForTopLink");
        xMLCompositeObjectMapping4.setGetMethodName("getInstantiationMethodHandleForTopLink");
        xMLCompositeObjectMapping4.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping4.setXPath("isntantiation-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping4);
        return xMLDescriptor;
    }

    private MWClassHandle getFactoryTypeHandleForTopLink() {
        return this.factoryTypeHandle.getType() == null ? null : this.factoryTypeHandle;
    }

    private void setFactoryTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildFactoryTypeScrubber();
        this.factoryTypeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getUseMethodHandleForTopLink() {
        return this.useMethodHandle.getMethod() == null ? null : this.useMethodHandle;
    }

    private void setUseMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildUseMethodScrubber();
        this.useMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getFactoryMethodHandleForTopLink() {
        return this.factoryMethodHandle.getMethod() == null ? null : this.factoryMethodHandle;
    }

    private void setFactoryMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildFactoryMethodScrubber();
        this.factoryMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getInstantiationMethodHandleForTopLink() {
        return this.instantiationMethodHandle.getMethod() == null ? null : this.instantiationMethodHandle;
    }

    private void setInstantiationMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildInstantiationMethodScrubber();
        this.instantiationMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

