/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDescriptorLockingPolicy
extends MWModel
implements MWLockingPolicy {
    private volatile String lockingType;
    private volatile String optimisticVersionLockingType;
    public static final String OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY = "optimisticVersionLockingType";
    public static final String OPTIMISTIC_VERSION_VERSION = "Version Locking";
    public static final String OPTIMISTIC_VERSION_TIMESTAMP = "Timestamp Locking";
    public static final String DEFAULT_OPTIMISTIC_VERSION_LOCKING_TYPE = "Version Locking";
    private volatile boolean storeInCache;
    private volatile boolean waitForLock;
    public static final String WAIT_FOR_LOCK_PROPERTY = "waitForLock";
    private volatile String retrieveTimeFrom;
    public static final String RETRIEVE_TIME_FROM_PROPERTY = "retrieveTimeFrom";
    public static final String SERVER_TIME = "Server";
    public static final String LOCAL_TIME = "Local";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.getInheritancePolicy();
        xMLDescriptor.setJavaClass(MWDescriptorLockingPolicy.class);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"None", (Object)"None");
        objectTypeConverter.addConversionValue((Object)"Optimistic Locking", (Object)"Optimistic Locking");
        objectTypeConverter.addConversionValue((Object)"Pessimistic Locking", (Object)"Pessimistic Locking");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("lockingType");
        xMLDirectMapping.setXPath("locking-type/text()");
        xMLDirectMapping.setNullValue((Object)"None");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        objectTypeConverter2.addConversionValue((Object)"Version Locking", (Object)"Version Locking");
        objectTypeConverter2.addConversionValue((Object)OPTIMISTIC_VERSION_TIMESTAMP, (Object)OPTIMISTIC_VERSION_TIMESTAMP);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY);
        xMLDirectMapping2.setXPath("version-locking-type/text()");
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter2);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        ObjectTypeConverter objectTypeConverter3 = new ObjectTypeConverter();
        objectTypeConverter3.addConversionValue((Object)SERVER_TIME, (Object)SERVER_TIME);
        objectTypeConverter3.addConversionValue((Object)LOCAL_TIME, (Object)LOCAL_TIME);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName(RETRIEVE_TIME_FROM_PROPERTY);
        xMLDirectMapping3.setXPath("retrieve-time-from/text()");
        xMLDirectMapping3.setConverter((Converter)objectTypeConverter3);
        xMLDirectMapping3.setNullValue((Object)SERVER_TIME);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("storeInCache", "store-in-cache/text()")).setNullValue((Object)Boolean.TRUE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(WAIT_FOR_LOCK_PROPERTY, "wait-for-lock/text()")).setNullValue((Object)Boolean.TRUE);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWTableDescriptorLockingPolicy.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWEisDescriptorLockingPolicy.class, (Object)"eis");
        inheritancePolicy.addClassIndicator(MWOXDescriptorLockingPolicy.class, (Object)"ox");
        return xMLDescriptor;
    }

    protected MWDescriptorLockingPolicy() {
    }

    public MWDescriptorLockingPolicy(MWTransactionalPolicy mWTransactionalPolicy) {
        super(mWTransactionalPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.lockingType = "None";
        this.storeInCache = true;
        this.waitForLock = true;
        this.retrieveTimeFrom = SERVER_TIME;
    }

    public String getLockingType() {
        return this.lockingType;
    }

    public void setLockingType(String string) {
        String string2 = this.lockingType;
        this.lockingType = string;
        this.firePropertyChanged("lockingType", string2, string);
        if (this.attributeValueHasChanged(string2, this.lockingType)) {
            if (string != "Optimistic Locking") {
                this.setOptimisticVersionLockingType(null);
            } else {
                this.setOptimisticVersionLockingType("Version Locking");
            }
        }
    }

    public boolean shouldStoreVersionInCache() {
        return this.storeInCache;
    }

    public void setStoreInCache(boolean bl) {
        boolean bl2 = this.storeInCache;
        this.storeInCache = bl;
        this.firePropertyChanged("storeInCache", bl2, bl);
    }

    public boolean shouldWaitForLock() {
        return this.waitForLock;
    }

    public void setWaitForLock(boolean bl) {
        boolean bl2 = this.waitForLock;
        this.waitForLock = bl;
        this.firePropertyChanged(WAIT_FOR_LOCK_PROPERTY, bl2, this.waitForLock);
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getLockingType());
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        if (this.getLockingType() == "Pessimistic Locking") {
            if (classDescriptor.getCMPPolicy() == null) {
                classDescriptor.setCMPPolicy(new CMPPolicy());
            }
            classDescriptor.getCMPPolicy().setPessimisticLockingPolicy(new PessimisticLockingPolicy());
            if (this.shouldWaitForLock()) {
                classDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)1);
            } else {
                classDescriptor.getCMPPolicy().getPessimisticLockingPolicy().setLockingMode((short)2);
            }
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkLockFieldSpecifiedForLockingPolicy(list);
        this.checkWriteLockFieldWritable(list);
    }

    protected abstract void checkLockFieldSpecifiedForLockingPolicy(List var1);

    protected void checkWriteLockFieldWritable(List list) {
        if (this.getLockingType() != "Optimistic Locking") {
            return;
        }
        if (this.shouldStoreVersionInCache()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getOwningDescriptor().mappingsIncludingInherited();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (mWMapping.isReadOnly()) continue;
            mWMapping.addWrittenFieldsTo(arrayList);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                if (iterator2.next() != this.getVersionLockField()) continue;
                return;
            }
            arrayList.clear();
        }
        list.add(this.buildProblem("0305"));
    }

    public String getOptimisticVersionLockingType() {
        return this.optimisticVersionLockingType;
    }

    public void setOptimisticVersionLockingType(String string) {
        String string2 = this.optimisticVersionLockingType;
        this.optimisticVersionLockingType = string;
        this.firePropertyChanged(OPTIMISTIC_VERSION_LOCKING_TYPE_PROPERTY, string2, this.optimisticVersionLockingType);
    }

    public String getRetrieveTimeFrom() {
        return this.retrieveTimeFrom;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == SERVER_TIME;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == LOCAL_TIME;
    }

    public void setRetrieveTimeFrom(String string) {
        String string2 = this.retrieveTimeFrom;
        this.retrieveTimeFrom = string;
        this.firePropertyChanged(RETRIEVE_TIME_FROM_PROPERTY, string2, this.retrieveTimeFrom);
    }
}

