/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWReturningPolicy
extends MWAbstractDescriptorPolicy {
    private Collection insertFieldReturnOnlyFlags;
    public static final String INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION = "insertFieldReturnOnlyFlags";
    public static final String UPDATE_FIELDS_COLLECTION = "updateFields";

    protected MWReturningPolicy() {
    }

    protected MWReturningPolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.insertFieldReturnOnlyFlags = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.insertFieldReturnOnlyFlags;
        synchronized (collection) {
            list.addAll(this.insertFieldReturnOnlyFlags);
        }
    }

    public Iterator insertFieldReturnOnlyFlags() {
        return new CloneIterator(this.insertFieldReturnOnlyFlags){

            protected void remove(Object object) {
                MWReturningPolicy.this.removeInsertFieldReturnOnlyFlag((MWReturningPolicyInsertFieldReturnOnlyFlag)object);
            }
        };
    }

    public int insertFieldReturnOnlyFlagsSize() {
        return this.insertFieldReturnOnlyFlags.size();
    }

    public void addInsertFieldReadOnlyFlag(MWReturningPolicyInsertFieldReturnOnlyFlag mWReturningPolicyInsertFieldReturnOnlyFlag) {
        this.addItemToCollection(mWReturningPolicyInsertFieldReturnOnlyFlag, this.insertFieldReturnOnlyFlags, INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION);
    }

    public void removeInsertFieldReturnOnlyFlag(MWReturningPolicyInsertFieldReturnOnlyFlag mWReturningPolicyInsertFieldReturnOnlyFlag) {
        this.removeItemFromCollection(mWReturningPolicyInsertFieldReturnOnlyFlag, this.insertFieldReturnOnlyFlags, INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION);
    }

    public Iterator insertFields() {
        return new TransformationIterator(this.insertFieldReturnOnlyFlags()){

            protected Object transform(Object object) {
                return ((MWReturningPolicyInsertFieldReturnOnlyFlag)object).getField();
            }
        };
    }

    public abstract Iterator updateFields();

    public abstract int updateFieldsSize();

    public abstract void removeUpdateField(MWDataField var1);

    public boolean isActive() {
        return true;
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkTypeIndicatorField(list);
        this.checkOptimisticLockingField(list);
        this.checkReturningFieldIsmapped(list);
    }

    private void checkTypeIndicatorField(List list) {
        MWClassIndicatorPolicy mWClassIndicatorPolicy = this.getOwningDescriptor().getInheritancePolicy().getClassIndicatorPolicy();
        if (mWClassIndicatorPolicy.getType() == "fieldClassIndicatorPolicy") {
            MWDataField mWDataField = ((MWClassIndicatorFieldPolicy)mWClassIndicatorPolicy).getField();
            if (CollectionTools.contains(this.updateFields(), (Object)mWDataField)) {
                list.add(this.buildProblem("0334", mWDataField.fieldName()));
            }
            if (CollectionTools.contains(this.insertFields(), (Object)mWDataField)) {
                list.add(this.buildProblem("0335", mWDataField.fieldName()));
            }
        }
    }

    private void checkOptimisticLockingField(List list) {
        MWLockingPolicy mWLockingPolicy = this.getOwningDescriptor().getLockingPolicy();
        MWDataField mWDataField = mWLockingPolicy.getVersionLockField();
        if (mWDataField != null) {
            if (CollectionTools.contains(this.updateFields(), (Object)mWDataField)) {
                list.add(this.buildProblem("0337", mWDataField.fieldName()));
            }
            if (CollectionTools.contains(this.insertFields(), (Object)mWDataField)) {
                list.add(this.buildProblem("0336", mWDataField.fieldName()));
            }
        }
    }

    private void checkReturningFieldIsmapped(List list) {
        MWDataField mWDataField;
        Iterator iterator = this.updateFields();
        while (iterator.hasNext()) {
            mWDataField = (MWDataField)iterator.next();
            if (!this.getOwningDescriptor().allWritableMappingsForField(mWDataField).isEmpty()) continue;
            list.add(this.buildProblem("0340", mWDataField.fieldName()));
        }
        iterator = this.insertFields();
        while (iterator.hasNext()) {
            mWDataField = (MWDataField)iterator.next();
            if (!this.getOwningDescriptor().allWritableMappingsForField(mWDataField).isEmpty()) continue;
            list.add(this.buildProblem("0341", mWDataField.fieldName()));
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        ReturningPolicy returningPolicy = new ReturningPolicy();
        classDescriptor.setReturningPolicy(returningPolicy);
        Iterator iterator = this.insertFieldReturnOnlyFlags();
        while (iterator.hasNext()) {
            ((MWReturningPolicyInsertFieldReturnOnlyFlag)iterator.next()).adjustRuntimeReturningPolicy(returningPolicy);
        }
        iterator = this.updateFields();
        while (iterator.hasNext()) {
            returningPolicy.addFieldForUpdate(((MWDataField)iterator.next()).runtimeField());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInsertFieldReturnOnlyFlagsForTopLink() {
        Collection collection = this.insertFieldReturnOnlyFlags;
        synchronized (collection) {
            return new TreeSet(this.insertFieldReturnOnlyFlags);
        }
    }

    private void setInsertFieldReturnOnlyFlagsForTopLink(Collection collection) {
        this.insertFieldReturnOnlyFlags = collection;
    }
}

