/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWSecondaryTableHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorMultiTableInfoPolicy
extends MWAbstractDescriptorPolicy {
    private Collection secondaryTableHolders;
    public static final String SECONDARY_TABLE_HOLDERS_COLLECTION = "secondaryTableHolders";

    private MWDescriptorMultiTableInfoPolicy() {
    }

    public MWDescriptorMultiTableInfoPolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.secondaryTableHolders = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.secondaryTableHolders;
        synchronized (collection) {
            list.addAll(this.secondaryTableHolders);
        }
    }

    public MWSecondaryTableHolder addSecondaryTable(MWTable mWTable) {
        MWSecondaryTableHolder mWSecondaryTableHolder = new MWSecondaryTableHolder(this, mWTable);
        this.addItemToCollection(mWSecondaryTableHolder, this.secondaryTableHolders, SECONDARY_TABLE_HOLDERS_COLLECTION);
        return mWSecondaryTableHolder;
    }

    public void removeSecondaryTable(MWTable mWTable) {
        Iterator iterator = this.secondaryTableHolders();
        while (iterator.hasNext()) {
            MWSecondaryTableHolder mWSecondaryTableHolder = (MWSecondaryTableHolder)iterator.next();
            if (mWSecondaryTableHolder.getTable() != mWTable) continue;
            this.removeSecondaryTableHolder(mWSecondaryTableHolder);
            return;
        }
    }

    void removeSecondaryTableHolder(MWSecondaryTableHolder mWSecondaryTableHolder) {
        this.removeItemFromCollection(mWSecondaryTableHolder, this.secondaryTableHolders, SECONDARY_TABLE_HOLDERS_COLLECTION);
    }

    public MWSecondaryTableHolder secondaryTableHolderFor(MWTable mWTable) {
        Iterator iterator = this.secondaryTableHolders();
        while (iterator.hasNext()) {
            MWSecondaryTableHolder mWSecondaryTableHolder = (MWSecondaryTableHolder)iterator.next();
            if (mWSecondaryTableHolder.getTable() != mWTable) continue;
            return mWSecondaryTableHolder;
        }
        return null;
    }

    public Iterator secondaryTableHolders() {
        return new CloneIterator(this.secondaryTableHolders);
    }

    private MWReference secondaryReferenceFor(MWTable mWTable) {
        Iterator iterator = this.secondaryReferences();
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            if (mWReference.getSourceTable() != mWTable && mWReference.getTargetTable() != mWTable) continue;
            return mWReference;
        }
        return null;
    }

    private Iterator secondaryReferences() {
        ArrayList<MWReference> arrayList = new ArrayList<MWReference>();
        Iterator iterator = this.secondaryTableHolders();
        while (iterator.hasNext()) {
            MWSecondaryTableHolder mWSecondaryTableHolder = (MWSecondaryTableHolder)iterator.next();
            if (mWSecondaryTableHolder.primaryKeysHaveSameName() || mWSecondaryTableHolder.getReference() == null) continue;
            arrayList.add(mWSecondaryTableHolder.getReference());
        }
        return arrayList.iterator();
    }

    public int secondaryTableHoldersSize() {
        return this.secondaryTableHolders.size();
    }

    public Iterator secondaryTables() {
        return new TransformationIterator(this.secondaryTableHolders()){

            protected Object transform(Object object) {
                return ((MWSecondaryTableHolder)object).getTable();
            }
        };
    }

    private MWTableDescriptor getTableDescriptor() {
        return (MWTableDescriptor)this.getOwningDescriptor();
    }

    public boolean isActive() {
        return true;
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkPrimaryKeysAcrossMultipleTables(list);
    }

    private void checkPrimaryKeysAcrossMultipleTables(List list) {
        if (!this.pksAcrossMultipleTablesTest(false)) {
            list.add(this.buildProblem("0319"));
        }
    }

    public boolean pksAcrossMultipleTablesTest(boolean bl) {
        int n = this.getTableDescriptor().associatedTablesSize();
        if (n < 2) {
            return !bl;
        }
        MWTable mWTable = this.getTableDescriptor().getPrimaryTable();
        if (mWTable == null) {
            return false;
        }
        Iterator iterator = this.getTableDescriptor().associatedTables();
        while (iterator.hasNext()) {
            MWTable mWTable2 = (MWTable)iterator.next();
            MWSecondaryTableHolder mWSecondaryTableHolder = this.secondaryTableHolderFor(mWTable2);
            if (mWSecondaryTableHolder == null || !mWSecondaryTableHolder.primaryKeysHaveSameName()) continue;
            Iterator iterator2 = mWTable.primaryKeyColumns();
            while (iterator2.hasNext()) {
                MWColumn mWColumn = (MWColumn)iterator2.next();
                MWColumn mWColumn2 = mWTable2.columnNamed(mWColumn.getName());
                if (mWColumn2 != null && mWColumn2.isPrimaryKey()) continue;
                return false;
            }
        }
        return true;
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        Object object;
        classDescriptor.getAdditionalTablePrimaryKeyFields();
        Iterator iterator = this.getTableDescriptor().secondaryTables();
        while (iterator.hasNext()) {
            object = (MWTable)iterator.next();
            ((RelationalDescriptor)classDescriptor).addTableName(((MWTable)object).getName());
        }
        object = this.secondaryReferences();
        while (object.hasNext()) {
            MWReference mWReference = (MWReference)object.next();
            Iterator iterator2 = mWReference.columnPairs();
            while (iterator2.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)iterator2.next();
                if (mWColumnPair.getSourceColumn() == null || mWColumnPair.getTargetColumn() == null) continue;
                String string = mWColumnPair.getSourceColumn().qualifiedName();
                String string2 = mWColumnPair.getTargetColumn().qualifiedName();
                classDescriptor.addForeignKeyFieldNameForMultipleTable(string, string2);
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorMultiTableInfoPolicy.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(SECONDARY_TABLE_HOLDERS_COLLECTION);
        xMLCompositeCollectionMapping.setReferenceClass(MWSecondaryTableHolder.class);
        xMLCompositeCollectionMapping.setXPath("secondary-table-holders/table-holder");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }
}

