/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWInterfaceDescriptor
extends MWDescriptor
implements MWRelationalDescriptor {
    private Collection implementorHandles;
    public static final String IMPLEMENTORS_COLLECTION = "implementors";
    private MWHandle.NodeReferenceScrubber implementorScrubber;
    private MWInheritancePolicy nullInheritancePolicy = new MWNullInheritancePolicy(this);

    private MWInterfaceDescriptor() {
    }

    public MWInterfaceDescriptor(MWProject mWProject, MWClass mWClass, String string) {
        super(mWProject, mWClass, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.implementorHandles = new Vector();
    }

    private Iterator implementorHandles() {
        return new CloneIterator(this.implementorHandles){

            protected void remove(Object object) {
                MWInterfaceDescriptor.this.removeImplementorHandle((MWDescriptorHandle)object);
            }
        };
    }

    void removeImplementorHandle(MWDescriptorHandle mWDescriptorHandle) {
        this.implementorHandles.remove(mWDescriptorHandle);
        this.fireItemRemoved(IMPLEMENTORS_COLLECTION, mWDescriptorHandle.getDescriptor());
        this.getProject().implementorsChangedFor(this);
    }

    public Iterator implementors() {
        return new TransformationIterator(this.implementorHandles()){

            protected Object transform(Object object) {
                return ((MWDescriptorHandle)object).getDescriptor();
            }
        };
    }

    public int implementorsSize() {
        return this.implementorHandles.size();
    }

    public void addImplementor(MWDescriptor mWDescriptor) {
        if (CollectionTools.contains(this.implementors(), (Object)mWDescriptor)) {
            throw new IllegalArgumentException(mWDescriptor.toString());
        }
        this.implementorHandles.add(new MWDescriptorHandle(this, mWDescriptor, this.implementorScrubber()));
        this.fireItemAdded(IMPLEMENTORS_COLLECTION, mWDescriptor);
        this.getProject().implementorsChangedFor(this);
    }

    public void removeImplementor(MWDescriptor mWDescriptor) {
        Iterator iterator = this.implementors();
        while (iterator.hasNext()) {
            if (iterator.next() != mWDescriptor) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWDescriptor.toString());
    }

    public void removeImplementors(Collection collection) {
        this.removeImplementors(collection.iterator());
    }

    public void removeImplementors(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeImplementor((MWDescriptor)iterator.next());
        }
    }

    public void clearImplementors() {
        Iterator iterator = this.implementorHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public SortedSet getAllQueryKeys() {
        HashBag hashBag = new HashBag();
        TreeSet<MWQueryKey> treeSet = new TreeSet<MWQueryKey>();
        MWTableDescriptor mWTableDescriptor = null;
        Iterator iterator = this.implementors();
        while (iterator.hasNext()) {
            mWTableDescriptor = (MWTableDescriptor)iterator.next();
            Iterator iterator2 = mWTableDescriptor.getAllQueryKeysIncludingInherited().iterator();
            Object object = new ArrayList();
            while (iterator2.hasNext()) {
                String string = ((MWQueryKey)iterator2.next()).getName();
                if (object.contains(string)) continue;
                object.add(string);
                hashBag.add(string);
            }
        }
        for (Object object : hashBag) {
            if (hashBag.count(object) != this.implementorsSize()) continue;
            treeSet.add(mWTableDescriptor.queryKeyNamedIncludingInherited((String)object));
        }
        return treeSet;
    }

    public Iterator allQueryKeyNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((MWQueryKey)object).getName();
            }
        };
    }

    public boolean hasImplementor(MWDescriptor mWDescriptor) {
        return CollectionTools.contains(this.implementors(), (Object)mWDescriptor);
    }

    public Iterator allAssociatedFields() {
        return NullIterator.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.implementorHandles;
        synchronized (collection) {
            list.addAll(this.implementorHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber implementorScrubber() {
        if (this.implementorScrubber == null) {
            this.implementorScrubber = this.buildImplementorScrubber();
        }
        return this.implementorScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildImplementorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWInterfaceDescriptor.this.removeImplementorHandle((MWDescriptorHandle)mWHandle);
            }

            public String toString() {
                return "MWInterfaceDescriptor.buildImplementorScrubber()";
            }
        };
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        super.descriptorReplaced(mWDescriptor, mWDescriptor2);
        if (this.hasImplementor(mWDescriptor)) {
            this.removeImplementor(mWDescriptor);
            if (mWDescriptor2 instanceof MWTableDescriptor) {
                this.addImplementor(mWDescriptor2);
            }
        }
    }

    public void initializeOn(MWDescriptor mWDescriptor) {
        ((MWRelationalDescriptor)((Object)mWDescriptor)).initializeFromMWInterfaceDescriptor(this);
    }

    protected void refreshClass(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(mWClassRefreshPolicy);
        if (!this.getMWClass().isInterface()) {
            this.asMWTableDescriptor();
        }
    }

    public void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy mWProjectDefaultsPolicy) {
    }

    public void unmap() {
        super.unmap();
        this.clearImplementors();
    }

    public boolean canHaveInheritance() {
        return false;
    }

    public MWInheritancePolicy getInheritancePolicy() {
        return this.nullInheritancePolicy;
    }

    public boolean hasDefinedInheritance() {
        return false;
    }

    public boolean hasActiveInstantiationPolicy() {
        return false;
    }

    public Iterator allQueryKeys() {
        return this.getAllQueryKeys().iterator();
    }

    public Iterator allQueryKeysIncludingInherited() {
        return this.allQueryKeys();
    }

    public Iterator allQueryKeyNames() {
        return new TransformationIterator(this.allQueryKeys()){

            protected Object transform(Object object) {
                return ((MWQueryKey)object).getName();
            }
        };
    }

    public MWQueryKey queryKeyNamed(String string) {
        Iterator iterator = this.allQueryKeys();
        while (iterator.hasNext()) {
            MWQueryKey mWQueryKey = (MWQueryKey)iterator.next();
            if (!mWQueryKey.getName().equals(string)) continue;
            return mWQueryKey;
        }
        return null;
    }

    public MWQueryKey queryKeyNamedIncludingInherited(String string) {
        return this.queryKeyNamed(string);
    }

    public Iterator associatedTables() {
        return NullIterator.instance();
    }

    public int associatedTablesSize() {
        return 0;
    }

    public MWTable getPrimaryTable() {
        return null;
    }

    public Iterator associatedTablesIncludingInherited() {
        return this.associatedTables();
    }

    public int associatedTablesIncludingInheritedSize() {
        return this.associatedTablesSize();
    }

    public Iterator candidateTables() {
        return this.associatedTables();
    }

    public int candidateTablesSize() {
        return this.associatedTablesSize();
    }

    public Iterator candidateTablesIncludingInherited() {
        return this.candidateTables();
    }

    public int candidateTablesIncludingInheritedSize() {
        return this.candidateTablesSize();
    }

    public void notifyExpressionsToRecalculateQueryables() {
    }

    public List getQueryables(Filter filter) {
        return Collections.EMPTY_LIST;
    }

    public boolean isTableDescriptor() {
        return false;
    }

    public boolean isAggregateDescriptor() {
        return false;
    }

    public Collection buildAggregateFieldNameGenerators() {
        return Collections.EMPTY_SET;
    }

    public void initializeFromMWAggregateDescriptor(MWAggregateDescriptor mWAggregateDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(mWAggregateDescriptor);
    }

    public void initializeFromMWRelationalClassDescriptor(MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        this.initializeFromMWMappingDescriptor(mWRelationalClassDescriptor);
    }

    public void initializeFromMWTableDescriptor(MWTableDescriptor mWTableDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(mWTableDescriptor);
    }

    public void initializeFromMWInterfaceDescriptor(MWInterfaceDescriptor mWInterfaceDescriptor) {
        this.initializeFromMWDescriptor(mWInterfaceDescriptor);
    }

    public MWAggregateDescriptor asMWAggregateDescriptor() {
        throw new RuntimeException("Can't change an interface descriptor to an aggregate descriptor unless the type is not an interface.");
    }

    public MWTableDescriptor asMWTableDescriptor() throws InterfaceDescriptorCreationException {
        if (this.getMWClass().isInterface()) {
            throw new RuntimeException("Can't change an interface descriptor to a class descriptor unless the type is not an interface.");
        }
        MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(mWTableDescriptor);
        return mWTableDescriptor;
    }

    public MWInterfaceDescriptor asMWInterfaceDescriptor() {
        return this;
    }

    public boolean isInterfaceDescriptor() {
        return true;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkImplementors(list);
    }

    private void checkImplementors(List list) {
        Iterator iterator = this.implementors();
        while (iterator.hasNext()) {
            MWDescriptor mWDescriptor = (MWDescriptor)iterator.next();
            if (CollectionTools.contains(mWDescriptor.getMWClass().allInterfaces(), (Object)this.getMWClass())) continue;
            list.add(this.buildProblem("0225", mWDescriptor.displayString()));
        }
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor classDescriptor = super.buildRuntimeDescriptor();
        Iterator iterator = this.allQueryKeys();
        while (iterator.hasNext()) {
            MWQueryKey mWQueryKey = (MWQueryKey)iterator.next();
            QueryKey queryKey = new QueryKey();
            queryKey.setName(mWQueryKey.getName());
            classDescriptor.addQueryKey(queryKey);
        }
        return classDescriptor;
    }

    protected ClassDescriptor buildBasicRuntimeDescriptor() {
        RelationalDescriptor relationalDescriptor = new RelationalDescriptor();
        relationalDescriptor.setJavaClassName(this.getMWClass().getName());
        relationalDescriptor.descriptorIsForInterface();
        return relationalDescriptor;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWInterfaceDescriptor.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDescriptor.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("implementorHandles");
        xMLCompositeCollectionMapping.setSetMethodName("setImplementorHandlesForTopLink");
        xMLCompositeCollectionMapping.setGetMethodName("getImplementorHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWDescriptorHandle.class);
        xMLCompositeCollectionMapping.setXPath("implementor-handles/descriptor-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getImplementorHandlesForTopLink() {
        Collection collection = this.implementorHandles;
        synchronized (collection) {
            return new TreeSet(this.implementorHandles);
        }
    }

    private void setImplementorHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWDescriptorHandle)iterator.next()).setScrubber(this.implementorScrubber());
        }
        this.implementorHandles = collection;
    }
}

