/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public final class MWRelationalClassIndicatorFieldPolicy
extends MWClassIndicatorFieldPolicy
implements AggregateRuntimeFieldNameGenerator {
    private MWColumnHandle columnHandle;
    public static final String FIELD_PROPERTY = "field";
    private static final PartialStringMatcher COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    private MWRelationalClassIndicatorFieldPolicy() {
    }

    public MWRelationalClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    public MWRelationalClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator iterator) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(iterator);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalClassIndicatorFieldPolicy.this.setColumn(null);
            }

            public String toString() {
                return "MWRelationalClassIndicatorFieldPolicy.buildColumnScrubber()";
            }
        };
    }

    public MWDataField getField() {
        return this.getColumn();
    }

    public void setField(MWDataField mWDataField) {
        this.setColumn((MWColumn)mWDataField);
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.columnHandle.getColumn();
        this.columnHandle.setColumn(mWColumn);
        this.firePropertyChanged(FIELD_PROPERTY, mWColumn2, mWColumn);
    }

    protected boolean fieldSpecified() {
        return ((MWRelationalDescriptor)((Object)this.getContainingDescriptor())).isAggregateDescriptor() || this.getField() != null;
    }

    public String fieldNameForRuntime() {
        return "CLASS_INDICATOR_FIELD";
    }

    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            public String getMessageKey() {
                if (MWRelationalClassIndicatorFieldPolicy.this.getParent() instanceof MWDescriptorInheritancePolicy) {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_INDICATOR_FIELD_FOR_INHERITANCE";
                }
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_INDICATOR_FIELD";
            }

            public Object[] getMessageArguments() {
                return new Object[0];
            }
        };
    }

    public void parentDescriptorMorphedToAggregate() {
        this.setField(null);
    }

    public boolean fieldIsWritten() {
        return true;
    }

    public MWDescriptor owningDescriptor() {
        return this.getContainingDescriptor();
    }

    public void addToAggregateFieldNameGenerators(Collection collection) {
        collection.add(this);
    }

    public void automap() {
        super.automap();
        this.automapColumn();
    }

    private void automapColumn() {
        double d;
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getContainingDescriptor());
        if (!mWRelationalDescriptor.isAggregateDescriptor()) {
            return;
        }
        ColumnStringHolder[] columnStringHolderArray = this.allUnmappedColumnStringHolders((MWTableDescriptor)mWRelationalDescriptor);
        if (columnStringHolderArray.length == 0) {
            return;
        }
        PartialStringMatcher.StringHolderScore stringHolderScore = this.match("type", columnStringHolderArray);
        PartialStringMatcher.StringHolderScore stringHolderScore2 = this.match("class", columnStringHolderArray);
        MWColumn mWColumn = ((ColumnStringHolder)stringHolderScore.getStringHolder()).getColumn();
        MWColumn mWColumn2 = ((ColumnStringHolder)stringHolderScore2.getStringHolder()).getColumn();
        double d2 = stringHolderScore.getScore();
        if (Math.max(d2, d = stringHolderScore2.getScore()) > 0.5) {
            this.setField(d2 >= d ? mWColumn : mWColumn2);
        }
    }

    private ColumnStringHolder[] allUnmappedColumnStringHolders(MWTableDescriptor mWTableDescriptor) {
        HashSet hashSet = new HashSet();
        Object object = mWTableDescriptor.associatedTables();
        while (object.hasNext()) {
            CollectionTools.addAll(hashSet, ((MWTable)object.next()).columns());
        }
        object = new HashSet();
        Iterator iterator = mWTableDescriptor.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            mWMapping.addWrittenFieldsTo((Collection)object);
        }
        hashSet.removeAll((Collection<?>)object);
        return ColumnStringHolder.buildHolders(hashSet);
    }

    private PartialStringMatcher.StringHolderScore match(String string, ColumnStringHolder[] columnStringHolderArray) {
        return COLUMN_NAME_MATCHER.match(string, columnStringHolderArray);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.addClassIndicatorFieldNotSpecifiedProblemTo(list);
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List list) {
        ((Parent)((Object)this.getParent())).addClassIndicatorFieldNotSpecifiedProblemTo(list);
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy inheritancePolicy) {
        super.adjustRuntimeInheritancePolicy(inheritancePolicy);
        if (this.getColumn() != null) {
            inheritancePolicy.setClassIndicatorFieldName(this.getColumn().qualifiedName());
        } else {
            inheritancePolicy.setClassIndicatorFieldName(this.fieldNameForRuntime());
        }
    }

    public void adjustRuntimeMapping(VariableOneToOneMapping variableOneToOneMapping) {
        String string = null;
        if (this.getField() != null) {
            string = this.getColumn().qualifiedName();
        } else if (((MWVariableOneToOneMapping)this.getParent()).parentDescriptorIsAggregate()) {
            string = variableOneToOneMapping.getAttributeName() + "->" + this.fieldNameForRuntime();
        }
        if (string != null && !string.equals("")) {
            variableOneToOneMapping.setTypeFieldName(string);
            Iterator iterator = this.includedClassIndicatorValues();
            while (iterator.hasNext()) {
                Object object = ((MWClassIndicatorValue)iterator.next()).getIndicatorValue();
                variableOneToOneMapping.addClassNameIndicator(this.getDescriptorForIndicator(object).getMWClass().getName(), object);
            }
        } else {
            variableOneToOneMapping.setTypeFieldName("");
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalClassIndicatorFieldPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWClassIndicatorFieldPolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("columnHandle");
        xMLCompositeObjectMapping.setGetMethodName("getColumnHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildColumnScrubber();
        this.columnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    public static interface Parent {
        public void addClassIndicatorFieldNotSpecifiedProblemTo(List var1);
    }
}

