/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalDescriptorInheritancePolicy
extends MWDescriptorInheritancePolicy
implements MWRelationalClassIndicatorFieldPolicy.Parent {
    private volatile boolean readSubclassesOnQuery;
    public static String READ_SUBCLASSES_ON_QUERY_PROPERTY = "readSubclassesOnQuery";
    private MWTableHandle readAllSubclassesViewHandle;
    public static String READ_ALL_SUBCLASSES_VIEW_PROPERTY = "readAllSubclassesView";
    private volatile boolean outerJoinAllSubclasses;
    public static String OUTER_JOIN_ALL_SUBCLASSES = "outerJoinAllSubclasses";

    private MWRelationalDescriptorInheritancePolicy() {
    }

    MWRelationalDescriptorInheritancePolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.readSubclassesOnQuery = true;
        this.outerJoinAllSubclasses = false;
        this.readAllSubclassesViewHandle = new MWTableHandle(this, this.buildReadAllSubclassesViewScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.readAllSubclassesViewHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReadAllSubclassesViewScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalDescriptorInheritancePolicy.this.setReadAllSubclassesView(null);
            }

            public String toString() {
                return "MWRelationalDescriptorInheritancePolicy.buildReadAllSubclassesViewScrubber()";
            }
        };
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        super.adjustRuntimeDescriptor(classDescriptor);
        InheritancePolicy inheritancePolicy = classDescriptor.getInheritancePolicy();
        if (this.getReadAllSubclassesView() != null) {
            inheritancePolicy.setReadAllSubclassesViewName(this.getReadAllSubclassesView().getName());
        }
        inheritancePolicy.setShouldOuterJoinSubclasses(this.isOuterJoinAllSubclasses());
        inheritancePolicy.setShouldReadSubclasses(this.isReadSubclassesOnQuery());
    }

    protected MWClassIndicatorFieldPolicy buildClassIndicatorFieldPolicy() {
        return new MWRelationalClassIndicatorFieldPolicy(this, this.getAllDescriptorsAvailableForIndicatorDictionary().iterator());
    }

    public MWTable getReadAllSubclassesView() {
        return this.readAllSubclassesViewHandle.getTable();
    }

    public void dispose() {
        super.dispose();
        ((MWRelationalProject)this.getProject()).notifyExpressionsToRecalculateQueryables();
    }

    public void setParentDescriptor(MWMappingDescriptor mWMappingDescriptor) {
        super.setParentDescriptor(mWMappingDescriptor);
        ((MWRelationalProject)this.getProject()).notifyExpressionsToRecalculateQueryables();
    }

    public void setReadAllSubclassesView(MWTable mWTable) {
        MWTable mWTable2 = this.readAllSubclassesViewHandle.getTable();
        this.readAllSubclassesViewHandle.setTable(mWTable);
        this.firePropertyChanged(READ_ALL_SUBCLASSES_VIEW_PROPERTY, mWTable2, mWTable);
    }

    public void setReadSubclassesOnQuery(boolean bl) {
        boolean bl2 = this.isReadSubclassesOnQuery();
        this.readSubclassesOnQuery = bl;
        this.firePropertyChanged(READ_SUBCLASSES_ON_QUERY_PROPERTY, bl2, this.isReadSubclassesOnQuery());
    }

    public boolean isReadSubclassesOnQuery() {
        return this.readSubclassesOnQuery;
    }

    protected void setClassIndicatorPolicy(MWClassIndicatorPolicy mWClassIndicatorPolicy) {
        super.setClassIndicatorPolicy(mWClassIndicatorPolicy);
        this.getProject().recalculateAggregatePathsToColumn(this.getOwningDescriptor());
    }

    public boolean isOuterJoinAllSubclasses() {
        return this.outerJoinAllSubclasses;
    }

    public void setOuterJoinAllSubclasses(boolean bl) {
        boolean bl2 = this.isOuterJoinAllSubclasses();
        this.outerJoinAllSubclasses = bl;
        this.firePropertyChanged(OUTER_JOIN_ALL_SUBCLASSES, bl2, this.isOuterJoinAllSubclasses());
    }

    public void automap() {
        super.automap();
        this.getClassIndicatorPolicy().automap();
    }

    protected String descendantDescriptorTypeMismatchProblemString() {
        return "0325";
    }

    protected boolean checkDescendantsForDescriptorTypeMismatch() {
        Iterator iterator = this.descendentDescriptors();
        while (iterator.hasNext()) {
            MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)iterator.next();
            if (mWRelationalDescriptor.isAggregateDescriptor() == ((MWRelationalDescriptor)((Object)this.getOwningDescriptor())).isAggregateDescriptor()) continue;
            return true;
        }
        return false;
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List list) {
        ((MWClassIndicatorFieldPolicy)this.getClassIndicatorPolicy()).checkClassIndicatorField(list);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDescriptorInheritancePolicy.class);
        xMLDescriptor.setJavaClass(MWRelationalDescriptorInheritancePolicy.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("readSubclassesOnQuery");
        xMLDirectMapping.setXPath("read-subclasses-on-query/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.TRUE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("outerJoinAllSubclasses");
        xMLDirectMapping2.setXPath("outer-join-all-subclasses/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("readAllSubclassesViewHandle");
        xMLCompositeObjectMapping.setGetMethodName("getReadAllSubclassesViewHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setReadAllSubclassesViewHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("read-all-subclasses-view-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWTableHandle getReadAllSubclassesViewHandleForTopLink() {
        return this.readAllSubclassesViewHandle.getTable() == null ? null : this.readAllSubclassesViewHandle;
    }

    private void setReadAllSubclassesViewHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReadAllSubclassesViewScrubber();
        this.readAllSubclassesViewHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }
}

