/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalPrimaryKeyPolicy
extends MWModel {
    protected Collection primaryKeyHandles;
    public static final String PRIMARY_KEYS_COLLECTION = "primaryKeys";
    private MWHandle.NodeReferenceScrubber primaryKeyScrubber;

    private MWRelationalPrimaryKeyPolicy() {
    }

    MWRelationalPrimaryKeyPolicy(MWRelationalTransactionalPolicy mWRelationalTransactionalPolicy) {
        super(mWRelationalTransactionalPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.primaryKeyHandles = new Vector();
    }

    private Iterator primaryKeyHandles() {
        return new CloneIterator(this.primaryKeyHandles){

            protected void remove(Object object) {
                MWRelationalPrimaryKeyPolicy.this.removePrimaryKeyHandle((MWColumnHandle)object);
            }
        };
    }

    void removePrimaryKeyHandle(MWColumnHandle mWColumnHandle) {
        this.primaryKeyHandles.remove(mWColumnHandle);
        this.fireItemRemoved(PRIMARY_KEYS_COLLECTION, mWColumnHandle.getColumn());
    }

    public Iterator primaryKeys() {
        return new TransformationIterator(this.primaryKeyHandles()){

            protected Object transform(Object object) {
                return ((MWColumnHandle)object).getColumn();
            }
        };
    }

    public int primaryKeysSize() {
        return this.primaryKeyHandles.size();
    }

    public void addPrimaryKey(MWColumn mWColumn) {
        if (this.containsPrimaryKey(mWColumn)) {
            throw new IllegalArgumentException(mWColumn.toString());
        }
        this.primaryKeyHandles.add(new MWColumnHandle(this, mWColumn, this.primaryKeyScrubber()));
        this.fireItemAdded(PRIMARY_KEYS_COLLECTION, mWColumn);
    }

    public void removePrimaryKey(MWColumn mWColumn) {
        Iterator iterator = this.primaryKeys();
        while (iterator.hasNext()) {
            if (iterator.next() != mWColumn) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWColumn.toString());
    }

    public boolean containsPrimaryKey(MWColumn mWColumn) {
        return CollectionTools.contains(this.primaryKeys(), (Object)mWColumn);
    }

    public void clearPrimaryKeys() {
        Iterator iterator = this.primaryKeyHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.primaryKeyHandles;
        synchronized (collection) {
            list.addAll(this.primaryKeyHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber primaryKeyScrubber() {
        if (this.primaryKeyScrubber == null) {
            this.primaryKeyScrubber = this.buildPrimaryKeyScrubber();
        }
        return this.primaryKeyScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildPrimaryKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalPrimaryKeyPolicy.this.removePrimaryKeyHandle((MWColumnHandle)mWHandle);
            }

            public String toString() {
                return "MWRelationalPrimaryKeyPolicy.buildPrimaryKeyScrubber()";
            }
        };
    }

    void descriptorPrimaryTableChanged(MWTable mWTable) {
        this.clearPrimaryKeys();
        if (mWTable == null) {
            return;
        }
        Iterator iterator = mWTable.primaryKeyColumns();
        while (iterator.hasNext()) {
            this.addPrimaryKey((MWColumn)iterator.next());
        }
    }

    public MWTableDescriptor getTableDescriptor() {
        return (MWTableDescriptor)((MWRelationalTransactionalPolicy)this.getParent()).getParent();
    }

    public Iterator primaryKeyChoices() {
        MWTable mWTable = this.getTableDescriptor().getPrimaryTable();
        if (mWTable == null) {
            return NullIterator.instance();
        }
        return new FilteringIterator(mWTable.columns()){

            protected boolean accept(Object object) {
                return !MWRelationalPrimaryKeyPolicy.this.containsPrimaryKey((MWColumn)object);
            }
        };
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        Iterator iterator = this.primaryKeys();
        while (iterator.hasNext()) {
            classDescriptor.addPrimaryKeyField(((MWDataField)iterator.next()).runtimeField());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalPrimaryKeyPolicy.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeCollectionMapping.setAttributeName("primaryKeyHandles");
        xMLCompositeCollectionMapping.setGetMethodName("getPrimaryKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setPrimaryKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setXPath("primary-key-handles/column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPrimaryKeyHandlesForTopLink() {
        Collection collection = this.primaryKeyHandles;
        synchronized (collection) {
            return new TreeSet(this.primaryKeyHandles);
        }
    }

    private void setPrimaryKeyHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWColumnHandle)iterator.next()).setScrubber(this.primaryKeyScrubber());
        }
        this.primaryKeyHandles = collection;
    }

    protected void legacySetPrimaryKeys(Collection collection) {
        this.setPrimaryKeyHandlesForTopLink(collection);
    }
}

