/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWDescriptorMultiTableInfoPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWSecondaryTableHolder
extends MWModel {
    private MWTableHandle tableHandle;
    private volatile boolean primaryKeysHaveSameName;
    public static final String PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY = "primaryKeysHaveSameName";
    private MWReferenceHandle referenceHandle;
    public static final String REFERENCE_PROPERTY = "reference";

    private MWSecondaryTableHolder() {
    }

    MWSecondaryTableHolder(MWDescriptorMultiTableInfoPolicy mWDescriptorMultiTableInfoPolicy, MWTable mWTable) {
        super(mWDescriptorMultiTableInfoPolicy);
        this.tableHandle.setTable(mWTable);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.primaryKeysHaveSameName = true;
        this.tableHandle = new MWTableHandle(this, this.buildTableScrubber());
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
    }

    private MWDescriptorMultiTableInfoPolicy getPolicy() {
        return (MWDescriptorMultiTableInfoPolicy)this.getParent();
    }

    public MWTable getTable() {
        return this.tableHandle.getTable();
    }

    public boolean primaryKeysHaveSameName() {
        return this.primaryKeysHaveSameName;
    }

    public void setPrimaryKeysHaveSameName(boolean bl) {
        boolean bl2 = this.primaryKeysHaveSameName;
        this.primaryKeysHaveSameName = bl;
        this.firePropertyChanged(PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY, bl2, bl);
        if (bl2 != bl && bl) {
            this.setReference(null);
        }
    }

    public MWReference getReference() {
        if (this.primaryKeysHaveSameName) {
            throw new IllegalStateException("This secondary table association is based on primary keys");
        }
        return this.referenceHandle.getReference();
    }

    public void setReference(MWReference mWReference) {
        if (mWReference != null && this.primaryKeysHaveSameName) {
            throw new IllegalStateException("This secondary table association is based on primary keys");
        }
        MWReference mWReference2 = this.referenceHandle.getReference();
        this.referenceHandle.setReference(mWReference);
        this.firePropertyChanged(REFERENCE_PROPERTY, mWReference2, mWReference);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.tableHandle);
        list.add(this.referenceHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWSecondaryTableHolder.this.tableRemoved();
            }

            public String toString() {
                return "MWSecondaryTableHolder.buildTableScrubber()";
            }
        };
    }

    void tableRemoved() {
        this.getPolicy().removeSecondaryTableHolder(this);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWSecondaryTableHolder.this.setReference(null);
            }

            public String toString() {
                return "MWSecondaryTableHolder.buildReferenceScrubber()";
            }
        };
    }

    public void toString(StringBuffer stringBuffer) {
        this.getTable().toString(stringBuffer);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWSecondaryTableHolder.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("tableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        xMLDescriptor.addDirectMapping(PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY, "primary-keys-have-same-name/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("referenceHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping2.setXPath("reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWTableHandle getTableHandleForTopLink() {
        return this.tableHandle.getTable() == null ? null : this.tableHandle;
    }

    private void setTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTableScrubber();
        this.tableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle mWReferenceHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReferenceScrubber();
        this.referenceHandle = mWReferenceHandle == null ? new MWReferenceHandle(this, nodeReferenceScrubber) : mWReferenceHandle.setScrubber(nodeReferenceScrubber);
    }
}

