/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTableDescriptorLockingPolicy
extends MWDescriptorLockingPolicy {
    private MWColumnHandle versionLockingColumnHandle;
    public static final String VERSION_LOCKING_COLUMN_PROPERTY = "versionLockingColumn";
    private volatile String optimisticLockingType;
    public static final String OPTIMISTIC_LOCKING_TYPE_PROPERTY = "optimisticLockingType";
    public static final String OPTIMISTIC_COLUMNS_LOCKING_TYPE = "Columns Locking";
    public static final String OPTIMISTIC_VERSION_LOCKING_TYPE = "Version Locking";
    public static final String DEFAULT_OPTIMISTIC_LOCKING_TYPE = "Version Locking";
    private volatile String optimisticColumnsLockingType;
    public static final String OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY = "optimisticColumnsLockingType";
    public static final String OPTIMISTIC_COLUMNS_ALL_COLUMNS = "All Columns";
    public static final String OPTIMISTIC_COLUMNS_CHANGED_COLUMNS = "Changed Columns";
    public static final String OPTIMISTIC_COLUMNS_SELECTED_COLUMNS = "Selected Columns";
    public static final String DEFAULT_OPTIMISTIC_COLUMNS_LOCKING_TYPE = "All Columns";
    private Collection columnLockColumnHandles;
    public static final String COLUMN_LOCK_COLUMNS_COLLECTION = "columnLockColumns";
    private MWHandle.NodeReferenceScrubber columnLockColumnScrubber;

    protected MWTableDescriptorLockingPolicy() {
    }

    public MWTableDescriptorLockingPolicy(MWRelationalTransactionalPolicy mWRelationalTransactionalPolicy) {
        super(mWRelationalTransactionalPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.versionLockingColumnHandle = new MWColumnHandle(this, this.buildVersionLockingColumnScrubber());
        this.columnLockColumnHandles = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.versionLockingColumnHandle);
        Collection collection = this.columnLockColumnHandles;
        synchronized (collection) {
            list.addAll(this.columnLockColumnHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber buildVersionLockingColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTableDescriptorLockingPolicy.this.setVersionLockingColumn(null);
            }

            public String toString() {
                return "MWTableDescriptorLockingPolicy.buildVersionLockingColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber columnLockColumnScrubber() {
        if (this.columnLockColumnScrubber == null) {
            this.columnLockColumnScrubber = this.buildColumnLockColumnScrubber();
        }
        return this.columnLockColumnScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildColumnLockColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTableDescriptorLockingPolicy.this.removeColumnLockColumnHandle((MWColumnHandle)mWHandle);
            }

            public String toString() {
                return "MWTableDescriptorLockingPolicy.buildColumnLockColumnScrubber()";
            }
        };
    }

    public MWTableDescriptor getOwningTableDescriptor() {
        return (MWTableDescriptor)this.getOwningDescriptor();
    }

    public MWColumn getVersionLockingColumn() {
        return this.versionLockingColumnHandle.getColumn();
    }

    public void setVersionLockingColumn(MWColumn mWColumn) {
        if (mWColumn != null && this.getLockingType() != "Optimistic Locking") {
            throw new IllegalStateException("LockingType must be Optimistic Locking");
        }
        MWColumn mWColumn2 = this.versionLockingColumnHandle.getColumn();
        this.versionLockingColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(VERSION_LOCKING_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public MWDataField getVersionLockField() {
        return this.getVersionLockingColumn();
    }

    public void setVersionLockField(MWDataField mWDataField) {
        this.setVersionLockingColumn((MWColumn)mWDataField);
    }

    private Iterator columnLockColumnHandles() {
        return new CloneIterator(this.columnLockColumnHandles){

            protected void remove(Object object) {
                MWTableDescriptorLockingPolicy.this.removeColumnLockColumnHandle((MWColumnHandle)object);
            }
        };
    }

    void removeColumnLockColumnHandle(MWColumnHandle mWColumnHandle) {
        this.columnLockColumnHandles.remove(mWColumnHandle);
        this.fireItemRemoved(COLUMN_LOCK_COLUMNS_COLLECTION, mWColumnHandle.getColumn());
    }

    public Iterator columnLockColumns() {
        return new TransformationIterator(this.columnLockColumnHandles()){

            protected Object transform(Object object) {
                return ((MWColumnHandle)object).getColumn();
            }
        };
    }

    public int columnLockColumnsSize() {
        return this.columnLockColumnHandles.size();
    }

    public void addColumnLockColumn(MWColumn mWColumn) {
        this.columnLockColumnHandles.add(new MWColumnHandle(this, mWColumn, this.columnLockColumnScrubber()));
        this.fireItemAdded(COLUMN_LOCK_COLUMNS_COLLECTION, mWColumn);
    }

    public void removeColumnLockColumn(MWColumn mWColumn) {
        Iterator iterator = this.columnLockColumns();
        while (iterator.hasNext()) {
            if (iterator.next() != mWColumn) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWColumn.toString());
    }

    private void clearColumnLockColumns() {
        Iterator iterator = this.columnLockColumnHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public Iterator columnLockColumnsNames() {
        return new TransformationIterator(this.columnLockColumns()){

            protected Object transform(Object object) {
                return ((MWColumn)object).qualifiedName();
            }
        };
    }

    public void setLockingType(String string) {
        String string2 = this.getLockingType();
        super.setLockingType(string);
        if (this.attributeValueHasChanged(string, string2)) {
            if (string != "Optimistic Locking") {
                this.setOptimisticLockingType(null);
            } else {
                this.setOptimisticLockingType("Version Locking");
            }
        }
    }

    public String getOptimisticColumnsLockingType() {
        return this.optimisticColumnsLockingType;
    }

    public void setOptimisticColumnsLockingType(String string) {
        String string2 = this.optimisticColumnsLockingType;
        this.optimisticColumnsLockingType = string;
        this.firePropertyChanged(OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY, string2, this.optimisticColumnsLockingType);
        if (this.attributeValueHasChanged(string2, this.optimisticColumnsLockingType) && this.optimisticColumnsLockingType != OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            this.clearColumnLockColumns();
        }
    }

    public String getOptimisticLockingType() {
        return this.optimisticLockingType;
    }

    public void setOptimisticLockingType(String string) {
        String string2 = this.optimisticLockingType;
        this.optimisticLockingType = string;
        this.firePropertyChanged(OPTIMISTIC_LOCKING_TYPE_PROPERTY, string2, this.optimisticLockingType);
        if (this.attributeValueHasChanged(string2, this.optimisticLockingType)) {
            if (this.optimisticLockingType == "Version Locking") {
                this.setOptimisticColumnsLockingType(null);
                this.setOptimisticVersionLockingType("Version Locking");
                this.clearColumnLockColumns();
            } else if (this.optimisticLockingType == null) {
                this.setOptimisticColumnsLockingType(null);
                this.setOptimisticVersionLockingType(null);
                this.setVersionLockField(null);
                this.clearColumnLockColumns();
            } else {
                this.setOptimisticColumnsLockingType("All Columns");
                this.setVersionLockField(null);
                this.setOptimisticVersionLockingType(null);
            }
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.selectedColumnsLockingNotMapped(list);
        this.selectedColumnsLockingContainsPrimaryKey(list);
    }

    protected void checkWriteLockFieldWritable(List list) {
        if (this.getOptimisticLockingType() == "Version Locking") {
            super.checkWriteLockFieldWritable(list);
        }
    }

    private void selectedColumnsLockingNotMapped(List list) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE && this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Iterator iterator = this.columnLockColumns();
            while (iterator.hasNext()) {
                MWColumn mWColumn = (MWColumn)iterator.next();
                if (!CollectionTools.contains(this.getOwningTableDescriptor().allAssociatedColumns(), (Object)mWColumn)) {
                    arrayList2.add(mWColumn.getName());
                }
                if (this.getOwningTableDescriptor().allWritableMappingsForField(mWColumn).size() != 0) continue;
                arrayList.add(mWColumn.getName());
            }
            if (arrayList.size() > 0) {
                list.add(this.buildProblem("0306", arrayList));
            }
            if (arrayList2.size() > 0) {
                list.add(this.buildProblem("0310", arrayList2));
            }
        }
    }

    protected void checkLockFieldSpecifiedForLockingPolicy(List list) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == "Version Locking") {
            if (this.getVersionLockField() == null) {
                list.add(this.buildProblem("0308"));
            } else if (!CollectionTools.contains(this.getOwningTableDescriptor().allAssociatedColumns(), (Object)this.getVersionLockField())) {
                list.add(this.buildProblem("0309"));
            }
        }
    }

    private void selectedColumnsLockingContainsPrimaryKey(List list) {
        if (this.getLockingType() == "Optimistic Locking" && this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE && this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_SELECTED_COLUMNS) {
            Collection collection = CollectionTools.collection(this.getOwningTableDescriptor().primaryKeys());
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.columnLockColumns();
            while (iterator.hasNext()) {
                MWColumn mWColumn = (MWColumn)iterator.next();
                if (!collection.contains(mWColumn)) continue;
                arrayList.add(mWColumn.getName());
            }
            if (arrayList.size() > 0) {
                list.add(this.buildProblem("0307", arrayList));
            }
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        super.adjustRuntimeDescriptor(classDescriptor);
        if (this.getLockingType() == "Optimistic Locking") {
            if (this.getOptimisticLockingType() == "Version Locking") {
                VersionLockingPolicy versionLockingPolicy;
                if (this.getOptimisticVersionLockingType() == "Version Locking") {
                    versionLockingPolicy = new VersionLockingPolicy();
                } else {
                    versionLockingPolicy = new TimestampLockingPolicy();
                    if (this.usesLocalTime()) {
                        ((TimestampLockingPolicy)versionLockingPolicy).useLocalTime();
                    } else {
                        ((TimestampLockingPolicy)versionLockingPolicy).useServerTime();
                    }
                }
                if (this.getVersionLockField() != null) {
                    versionLockingPolicy.setWriteLockFieldName(this.getVersionLockField().runtimeField().getQualifiedName());
                }
                versionLockingPolicy.setIsStoredInCache(this.shouldStoreVersionInCache());
                classDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)versionLockingPolicy);
            } else if (this.getOptimisticLockingType() == OPTIMISTIC_COLUMNS_LOCKING_TYPE) {
                AllFieldsLockingPolicy allFieldsLockingPolicy;
                if (this.getOptimisticColumnsLockingType() == "All Columns") {
                    allFieldsLockingPolicy = new AllFieldsLockingPolicy();
                } else if (this.getOptimisticColumnsLockingType() == OPTIMISTIC_COLUMNS_CHANGED_COLUMNS) {
                    allFieldsLockingPolicy = new ChangedFieldsLockingPolicy();
                } else {
                    allFieldsLockingPolicy = new SelectedFieldsLockingPolicy();
                    ((SelectedFieldsLockingPolicy)allFieldsLockingPolicy).setLockFieldNames(CollectionTools.vector(this.columnLockColumnsNames()));
                }
                classDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)allFieldsLockingPolicy);
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWTableDescriptorLockingPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDescriptorLockingPolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("versionLockingColumnHandle");
        xMLCompositeObjectMapping.setGetMethodName("getVersionLockingColumnHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setVersionLockingColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("version-locking-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)OPTIMISTIC_COLUMNS_LOCKING_TYPE, (Object)OPTIMISTIC_COLUMNS_LOCKING_TYPE);
        objectTypeConverter.addConversionValue((Object)"Version Locking", (Object)"Version Locking");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(OPTIMISTIC_LOCKING_TYPE_PROPERTY);
        xMLDirectMapping.setXPath("optimistic-locking-type/text()");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        objectTypeConverter2.addConversionValue((Object)"All Columns", (Object)"All Columns");
        objectTypeConverter2.addConversionValue((Object)OPTIMISTIC_COLUMNS_CHANGED_COLUMNS, (Object)OPTIMISTIC_COLUMNS_CHANGED_COLUMNS);
        objectTypeConverter2.addConversionValue((Object)OPTIMISTIC_COLUMNS_SELECTED_COLUMNS, (Object)OPTIMISTIC_COLUMNS_SELECTED_COLUMNS);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(OPTIMISTIC_COLUMNS_LOCKING_TYPE_PROPERTY);
        xMLDirectMapping2.setXPath("optimistic-columns-locking-type/text()");
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter2);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("columnLockColumnHandles");
        xMLCompositeCollectionMapping.setGetMethodName("getColumnLockColumnHandlesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setColumnLockColumnHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeCollectionMapping.setXPath("column-lock-column-handles/column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private MWColumnHandle getVersionLockingColumnHandleForTopLink() {
        return this.versionLockingColumnHandle.getColumn() == null ? null : this.versionLockingColumnHandle;
    }

    private void setVersionLockingColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildVersionLockingColumnScrubber();
        this.versionLockingColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getColumnLockColumnHandlesForTopLink() {
        Collection collection = this.columnLockColumnHandles;
        synchronized (collection) {
            return new TreeSet(this.columnLockColumnHandles);
        }
    }

    private void setColumnLockColumnHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWColumnHandle)iterator.next()).setScrubber(this.columnLockColumnScrubber());
        }
        this.columnLockColumnHandles = collection;
    }
}

