/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWUserDefinedQueryKey
extends MWModel
implements MWQueryKey,
MWQueryable,
AggregateRuntimeFieldNameGenerator {
    private volatile String name;
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";

    private MWUserDefinedQueryKey() {
    }

    MWUserDefinedQueryKey(String string, MWRelationalClassDescriptor mWRelationalClassDescriptor, MWColumn mWColumn) {
        this(string, mWRelationalClassDescriptor);
        this.columnHandle.setColumn(mWColumn);
    }

    MWUserDefinedQueryKey(String string, MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        super(mWRelationalClassDescriptor);
        this.initialize(string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    private void initialize(String string) {
        this.checkName(string);
        this.name = string;
    }

    protected void checkName(String string) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("MWUserDefinedQueryKey name cannot be null");
        }
        this.getDescriptor().checkQueryKeyName(string);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWUserDefinedQueryKey.this.setColumn(null);
            }

            public String toString() {
                return "MWUserDefinedQueryKey.buildColumnScrubber()";
            }
        };
    }

    public boolean allowsChildren() {
        return false;
    }

    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    public MWMappingDescriptor getParentDescriptor() {
        return this.getDescriptor();
    }

    public List subQueryableElements(Filter filter) {
        return Collections.EMPTY_LIST;
    }

    public MWQueryable subQueryableElementAt(int n, Filter filter) {
        return null;
    }

    public boolean isLeaf(Filter filter) {
        return true;
    }

    public String iconKey() {
        return "queryKey.userDefined";
    }

    public boolean usesAnyOf() {
        return false;
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    public boolean isValidForReadAllQueryOrderable() {
        return true;
    }

    public boolean isTraversableForBatchReadAttribute() {
        return false;
    }

    public boolean isValidForBatchReadAttribute() {
        return false;
    }

    public boolean isTraversableForJoinedAttribute() {
        return false;
    }

    public boolean isValidForJoinedAttribute() {
        return false;
    }

    public boolean isValidForReportQueryAttribute() {
        return true;
    }

    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.checkName(string);
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged("name", string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public MWRelationalClassDescriptor getDescriptor() {
        return (MWRelationalClassDescriptor)this.getParent();
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.columnHandle.getColumn();
        this.columnHandle.setColumn(mWColumn);
        this.firePropertyChanged(COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public String fieldNameForRuntime() {
        return "QUERY_KEY " + this.getName();
    }

    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_USER_DEFINED_QUERY_KEY";
            }

            public Object[] getMessageArguments() {
                return new Object[]{MWUserDefinedQueryKey.this.getName()};
            }
        };
    }

    public boolean fieldIsWritten() {
        return false;
    }

    public MWDescriptor owningDescriptor() {
        return (MWDescriptor)this.getParent();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkColumns(list);
    }

    private void checkColumns(List list) {
        if (((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor()) {
            return;
        }
        if (this.getColumn() == null) {
            list.add(this.buildProblem("0246", this.getName()));
        } else if (!CollectionTools.contains(((MWTableDescriptor)this.getParentDescriptor()).allAssociatedColumns(), (Object)this.getColumn())) {
            list.add(this.buildProblem("0247", this.getName()));
        }
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("field=");
        if (this.getColumn() == null) {
            stringBuffer.append("null");
        } else {
            this.getColumn().toString(stringBuffer);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWUserDefinedQueryKey.class);
        xMLDescriptor.addDirectMapping("name", "name/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("columnHandle");
        xMLCompositeObjectMapping.setGetMethodName("getColumnHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildColumnScrubber();
        this.columnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }
}

