/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisDescriptorLockingPolicy
extends MWDescriptorLockingPolicy
implements MWXmlNode,
MWXpathContext {
    private MWXmlField versionXmlField;

    private MWEisDescriptorLockingPolicy() {
    }

    MWEisDescriptorLockingPolicy(MWEisTransactionalPolicy mWEisTransactionalPolicy) {
        super(mWEisTransactionalPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.versionXmlField = new MWXmlField(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.versionXmlField);
    }

    public MWDataField getVersionLockField() {
        return this.versionXmlField;
    }

    public void setVersionLockField(MWDataField mWDataField) {
        throw new UnsupportedOperationException("the xml field itself should be modified");
    }

    public MWSchemaContextComponent schemaContext(MWXmlField mWXmlField) {
        return this.eisDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField mWXmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return false;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    private MWRootEisDescriptor eisDescriptor() {
        return (MWRootEisDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    protected void checkLockFieldSpecifiedForLockingPolicy(List list) {
        if (this.getLockingType() != "None" && this.getVersionLockField() == null) {
            list.add(this.buildProblem("0308"));
        }
    }

    public void resolveXpaths() {
        this.versionXmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange schemaChange) {
        this.versionXmlField.schemaChanged(schemaChange);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        super.adjustRuntimeDescriptor(classDescriptor);
        if (this.getLockingType() == "Optimistic Locking") {
            VersionLockingPolicy versionLockingPolicy;
            if (this.getOptimisticVersionLockingType() == "Version Locking") {
                versionLockingPolicy = new VersionLockingPolicy();
            } else {
                versionLockingPolicy = new TimestampLockingPolicy();
                if (this.usesLocalTime()) {
                    ((TimestampLockingPolicy)versionLockingPolicy).useLocalTime();
                } else {
                    ((TimestampLockingPolicy)versionLockingPolicy).useServerTime();
                }
            }
            if (this.getVersionLockField() != null && this.getVersionLockField().runtimeField() != null) {
                versionLockingPolicy.setWriteLockFieldName(this.getVersionLockField().runtimeField().getQualifiedName());
            }
            versionLockingPolicy.setIsStoredInCache(this.shouldStoreVersionInCache());
            classDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)versionLockingPolicy);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWEisDescriptorLockingPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDescriptorLockingPolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setReferenceClass(MWXmlField.class);
        xMLCompositeObjectMapping.setAttributeName("versionXmlField");
        xMLCompositeObjectMapping.setGetMethodName("getVersionXmlFieldForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setVersionXmlFieldForTopLink");
        xMLCompositeObjectMapping.setXPath("version-xml-field");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWXmlField getVersionXmlFieldForTopLink() {
        return this.versionXmlField.isSpecified() ? this.versionXmlField : null;
    }

    private void setVersionXmlFieldForTopLink(MWXmlField mWXmlField) {
        this.versionXmlField = mWXmlField == null ? new MWXmlField(this) : mWXmlField;
    }
}

