/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlClassIndicatorFieldPolicy
extends MWClassIndicatorFieldPolicy
implements MWXpathContext {
    private MWXmlField xmlField;
    private volatile boolean useXSIType;
    public static String USE_XSITYPE_PROPERTY = "useXSIType";

    private MWXmlClassIndicatorFieldPolicy() {
    }

    protected MWXmlClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    protected MWXmlClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator iterator) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(iterator);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.xmlField = new MWXmlField(this);
        this.useXSIType = false;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.xmlField);
    }

    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    public MWDataField getField() {
        return this.getXmlField();
    }

    public boolean isUseXSIType() {
        return this.useXSIType;
    }

    public void setUseXSIType(boolean bl) {
        boolean bl2 = this.useXSIType;
        this.useXSIType = bl;
        this.firePropertyChanged(USE_XSITYPE_PROPERTY, bl2, bl);
        if (bl) {
            this.setClassNameIsIndicator(false);
            this.generateIndicatorValueValues();
        }
    }

    private void generateIndicatorValueValues() {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            MWXmlDescriptor mWXmlDescriptor = (MWXmlDescriptor)mWClassIndicatorValue.getDescriptorValue();
            if (mWXmlDescriptor.getSchemaContext() == null) continue;
            String string = mWXmlDescriptor.getSchemaContext().contextTypeQname();
            mWClassIndicatorValue.setIndicatorValue(string);
        }
    }

    private void clearIndicatorValuesValues() {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            mWClassIndicatorValue.setIndicatorValue(null);
        }
    }

    public MWSchemaContextComponent schemaContext(MWXmlField mWXmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField mWXmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return false;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    private MWClassIndicatorPolicy.Parent classIndicatorFieldPolicyParent() {
        return (MWClassIndicatorPolicy.Parent)this.getParent();
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.classIndicatorFieldPolicyParent().getContainingDescriptor();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkClassIndicatorField(list);
    }

    protected boolean fieldSpecified() {
        if (!this.isUseXSIType()) {
            return this.getXmlField().isResolved();
        }
        return true;
    }

    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange schemaChange) {
        this.xmlField.schemaChanged(schemaChange);
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy inheritancePolicy) {
        super.adjustRuntimeInheritancePolicy(inheritancePolicy);
        if (this.useXSIType) {
            inheritancePolicy.setClassIndicatorField((DatabaseField)new XMLField("@xsi:type"));
        } else {
            inheritancePolicy.setClassIndicatorFieldName(this.getXmlField().getXpath());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlClassIndicatorFieldPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWClassIndicatorFieldPolicy.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("useXSIType", "@use-xsitype");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setReferenceClass(MWXmlField.class);
        xMLCompositeObjectMapping.setAttributeName("xmlField");
        xMLCompositeObjectMapping.setGetMethodName("getXmlFieldForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setXmlFieldForTopLink");
        xMLCompositeObjectMapping.setXPath("xml-field");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField mWXmlField) {
        this.xmlField = mWXmlField == null ? new MWXmlField(this) : mWXmlField;
    }
}

