/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWNamedSchemaComponentHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWXmlDescriptor
extends MWMappingDescriptor
implements MWXmlNode {
    private MWNamedSchemaComponentHandle schemaContextHandle;
    public static final String SCHEMA_CONTEXT_PROPERTY = "schemaContext";
    private MWNamedSchemaComponentHandle defaultRootElementHandle;
    public static final String DEFAULT_ROOT_ELEMENT_PROPERTY = "defaultRootElement";

    protected MWXmlDescriptor() {
    }

    public MWXmlDescriptor(MWXmlProject mWXmlProject, MWClass mWClass, String string) {
        super(mWXmlProject, mWClass, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.schemaContextHandle = new MWNamedSchemaComponentHandle(this, this.buildSchemaContextScrubber());
        this.defaultRootElementHandle = new MWNamedSchemaComponentHandle(this, this.buildDefaultRootElementScrubber());
    }

    protected void initializeFromMWXmlDescriptor(MWXmlDescriptor mWXmlDescriptor) {
        super.initializeFromMWMappingDescriptor(mWXmlDescriptor);
        this.setSchemaContext(mWXmlDescriptor.getSchemaContext());
        this.setDefaultRootElement(mWXmlDescriptor.getDefaultRootElement());
    }

    public MWSchemaContextComponent getSchemaContext() {
        return (MWSchemaContextComponent)this.schemaContextHandle.getComponent();
    }

    public void setSchemaContext(MWSchemaContextComponent mWSchemaContextComponent) {
        MWSchemaContextComponent mWSchemaContextComponent2 = this.getSchemaContext();
        this.schemaContextHandle.setComponent(mWSchemaContextComponent);
        this.firePropertyChanged(SCHEMA_CONTEXT_PROPERTY, mWSchemaContextComponent2, mWSchemaContextComponent);
        this.setInitialDefaultRootElement();
        this.resolveXpaths();
    }

    public abstract boolean isRootDescriptor();

    public abstract boolean isEisDescriptor();

    public MWElementDeclaration getDefaultRootElement() {
        return (MWElementDeclaration)this.defaultRootElementHandle.getComponent();
    }

    public void setDefaultRootElement(MWElementDeclaration mWElementDeclaration) {
        MWElementDeclaration mWElementDeclaration2 = this.getDefaultRootElement();
        this.defaultRootElementHandle.setComponent(mWElementDeclaration);
        this.firePropertyChanged(DEFAULT_ROOT_ELEMENT_PROPERTY, mWElementDeclaration2, mWElementDeclaration);
    }

    protected void setInitialDefaultRootElement() {
        if (this.getSchemaContext() instanceof MWElementDeclaration) {
            this.setDefaultRootElement((MWElementDeclaration)this.getSchemaContext());
        }
    }

    public abstract MWMappingFactory mappingFactory();

    public MWCompositeObjectMapping addCompositeObjectMapping(MWClassAttribute mWClassAttribute) {
        MWCompositeObjectMapping mWCompositeObjectMapping = ((MWXmlMappingFactory)this.mappingFactory()).createCompositeObjectMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWCompositeObjectMapping);
        return mWCompositeObjectMapping;
    }

    public MWCompositeCollectionMapping addCompositeCollectionMapping(MWClassAttribute mWClassAttribute) {
        MWCompositeCollectionMapping mWCompositeCollectionMapping = ((MWXmlMappingFactory)this.mappingFactory()).createCompositeCollectionMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWCompositeCollectionMapping);
        return mWCompositeCollectionMapping;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.schemaContextHandle);
        list.add(this.defaultRootElementHandle);
    }

    private MWHandle.NodeReferenceScrubber buildSchemaContextScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWXmlDescriptor.this.setSchemaContext(null);
            }

            public String toString() {
                return "MWXmlDescriptor.buildSchemaContextScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildDefaultRootElementScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWXmlDescriptor.this.setDefaultRootElement(null);
            }

            public String toString() {
                return "MWXmlDescriptor.buildDefaultRootElementtScrubber()";
            }
        };
    }

    protected void refreshClass(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(mWClassRefreshPolicy);
        if (this.getMWClass().isInterface()) {
            throw new InterfaceDescriptorCreationException(this.getMWClass());
        }
    }

    public void resolveXpaths() {
        ((MWXmlNode)((Object)this.getInheritancePolicy())).resolveXpaths();
        ((MWXmlNode)((Object)this.getLockingPolicy())).resolveXpaths();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).resolveXpaths();
        }
    }

    public void schemaChanged(SchemaChange schemaChange) {
        if (this.getSchemaContext() == null || this.getSchemaContext().getSchema() != schemaChange.getSchema()) {
            return;
        }
        ((MWXmlNode)((Object)this.getInheritancePolicy())).schemaChanged(schemaChange);
        ((MWXmlNode)((Object)this.getLockingPolicy())).schemaChanged(schemaChange);
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).schemaChanged(schemaChange);
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.addSchemaContextNotSpecifiedProblemTo(list);
        this.addDefaultRootElementNotSpecifiedProblemTo(list);
    }

    private void addSchemaContextNotSpecifiedProblemTo(List list) {
        if (this.schemaContextIsRequired() && this.getSchemaContext() == null) {
            list.add(this.buildProblem("0270"));
        }
    }

    public Collection allWritableMappingsForField(MWDataField mWDataField) {
        Object object;
        ArrayList<MWMapping> arrayList = new ArrayList<MWMapping>();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (mWMapping.isReadOnly()) continue;
            object = new ArrayList();
            mWMapping.addWrittenFieldsTo((Collection)object);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                MWXmlField mWXmlField = (MWXmlField)iterator2.next();
                if (!mWXmlField.getXpath().equals(((MWXmlField)mWDataField).getXpath())) continue;
                arrayList.add(mWMapping);
            }
        }
        if (!this.writableMappingsForField(mWDataField).isEmpty() && !this.getInheritancePolicy().isRoot() && this.getInheritancePolicy().getParentDescriptor() != null) {
            for (MWMapping mWMapping : this.getInheritancePolicy().getParentDescriptor().writableMappingsForField(mWDataField)) {
                object = this.mappingNamed(mWMapping.getName());
                if (object != null) continue;
                arrayList.add(mWMapping);
            }
        }
        return arrayList;
    }

    public Collection writableMappingsForField(MWDataField mWDataField) {
        ArrayList<MWMapping> arrayList = new ArrayList<MWMapping>();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            ArrayList arrayList2 = new ArrayList();
            mWMapping.addWrittenFieldsTo(arrayList2);
            for (MWXmlField mWXmlField : arrayList2) {
                if (!mWXmlField.getXpath().equals(((MWXmlField)mWDataField).getXpath())) continue;
                arrayList.add(mWMapping);
            }
        }
        return arrayList;
    }

    protected boolean schemaContextIsRequired() {
        return true;
    }

    private void addDefaultRootElementNotSpecifiedProblemTo(List list) {
        if (this.isRootDescriptor() && this.getDefaultRootElement() == null) {
            list.add(this.buildProblem("0271"));
        }
    }

    protected String multipleMappingsWriteFieldProblemResourceStringKey() {
        return "0272";
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor classDescriptor = super.buildRuntimeDescriptor();
        this.adjustRuntimeDescriptorRootProperties(classDescriptor);
        return classDescriptor;
    }

    protected void adjustRuntimeDescriptorRootProperties(ClassDescriptor classDescriptor) {
        if (!this.isRootDescriptor()) {
            classDescriptor.descriptorIsAggregate();
        }
    }

    protected Comparator orderedMappingComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                MWXmlField mWXmlField = ((MWXmlMapping)object).firstMappedXmlField();
                MWXmlField mWXmlField2 = ((MWXmlMapping)object2).firstMappedXmlField();
                return MWXmlField.compareSchemaOrder(mWXmlField, mWXmlField2);
            }
        };
    }

    protected XMLSchemaReference runtimeSchemaReference() {
        MWSchemaContextComponent mWSchemaContextComponent = this.getSchemaContext();
        if (mWSchemaContextComponent != null) {
            XMLSchemaReference xMLSchemaReference = mWSchemaContextComponent.getSchema().runtimeSchemaReference();
            String string = "";
            Iterator iterator = mWSchemaContextComponent.namedComponentChain();
            while (iterator.hasNext()) {
                string = "/" + ((MWNamedSchemaComponent)iterator.next()).qName() + string;
            }
            xMLSchemaReference.setSchemaContext(string);
            if (mWSchemaContextComponent instanceof MWComplexTypeDefinition) {
                xMLSchemaReference.setType(1);
            } else if (mWSchemaContextComponent instanceof MWSimpleTypeDefinition) {
                xMLSchemaReference.setType(2);
            } else if (mWSchemaContextComponent instanceof MWElementDeclaration) {
                xMLSchemaReference.setType(3);
            } else if (mWSchemaContextComponent instanceof MWModelGroupDefinition) {
                xMLSchemaReference.setType(5);
            }
            return xMLSchemaReference;
        }
        return null;
    }

    protected NamespaceResolver runtimeNamespaceResolver() {
        if (this.getSchemaContext() != null) {
            return this.getSchemaContext().getSchema().runtimeNamespaceResolver();
        }
        return null;
    }

    public abstract AbstractDirectMapping buildDefaultRuntimeDirectMapping();

    public abstract AbstractCompositeDirectCollectionMapping buildDefaultRuntimeDirectCollectionMapping();

    public abstract AbstractCompositeObjectMapping buildDefaultRuntimeCompositeObjectMapping();

    public abstract AbstractCompositeCollectionMapping buildDefaultRuntimeCompositeCollectionMapping();

    public abstract AbstractTransformationMapping buildDefaultRuntimeTransformationMapping();

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlDescriptor.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWMappingDescriptor.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("schemaContextHandle");
        xMLCompositeObjectMapping.setGetMethodName("getSchemaContextHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setSchemaContextHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWNamedSchemaComponentHandle.class);
        xMLCompositeObjectMapping.setXPath("schema-context-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("defaultRootElementHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getDefaultRootElementHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setDefaultRootElementHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWNamedSchemaComponentHandle.class);
        xMLCompositeObjectMapping2.setXPath("default-root-element-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWNamedSchemaComponentHandle getSchemaContextHandleForTopLink() {
        return this.schemaContextHandle.getComponent() == null ? null : this.schemaContextHandle;
    }

    private void setSchemaContextHandleForTopLink(MWNamedSchemaComponentHandle mWNamedSchemaComponentHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSchemaContextScrubber();
        this.schemaContextHandle = mWNamedSchemaComponentHandle == null ? new MWNamedSchemaComponentHandle(this, nodeReferenceScrubber) : mWNamedSchemaComponentHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWNamedSchemaComponentHandle getDefaultRootElementHandleForTopLink() {
        return this.defaultRootElementHandle.getComponent() == null ? null : this.defaultRootElementHandle;
    }

    private void setDefaultRootElementHandleForTopLink(MWNamedSchemaComponentHandle mWNamedSchemaComponentHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildDefaultRootElementScrubber();
        this.defaultRootElementHandle = mWNamedSchemaComponentHandle == null ? new MWNamedSchemaComponentHandle(this, nodeReferenceScrubber) : mWNamedSchemaComponentHandle.setScrubber(nodeReferenceScrubber);
    }

    public abstract MWXmlPrimaryKeyPolicy primaryKeyPolicy();
}

