/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.generation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTypeNames;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToFieldMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class MWDescriptorGenerator
implements MWTypeNames {
    private volatile MWRelationalProject project;
    private Collection tables;
    private volatile String packageName;
    private volatile boolean generateBidirectionalRelationships;
    private volatile boolean generateEjbs;
    private volatile boolean generateLocalInterfaces;
    private volatile boolean generateRemoteInterfaces;
    private volatile boolean generateMethodAccessors;
    private Collection relationshipsToCreate = new Vector();
    private Map tableToDescriptorDictionary = new HashMap();
    private Map relationshipToMappingDictionary = new HashMap();

    private String defaultInstanceVariableName(MWRelationshipHolder mWRelationshipHolder, MWClass mWClass, String string) {
        if (!mWRelationshipHolder.isForeignKeyInTargetTable() && mWRelationshipHolder.getReference().columnPairsSize() == 1) {
            String string2 = ((MWColumnPair)mWRelationshipHolder.getReference().columnPairs().next()).getSourceColumn().getName();
            if ((string2 = string2.replace(' ', '_')).toUpperCase().endsWith("_ID")) {
                string2 = string2.substring(0, string2.length() - 3);
            }
            return StringTools.convertAllCapsToCamelBack(string2, false);
        }
        return StringTools.uncapitalize(string);
    }

    private void ensureBackPointersIncluded() {
        Vector<MWRelationshipHolder> vector = new Vector<MWRelationshipHolder>();
        for (MWRelationshipHolder mWRelationshipHolder : this.relationshipsToCreate) {
            boolean bl;
            MWReference mWReference;
            if (!mWRelationshipHolder.isOneToMany() || this.getRelationshipToCreate(mWReference = mWRelationshipHolder.getReference(), bl = false) != null) continue;
            MWRelationshipHolder mWRelationshipHolder2 = new MWRelationshipHolder(mWReference, bl);
            mWRelationshipHolder2.setOneToOne();
            vector.add(mWRelationshipHolder2);
        }
        this.relationshipsToCreate.addAll(vector);
    }

    private void ensureSpecCompliance() {
        for (MWDescriptor mWDescriptor : this.tableToDescriptorDictionary.values()) {
        }
    }

    private void generateBidirectionalRelationships() {
        for (MWRelationshipHolder mWRelationshipHolder : this.relationshipsToCreate) {
            MWRelationshipHolder mWRelationshipHolder2 = this.getRelationshipToCreate(mWRelationshipHolder.getReference(), !mWRelationshipHolder.isForeignKeyInTargetTable());
            MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping = (MWAbstractTableReferenceMapping)this.relationshipToMappingDictionary.get(mWRelationshipHolder);
            MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping2 = (MWAbstractTableReferenceMapping)this.relationshipToMappingDictionary.get(mWRelationshipHolder2);
            if (mWAbstractTableReferenceMapping2 == null) continue;
            mWAbstractTableReferenceMapping.setMaintainsBidirectionalRelationship(true);
            mWAbstractTableReferenceMapping.setRelationshipPartnerMapping(mWAbstractTableReferenceMapping2);
            mWAbstractTableReferenceMapping2.setMaintainsBidirectionalRelationship(true);
            mWAbstractTableReferenceMapping2.setRelationshipPartnerMapping(mWAbstractTableReferenceMapping);
        }
    }

    public void generateClassesAndDescriptors() {
        this.ensureBackPointersIncluded();
        for (MWTable mWTable : this.tables) {
            MWTableDescriptor mWTableDescriptor;
            String string = mWTable.getShortName();
            string = string.replace(' ', '_');
            string = StringTools.convertAllCapsToCamelBack(string);
            String string2 = ClassTools.shortNameForClassNamed(string);
            if (this.packageName != null && this.packageName.length() != 0) {
                string = this.packageName + '.' + string;
            }
            if (this.getProject().getRepository().typeNamedIgnoreCase(string) != null) {
                string = this.generateUniqueCaseInsensitiveName(string);
            }
            if (this.generateEjbs) {
                string = string + "EJB";
            }
            MWClass mWClass = this.getProject().typeNamed(string);
            mWClass.clear();
            MWDescriptor mWDescriptor = this.getProject().descriptorForType(mWClass);
            if (mWDescriptor != null) {
                this.getProject().removeDescriptor(mWDescriptor);
            }
            mWClass.addZeroArgumentConstructor();
            try {
                mWTableDescriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(mWClass);
            }
            catch (InterfaceDescriptorCreationException interfaceDescriptorCreationException) {
                throw new RuntimeException(interfaceDescriptorCreationException);
            }
            mWTableDescriptor.setPrimaryTable(mWTable);
            this.tableToDescriptorDictionary.put(mWTable, mWTableDescriptor);
        }
        this.generateInstanceVariablesAndMappings();
        this.ensureSpecCompliance();
    }

    private void generateDirectMapping(MWTableDescriptor mWTableDescriptor, MWColumn mWColumn) {
        Collection collection = mWTableDescriptor.allWritableMappingsForField(mWColumn);
        if (!collection.isEmpty() && !mWColumn.isPrimaryKey()) {
            return;
        }
        MWClassAttribute mWClassAttribute = this.generateInstanceVariable(mWTableDescriptor, mWColumn);
        if (mWColumn.isPrimaryKey() && !CollectionTools.contains(((MWRelationalTransactionalPolicy)mWTableDescriptor.getTransactionalPolicy()).getPrimaryKeyPolicy().primaryKeys(), (Object)mWColumn)) {
            ((MWRelationalTransactionalPolicy)mWTableDescriptor.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(mWColumn);
        }
        MWDirectToFieldMapping mWDirectToFieldMapping = (MWDirectToFieldMapping)mWTableDescriptor.addDirectMapping(mWClassAttribute);
        mWDirectToFieldMapping.setColumn(mWColumn);
    }

    private void generateDirectMappings() {
        for (MWTable mWTable : this.tableToDescriptorDictionary.keySet()) {
            MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)this.tableToDescriptorDictionary.get(mWTable);
            Iterator iterator = mWTable.columns();
            while (iterator.hasNext()) {
                this.generateDirectMapping(mWTableDescriptor, (MWColumn)iterator.next());
            }
        }
    }

    private MWClassAttribute generateInstanceVariable(MWTableDescriptor mWTableDescriptor, String string, MWClass mWClass) {
        return this.retrieveOrGenerateInstanceVariable(mWTableDescriptor, string, mWClass, 0);
    }

    private MWClassAttribute retrieveOrGenerateInstanceVariable(MWTableDescriptor mWTableDescriptor, String string, MWClass mWClass, int n) {
        MWClassAttribute mWClassAttribute = this.retrieveAttribute(mWTableDescriptor, string, mWClass, n);
        if (mWClassAttribute == null) {
            mWClassAttribute = mWTableDescriptor.getMWClass().addAttribute(string, mWClass, n);
        }
        mWClassAttribute.getModifier().setPrivate(true);
        return mWClassAttribute;
    }

    private MWClassAttribute retrieveEjb20Attribute(MWTableDescriptor mWTableDescriptor, String string, MWClass mWClass, int n) {
        MWClassAttribute mWClassAttribute = mWTableDescriptor.getMWClass().attributeNamedFromCombinedAll(string);
        if (mWClassAttribute != null && mWTableDescriptor.mappingForAttribute(mWClassAttribute) == null) {
            mWClassAttribute.setType(mWClass);
            mWClassAttribute.setDimensionality(n);
            mWClassAttribute.getModifier().setPrivate(true);
            mWClassAttribute.setEjb20Attribute(true);
        }
        return mWClassAttribute;
    }

    private MWClassAttribute retrieveAttribute(MWTableDescriptor mWTableDescriptor, String string, MWClass mWClass, int n) {
        MWClassAttribute mWClassAttribute = mWTableDescriptor.getMWClass().attributeNamedFromAll(string);
        if (mWClassAttribute != null && mWTableDescriptor.mappingForAttribute(mWClassAttribute) == null) {
            mWClassAttribute.setType(mWClass);
            mWClassAttribute.setDimensionality(n);
            mWClassAttribute.getModifier().setPrivate(true);
        }
        return mWClassAttribute;
    }

    private MWClassAttribute generateInstanceVariable(MWTableDescriptor mWTableDescriptor, MWColumn mWColumn) {
        String string = mWColumn.getName().replace(' ', '_');
        string = StringTools.convertAllCapsToCamelBack(string, false);
        string = NameTools.uniqueJavaNameFor(string, mWTableDescriptor.getMWClass().attributeNames());
        MWClass mWClass = this.project.typeNamed(mWColumn.javaTypeDeclaration().getJavaClassName());
        int n = mWColumn.javaTypeDeclaration().getArrayDepth();
        MWClassAttribute mWClassAttribute = this.retrieveOrGenerateInstanceVariable(mWTableDescriptor, string, mWClass, n);
        if (this.generateMethodAccessors) {
            mWClassAttribute.generateAllAccessors();
        }
        return mWClassAttribute;
    }

    private void generateInstanceVariablesAndMappings() {
        this.generateRelationshipMappings();
        this.generateDirectMappings();
    }

    private MWOneToManyMapping generateOneToManyMapping(MWTableDescriptor mWTableDescriptor, MWClassAttribute mWClassAttribute) {
        MWOneToManyMapping mWOneToManyMapping = mWTableDescriptor.addOneToManyMapping(mWClassAttribute);
        mWOneToManyMapping.setUseTransparentIndirection();
        return mWOneToManyMapping;
    }

    private MWOneToOneMapping generateOneToOneMapping(MWTableDescriptor mWTableDescriptor, MWClassAttribute mWClassAttribute) {
        MWOneToOneMapping mWOneToOneMapping = mWTableDescriptor.addOneToOneMapping(mWClassAttribute);
        mWOneToOneMapping.setUseValueHolderIndirection();
        return mWOneToOneMapping;
    }

    private void generateReferenceMapping(MWRelationshipHolder mWRelationshipHolder) {
        MWTableDescriptor mWTableDescriptor = this.getDescriptorForTable(mWRelationshipHolder.getRelationshipSourceTable());
        MWTableDescriptor mWTableDescriptor2 = this.getDescriptorForTable(mWRelationshipHolder.getRelationshipTargetTable());
        MWClassAttribute mWClassAttribute = this.generateRelationshipInstanceVariable(mWRelationshipHolder, mWTableDescriptor, mWTableDescriptor2);
        MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping = mWRelationshipHolder.isOneToOne() ? this.generateOneToOneMapping(mWTableDescriptor, mWClassAttribute) : this.generateOneToManyMapping(mWTableDescriptor, mWClassAttribute);
        this.relationshipToMappingDictionary.put(mWRelationshipHolder, mWAbstractTableReferenceMapping);
        mWAbstractTableReferenceMapping.setReferenceDescriptor(mWTableDescriptor2);
        mWAbstractTableReferenceMapping.setReference(mWRelationshipHolder.getReference());
        if (mWRelationshipHolder.isForeignKeyInTargetTable() && mWAbstractTableReferenceMapping.isOneToOneMapping()) {
            Iterator iterator = mWRelationshipHolder.getReference().columnPairs();
            while (iterator.hasNext()) {
                ((MWOneToOneMapping)mWAbstractTableReferenceMapping).addTargetForeignKey((MWColumnPair)iterator.next());
            }
        }
    }

    private void generateRelationshipMappings() {
        for (MWRelationshipHolder mWRelationshipHolder : this.relationshipsToCreate) {
            this.generateReferenceMapping(mWRelationshipHolder);
        }
        if (this.generateBidirectionalRelationships) {
            this.generateBidirectionalRelationships();
        }
    }

    private String generateUniqueCaseInsensitiveName(String string) {
        int n = 0;
        boolean bl = true;
        String string2 = null;
        while (bl) {
            string2 = string + String.valueOf(++n);
            bl = this.getProject().getRepository().typeNamedIgnoreCase(string2) != null;
        }
        return string2;
    }

    private MWClassAttribute generateRelationshipInstanceVariable(MWRelationshipHolder mWRelationshipHolder, MWTableDescriptor mWTableDescriptor, MWTableDescriptor mWTableDescriptor2) {
        MWClassAttribute mWClassAttribute;
        MWClass mWClass = mWTableDescriptor.getMWClass();
        String string = mWTableDescriptor2.getMWClass().shortName();
        if (string.endsWith("EJB")) {
            string = string.substring(0, string.length() - 3);
        }
        MWClass mWClass2 = mWTableDescriptor2.getMWClass();
        String string2 = this.defaultInstanceVariableName(mWRelationshipHolder, mWClass, string);
        if (mWRelationshipHolder.isOneToMany()) {
            string2 = NameTools.uniqueNameFor(string2 + "Collection", mWClass.attributeNames());
            MWClass mWClass3 = this.getCollectionClass();
            mWClassAttribute = this.generateInstanceVariable(mWTableDescriptor, string2, mWClass3);
            mWClassAttribute.setItemType(mWClass2);
        } else {
            string2 = NameTools.uniqueJavaNameFor(string2, mWClass.attributeNames());
            MWClass mWClass4 = this.getValueHolderClass();
            mWClassAttribute = this.generateInstanceVariable(mWTableDescriptor, string2, mWClass4);
            mWClassAttribute.setValueType(mWClass2);
        }
        if (this.generateMethodAccessors) {
            mWClassAttribute.generateAllAccessors();
        }
        return mWClassAttribute;
    }

    private MWClass getCollectionClass() {
        return this.project.typeNamed("java.util.Collection");
    }

    private MWTableDescriptor getDescriptorForTable(MWTable mWTable) {
        return (MWTableDescriptor)this.tableToDescriptorDictionary.get(mWTable);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public MWRelationalProject getProject() {
        return this.project;
    }

    private MWRelationshipHolder getRelationshipToCreate(MWReference mWReference, boolean bl) {
        for (MWRelationshipHolder mWRelationshipHolder : this.relationshipsToCreate) {
            if (mWRelationshipHolder.getReference() != mWReference || mWRelationshipHolder.isForeignKeyInTargetTable() != bl) continue;
            return mWRelationshipHolder;
        }
        return null;
    }

    private MWClass getValueHolderClass() {
        return this.project.typeNamed("org.eclipse.persistence.indirection.ValueHolderInterface");
    }

    public void setGenerateBidirectionalRelationships(boolean bl) {
        this.generateBidirectionalRelationships = bl;
    }

    public void setGenerateEjbs(boolean bl) {
        this.generateEjbs = bl;
    }

    public void setGenerateLocalInterfaces(boolean bl) {
        this.generateLocalInterfaces = bl;
    }

    public void setGenerateMethodAccessors(boolean bl) {
        this.generateMethodAccessors = bl;
    }

    public void setGenerateRemoteInterfaces(boolean bl) {
        this.generateRemoteInterfaces = bl;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setProject(MWRelationalProject mWRelationalProject) {
        this.project = mWRelationalProject;
    }

    public void setRelationshipsToCreate(Collection collection) {
        this.relationshipsToCreate = collection;
    }

    public void setTables(Collection collection) {
        this.tables = collection;
    }

    public boolean shouldGenerateLocalInterfaces() {
        return this.generateLocalInterfaces;
    }

    public boolean shouldGenerateRemoteInterfaces() {
        return this.generateRemoteInterfaces;
    }
}

