/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnHandle
extends MWHandle {
    private volatile MWColumn column;
    private volatile String columnTableName;
    private volatile String columnName;

    private MWColumnHandle() {
    }

    public MWColumnHandle(MWModel mWModel, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
    }

    public MWColumnHandle(MWModel mWModel, MWColumn mWColumn, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
        this.column = mWColumn;
    }

    public MWColumn getColumn() {
        return this.column;
    }

    public void setColumn(MWColumn mWColumn) {
        this.column = mWColumn;
    }

    protected Node node() {
        return this.getColumn();
    }

    public int compareTo(Object object) {
        return this.column.compareTo(((MWColumnHandle)object).column);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.column == null) {
            stringBuffer.append("null");
        } else {
            this.column.toString(stringBuffer);
        }
    }

    public MWColumnHandle setScrubber(MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        this.setScrubberInternal(nodeReferenceScrubber);
        return this;
    }

    public void resolveColumnHandles() {
        MWTable mWTable;
        super.resolveColumnHandles();
        if (this.columnTableName != null && this.columnName != null && (mWTable = this.getDatabase().tableNamed(this.columnTableName)) != null) {
            this.column = mWTable.columnNamed(this.columnName);
        }
        this.columnTableName = null;
        this.columnName = null;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWColumnHandle.class);
        xMLDescriptor.addDirectMapping("columnTableName", "getColumnTableNameForTopLink", "setColumnTableNameForTopLink", "column-table-name/text()");
        xMLDescriptor.addDirectMapping("columnName", "getColumnNameForTopLink", "setColumnNameForTopLink", "column-name/text()");
        return xMLDescriptor;
    }

    private String getColumnTableNameForTopLink() {
        return this.column == null ? null : this.column.getTable().getName();
    }

    private void setColumnTableNameForTopLink(String string) {
        this.columnTableName = string;
    }

    private String getColumnNameForTopLink() {
        return this.column == null ? null : this.column.getName();
    }

    private void setColumnNameForTopLink(String string) {
        this.columnName = string;
    }
}

