/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.StringTokenizer;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodHandle
extends MWHandle {
    private volatile MWMethod method;
    private volatile String methodDeclaringTypeName;
    private volatile String methodSignature;

    private MWMethodHandle() {
    }

    public MWMethodHandle(MWModel mWModel, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
    }

    public MWMethodHandle(MWModel mWModel, MWMethod mWMethod, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
        this.method = mWMethod;
    }

    public MWMethod getMethod() {
        return this.method;
    }

    public void setMethod(MWMethod mWMethod) {
        this.method = mWMethod;
    }

    protected Node node() {
        return this.getMethod();
    }

    public MWMethodHandle setScrubber(MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        this.setScrubberInternal(nodeReferenceScrubber);
        return this;
    }

    public void resolveMethodHandles() {
        super.resolveMethodHandles();
        if (this.methodDeclaringTypeName != null && this.methodSignature != null) {
            this.method = this.typeNamed(this.methodDeclaringTypeName).methodWithSignature(this.methodSignature);
        }
        this.methodDeclaringTypeName = null;
        this.methodSignature = null;
    }

    private String removeArrayTypesFromSignature(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.indexOf(40) + 1));
        String string2 = string.substring(string.indexOf(40) + 1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(ClassTools.elementTypeNameForClassNamed(string3));
            int n = ClassTools.arrayDepthForClassNamed(string3);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[]");
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        return this.method.compareTo(((MWMethodHandle)object).method);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.method == null) {
            stringBuffer.append("null");
        } else {
            this.method.toString(stringBuffer);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMethodHandle.class);
        xMLDescriptor.addDirectMapping("methodDeclaringTypeName", "getMethodDeclaringTypeNameForTopLink", "setMethodDeclaringTypeNameForTopLink", "method-declaring-type-name/text()");
        xMLDescriptor.addDirectMapping("methodSignature", "getMethodSignatureForTopLink", "setMethodSignatureForTopLink", "method-signature/text()");
        return xMLDescriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMethodHandle.class);
        xMLDescriptor.addDirectMapping("methodDeclaringTypeName", "getMethodDeclaringTypeNameForTopLink", "setMethodDeclaringTypeNameForTopLink", "method-declaring-type-name/text()");
        xMLDescriptor.addDirectMapping("methodSignature", "getMethodSignatureForTopLink", "legacySetMethodSignatureForTopLink", "method-signature/text()");
        return xMLDescriptor;
    }

    private String getMethodDeclaringTypeNameForTopLink() {
        return this.method == null ? null : this.method.getDeclaringType().getName();
    }

    private void setMethodDeclaringTypeNameForTopLink(String string) {
        this.methodDeclaringTypeName = string;
    }

    private String getMethodSignatureForTopLink() {
        return this.method == null ? null : this.method.signature();
    }

    private void setMethodSignatureForTopLink(String string) {
        this.methodSignature = string;
    }

    private void legacySetMethodSignatureForTopLink(String string) {
        this.methodSignature = this.removeArrayTypesFromSignature(MWModel.legacyReplaceToplinkDepracatedClassReferencesFromSignature(string));
    }
}

