/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWNamedSchemaComponentHandle
extends MWHandle {
    private volatile MWNamedSchemaComponent component;
    private volatile String schemaName;
    private List qNamePath;

    private MWNamedSchemaComponentHandle() {
    }

    public MWNamedSchemaComponentHandle(MWNode mWNode, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWNode, nodeReferenceScrubber);
    }

    public MWNamedSchemaComponentHandle(MWNode mWNode, MWNamedSchemaComponent mWNamedSchemaComponent, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWNode, nodeReferenceScrubber);
        this.component = mWNamedSchemaComponent;
    }

    private MWXmlSchemaRepository getSchemaRepository() {
        return ((MWXmlProject)this.getProject()).getSchemaRepository();
    }

    public MWNamedSchemaComponent getComponent() {
        return this.component;
    }

    public void setComponent(MWNamedSchemaComponent mWNamedSchemaComponent) {
        this.component = mWNamedSchemaComponent;
    }

    protected Node node() {
        return this.getComponent();
    }

    public MWNamedSchemaComponentHandle setScrubber(MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        this.setScrubberInternal(nodeReferenceScrubber);
        return this;
    }

    public void resolveMetadataHandles() {
        MWXmlSchema mWXmlSchema;
        super.resolveMetadataHandles();
        if (this.schemaName != null && !this.qNamePath.isEmpty() && (mWXmlSchema = this.getSchemaRepository().getSchema(this.schemaName)) != null) {
            Iterator iterator = this.qNamePath.iterator();
            QName qName = (QName)iterator.next();
            MWNamedSchemaComponent mWNamedSchemaComponent = mWXmlSchema.component(qName);
            while (iterator.hasNext()) {
                qName = (QName)iterator.next();
                mWNamedSchemaComponent = mWNamedSchemaComponent.nestedNamedComponent(qName);
            }
            this.component = mWNamedSchemaComponent;
        }
        this.schemaName = null;
        this.qNamePath = null;
    }

    public int compareTo(Object object) {
        return this.component.compareTo(((MWNamedSchemaComponentHandle)object).component);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.component.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWNamedSchemaComponentHandle.class);
        xMLDescriptor.addDirectMapping("schemaName", "getSchemaNameForTopLink", "setSchemaNameForTopLink", "schema/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("qNamePath");
        xMLCompositeCollectionMapping.setReferenceClass(QName.class);
        xMLCompositeCollectionMapping.setGetMethodName("getQNamePathForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setQNamePathForTopLink");
        xMLCompositeCollectionMapping.setXPath("qname-path/qname");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private String getSchemaNameForTopLink() {
        return this.component == null ? null : this.component.getSchema().getName();
    }

    private void setSchemaNameForTopLink(String string) {
        this.schemaName = string;
    }

    private List getQNamePathForTopLink() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        for (MWNamedSchemaComponent mWNamedSchemaComponent = this.component; mWNamedSchemaComponent != null; mWNamedSchemaComponent = mWNamedSchemaComponent.parentNamedComponent()) {
            arrayList.add(0, new QName(mWNamedSchemaComponent));
        }
        return arrayList;
    }

    private void setQNamePathForTopLink(List list) {
        this.qNamePath = list;
    }
}

