/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReferenceHandle
extends MWHandle {
    private volatile MWReference reference;
    private volatile String referenceTableName;
    private volatile String referenceName;

    private MWReferenceHandle() {
    }

    public MWReferenceHandle(MWModel mWModel, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
    }

    public MWReferenceHandle(MWModel mWModel, MWReference mWReference, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
        this.reference = mWReference;
    }

    public MWReference getReference() {
        return this.reference;
    }

    public void setReference(MWReference mWReference) {
        this.reference = mWReference;
    }

    protected Node node() {
        return this.getReference();
    }

    public MWReferenceHandle setScrubber(MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        this.setScrubberInternal(nodeReferenceScrubber);
        return this;
    }

    public void resolveReferenceHandles() {
        MWTable mWTable;
        super.resolveReferenceHandles();
        if (this.referenceTableName != null && this.referenceName != null && (mWTable = this.getDatabase().tableNamed(this.referenceTableName)) != null) {
            this.reference = mWTable.referenceNamed(this.referenceName);
        }
        this.referenceTableName = null;
        this.referenceName = null;
    }

    public int compareTo(Object object) {
        return this.reference.compareTo(((MWReferenceHandle)object).reference);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.reference == null) {
            stringBuffer.append("null");
        } else {
            this.reference.toString(stringBuffer);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWReferenceHandle.class);
        xMLDescriptor.addDirectMapping("referenceTableName", "getReferenceTableNameForTopLink", "setReferenceTableNameForTopLink", "reference-table-name/text()");
        xMLDescriptor.addDirectMapping("referenceName", "getReferenceNameForTopLink", "setReferenceNameForTopLink", "reference-name/text()");
        return xMLDescriptor;
    }

    private String getReferenceTableNameForTopLink() {
        return this.reference == null ? null : this.reference.getSourceTable().getName();
    }

    private void setReferenceTableNameForTopLink(String string) {
        this.referenceTableName = string;
    }

    private String getReferenceNameForTopLink() {
        return this.reference == null ? null : this.reference.getName();
    }

    private void setReferenceNameForTopLink(String string) {
        this.referenceName = string;
    }
}

