/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public abstract class MWAbstractReferenceMapping
extends MWMapping
implements MWReferenceMapping {
    private MWDescriptorHandle referenceDescriptorHandle;
    protected volatile String indirectionType;
    private volatile boolean privateOwned;
    private static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    protected MWAbstractReferenceMapping() {
    }

    protected MWAbstractReferenceMapping(MWMappingDescriptor mWMappingDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWMappingDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.referenceDescriptorHandle = new MWDescriptorHandle(this, this.buildReferenceDescriptorScrubber());
        this.privateOwned = false;
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (this.getInstanceVariable().isEjb20Attribute()) {
            this.forceEjb20Indirection();
        } else {
            this.indirectionType = this.getInstanceVariable().isValueHolder() ? "value-holder-indirection" : "no-indirection";
        }
    }

    protected void forceEjb20Indirection() {
        this.setUseValueHolderIndirection();
    }

    public MWDescriptor getReferenceDescriptor() {
        return this.referenceDescriptorHandle.getDescriptor();
    }

    public void setReferenceDescriptor(MWDescriptor mWDescriptor) {
        MWDescriptor mWDescriptor2 = this.referenceDescriptorHandle.getDescriptor();
        this.referenceDescriptorHandle.setDescriptor(mWDescriptor);
        this.firePropertyChanged("referenceDescriptor", mWDescriptor2, mWDescriptor);
        if (mWDescriptor != null) {
            mWDescriptor.getProject().notifyExpressionsToRecalculateQueryables();
        } else {
            this.getProject().notifyExpressionsToRecalculateQueryables();
        }
    }

    public boolean isReferenceMapping() {
        return true;
    }

    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    protected void setIndirectionType(String string) {
        String string2 = this.indirectionType;
        this.indirectionType = string;
        this.firePropertyChanged("indirection", string2, string);
    }

    protected String getIndirectionType() {
        return this.indirectionType;
    }

    public boolean isPrivateOwned() {
        return this.privateOwned;
    }

    public void setPrivateOwned(boolean bl) {
        boolean bl2 = this.privateOwned;
        this.privateOwned = bl;
        this.firePropertyChanged("privateOwned", bl2, bl);
    }

    protected void initializeFromMWReferenceObjectMapping(MWReferenceObjectMapping mWReferenceObjectMapping) {
        super.initializeFromMWReferenceObjectMapping(mWReferenceObjectMapping);
        this.setReferenceDescriptor(mWReferenceObjectMapping.getReferenceDescriptor());
    }

    protected void initializeFromMWReferenceMapping(MWReferenceMapping mWReferenceMapping) {
        super.initializeFromMWReferenceMapping(mWReferenceMapping);
        this.setPrivateOwned(mWReferenceMapping.isPrivateOwned());
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping mWIndirectableMapping) {
        super.initializeFromMWIndirectableMapping(mWIndirectableMapping);
        if (mWIndirectableMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (mWIndirectableMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    public void automap() {
        super.automap();
        this.automapReferenceDescriptor();
    }

    private void automapReferenceDescriptor() {
        if (this.getReferenceDescriptor() != null) {
            return;
        }
        MWDescriptor mWDescriptor = this.findReferenceDescriptor();
        if (mWDescriptor != null) {
            this.setReferenceDescriptor(mWDescriptor);
        }
    }

    private MWDescriptor findReferenceDescriptor() {
        MWClass mWClass = this.getInstanceVariable().getType();
        String string = mWClass.isPrimitive() || mWClass.isValueHolder() || mWClass.isAssignableToMap() || mWClass.isAssignableToCollection() || mWClass.isAssignableTo(this.typeFor(Number.class)) || mWClass == this.typeFor(String.class) ? this.getName() : mWClass.shortName();
        CollectionStringHolder[] collectionStringHolderArray = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore stringHolderScore = this.match(string.toLowerCase(), collectionStringHolderArray);
        if (stringHolderScore.getScore() < 0.8) {
            return null;
        }
        String string2 = this.getParentDescriptor().packageName();
        MWDescriptor mWDescriptor = null;
        Iterator iterator = ((CollectionStringHolder)stringHolderScore.getStringHolder()).iterator();
        while (iterator.hasNext()) {
            mWDescriptor = (MWDescriptor)iterator.next();
            if (!mWDescriptor.packageName().equals(string2)) continue;
            return mWDescriptor;
        }
        return mWDescriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        Collection collection = this.candidateReferenceDescriptors();
        HashMap<String, CollectionStringHolder> hashMap = new HashMap<String, CollectionStringHolder>(collection.size());
        for (MWDescriptor mWDescriptor : collection) {
            String string = mWDescriptor.shortName().toLowerCase();
            CollectionStringHolder collectionStringHolder = (CollectionStringHolder)hashMap.get(string);
            if (collectionStringHolder == null) {
                collectionStringHolder = new CollectionStringHolder(string);
                hashMap.put(string, collectionStringHolder);
            }
            collectionStringHolder.add(mWDescriptor);
        }
        return hashMap.values().toArray(new CollectionStringHolder[hashMap.size()]);
    }

    private Collection candidateReferenceDescriptors() {
        ArrayList<MWDescriptor> arrayList = new ArrayList<MWDescriptor>();
        Iterator iterator = this.getProject().descriptors();
        while (iterator.hasNext()) {
            MWDescriptor mWDescriptor = (MWDescriptor)iterator.next();
            if (!this.descriptorIsValidReferenceDescriptor(mWDescriptor)) continue;
            arrayList.add(mWDescriptor);
        }
        return arrayList;
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] collectionStringHolderArray) {
        return PARTIAL_STRING_MATCHER.match(string, collectionStringHolderArray);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.referenceDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWAbstractReferenceMapping.this.setReferenceDescriptor(null);
            }

            public String toString() {
                return "MWAbstractReferenceMapping.buildReferenceDescriptorScrubber()";
            }
        };
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        super.descriptorReplaced(mWDescriptor, mWDescriptor2);
        if (this.getReferenceDescriptor() == mWDescriptor) {
            this.setReferenceDescriptor(mWDescriptor2);
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkReferenceDescriptor(list);
        this.checkIndirection(list);
    }

    protected void checkReferenceDescriptor(List list) {
        MWDescriptor mWDescriptor = this.getReferenceDescriptor();
        if (mWDescriptor == null) {
            list.add(this.buildProblem("0450"));
        } else {
            if (!this.descriptorIsValidReferenceDescriptor(mWDescriptor)) {
                list.add(this.buildProblem(this.referenceDescriptorInvalidProblemString()));
            }
            if (!mWDescriptor.isActive()) {
                list.add(this.buildProblem("0451", this.getInstanceVariable().getName(), this.getReferenceDescriptor().getMWClass().shortName()));
            }
            this.checkReferenceDescriptorCachIsolation(list);
        }
    }

    protected abstract String referenceDescriptorInvalidProblemString();

    protected void checkReferenceDescriptorCachIsolation(List list) {
        MWCachingPolicy mWCachingPolicy = this.getParentDescriptor().getTransactionalPolicy().getCachingPolicy();
        String string = mWCachingPolicy.getCacheIsolation().getMWModelOption();
        if (string == "DEFAULT") {
            mWCachingPolicy = mWCachingPolicy.getProject().getDefaultsPolicy().getCachingPolicy();
            string = mWCachingPolicy.getCacheIsolation().getMWModelOption();
        }
        if (string == "Shared") {
            mWCachingPolicy = this.getReferenceDescriptor().getTransactionalPolicy().getCachingPolicy();
            String string2 = mWCachingPolicy.getCacheIsolation().getMWModelOption();
            if (string2 == "DEFAULT") {
                mWCachingPolicy = mWCachingPolicy.getProject().getDefaultsPolicy().getCachingPolicy();
                string2 = mWCachingPolicy.getCacheIsolation().getMWModelOption();
            }
            if (string2 == "Isolated") {
                list.add(this.buildProblem("0452", this.getReferenceDescriptor().getName(), this.getName()));
            }
        }
    }

    protected void checkIndirection(List list) {
        if (this.usesValueHolderIndirection()) {
            if (this.getInstanceVariable().isTLValueHolder()) {
                list.add(this.buildProblem("0552"));
            } else if (!this.getProject().usesWeaving() && !this.getInstanceVariable().isValueHolder()) {
                list.add(this.buildProblem("0551"));
            }
        } else if (this.getInstanceVariable().isValueHolder()) {
            list.add(this.buildProblem("0550"));
        }
    }

    public DatabaseMapping runtimeMapping() {
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null) {
            foreignReferenceMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        if (this.usesValueHolderIndirection()) {
            foreignReferenceMapping.useBasicIndirection();
        } else {
            foreignReferenceMapping.dontUseIndirection();
        }
        foreignReferenceMapping.setIsPrivateOwned(this.isPrivateOwned());
        return foreignReferenceMapping;
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.getInstanceVariable() == null) {
            stringBuffer.append("<no instance variable>");
        } else {
            stringBuffer.append(this.getInstanceVariable().getName());
        }
        stringBuffer.append(" -> ");
        if (this.getReferenceDescriptor() == null) {
            stringBuffer.append("<no reference descriptor selected>");
        } else {
            stringBuffer.append(this.getReferenceDescriptor().getMWClass().shortName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractReferenceMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("referenceDescriptorHandle");
        xMLCompositeObjectMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorHandle.class);
        xMLCompositeObjectMapping.setXPath("reference-descriptor-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        objectTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        objectTypeConverter.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        objectTypeConverter.addConversionValue((Object)"proxy-indirection", (Object)"proxy-indirection");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("indirectionType");
        xMLDirectMapping.setXPath("indirection-type/text()");
        xMLDirectMapping.setNullValue((Object)"no-indirection");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("privateOwned", "private-owned/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    private MWDescriptorHandle getReferenceDescriptorHandleForTopLink() {
        return this.referenceDescriptorHandle.getDescriptor() == null ? null : this.referenceDescriptorHandle;
    }

    private void setReferenceDescriptorHandleForTopLink(MWDescriptorHandle mWDescriptorHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReferenceDescriptorScrubber();
        this.referenceDescriptorHandle = mWDescriptorHandle == null ? new MWDescriptorHandle(this, nodeReferenceScrubber) : mWDescriptorHandle.setScrubber(nodeReferenceScrubber);
    }
}

