/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMapContainerPolicy
extends MWModel
implements MWContainerPolicy {
    private MWMethodHandle keyMethodHandle;
    public static final String KEY_METHOD_PROPERTY = "keyMethod";
    private DefaultingContainerClass containerClass;

    protected MWMapContainerPolicy() {
    }

    public MWMapContainerPolicy(MWMapContainerMapping mWMapContainerMapping) {
        super(mWMapContainerMapping);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.keyMethodHandle = new MWMethodHandle(this, this.buildKeyMethodScrubber());
        this.containerClass = new DefaultingContainerClass(this);
    }

    public MWMethod getKeyMethod() {
        return this.keyMethodHandle.getMethod();
    }

    public void setKeyMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getKeyMethod();
        this.keyMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(KEY_METHOD_PROPERTY, mWMethod2, mWMethod);
    }

    public DefaultingContainerClass getDefaultingContainerClass() {
        return this.containerClass;
    }

    public MWMapContainerMapping getMapContainerMapping() {
        return (MWMapContainerMapping)this.getParent();
    }

    private MWClassAttribute getInstanceVariable() {
        return ((MWMapping)this.getParent()).getInstanceVariable();
    }

    public Iterator candidateKeyMethods() {
        MWDescriptor mWDescriptor = this.getMapContainerMapping().getReferenceDescriptor();
        return mWDescriptor != null ? mWDescriptor.getMWClass().candidateMapContainerPolicyKeyMethods() : NullIterator.instance();
    }

    public boolean usesSorting() {
        return false;
    }

    public void setUsesSorting(boolean bl) {
    }

    public MWClass getComparatorClass() {
        return null;
    }

    public void setComparatorClass(MWClass mWClass) {
    }

    public void referenceDescriptorChanged(MWDescriptor mWDescriptor) {
        if (mWDescriptor == null || this.getKeyMethod() != null && !CollectionTools.contains(this.candidateKeyMethods(), (Object)this.getKeyMethod())) {
            this.setKeyMethod(null);
        }
    }

    public MWClass defaultContainerClass() {
        if (this.getMapContainerMapping().usesTransparentIndirection()) {
            return this.defaultIndirectContainerClass();
        }
        MWClassAttribute mWClassAttribute = this.getInstanceVariable();
        MWClass mWClass = mWClassAttribute.isValueHolder() ? this.getInstanceVariable().getValueType() : this.getInstanceVariable().getType();
        if (mWClass.isAssignableToMap() && mWClass.isInstantiable()) {
            return mWClass;
        }
        return this.typeFor(HashMap.class);
    }

    private MWClass defaultIndirectContainerClass() {
        return this.typeFor(IndirectMap.class);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.keyMethodHandle);
        list.add(this.containerClass);
    }

    private MWHandle.NodeReferenceScrubber buildKeyMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWMapContainerPolicy.this.setKeyMethod(null);
            }

            public String toString() {
                return "MWMapContainerPolicy.buildKeyMethodScrubber()";
            }
        };
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        MWMethod mWMethod = this.getKeyMethod();
        if (mWMethod == null) {
            list.add(this.buildProblem("0475"));
        } else {
            this.checkKeyMethod(mWMethod, list);
        }
        this.checkContainerClass(list);
    }

    private void checkKeyMethod(MWMethod mWMethod, List list) {
        if (mWMethod.isCandidateMapContainerPolicyKeyMethod()) {
            if (!CollectionTools.contains(this.candidateKeyMethods(), (Object)mWMethod)) {
                list.add(this.buildProblem("0476"));
            }
        } else {
            list.add(this.buildProblem("0477"));
        }
    }

    protected void checkContainerClass(List list) {
        MWClass mWClass = this.getDefaultingContainerClass().getContainerClass();
        if (mWClass != null && !mWClass.mightBeAssignableToMap()) {
            list.add(this.buildProblem("0472"));
        }
    }

    public ContainerPolicy runtimeContainerPolicy() {
        MapContainerPolicy mapContainerPolicy = new MapContainerPolicy(this.getDefaultingContainerClass().getContainerClass().getName());
        String string = this.getKeyMethod() != null ? this.getKeyMethod().getName() : null;
        mapContainerPolicy.setKeyName(string);
        return mapContainerPolicy;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMapContainerPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("keyMethodHandle");
        xMLCompositeObjectMapping.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping.setSetMethodName("setKeyMethodHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getKeyMethodHandleForTopLink");
        xMLCompositeObjectMapping.setXPath("key-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("containerClass");
        xMLCompositeObjectMapping2.setReferenceClass(DefaultingContainerClass.class);
        xMLCompositeObjectMapping2.setXPath("container-class");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWMethodHandle getKeyMethodHandleForTopLink() {
        return this.keyMethodHandle.getMethod() == null ? null : this.keyMethodHandle;
    }

    private void setKeyMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildKeyMethodScrubber();
        this.keyMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

