/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodBasedTransformer
extends MWTransformer {
    private MWMethodHandle methodHandle;
    public static final String METHOD_PROPERTY = "method";

    private MWMethodBasedTransformer() {
    }

    public MWMethodBasedTransformer(MWTransformer.Parent parent, MWMethod mWMethod) {
        super(parent);
        this.setMethod(mWMethod);
    }

    MWMethodBasedTransformer(MWTransformer.Parent parent, MWMethodHandle mWMethodHandle) {
        super(parent);
        this.methodHandle = mWMethodHandle.setScrubber(this.buildMethodScrubber());
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWMethodBasedTransformer.this.setMethod(null);
            }

            public String toString() {
                return "MWMethodBasedTransformer.buildMethodScrubber()";
            }
        };
    }

    public MWMethod getMethod() {
        return this.methodHandle.getMethod();
    }

    public void setMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getMethod();
        this.methodHandle.setMethod(mWMethod);
        if (this.attributeValueHasChanged(mWMethod2, mWMethod)) {
            this.firePropertyChanged(METHOD_PROPERTY, mWMethod2, mWMethod);
            this.firePropertyChanged("transformer", mWMethod2, mWMethod);
            this.getProject().recalculateAggregatePathsToColumn(this.parentDescriptor());
        }
    }

    public String fieldNameForRuntime() {
        return "METHOD_TRANSFORMER " + (this.getMethod() == null ? null : this.getMethod().getName());
    }

    public AggregateFieldDescription fullFieldDescription() {
        return this.getDescriptionForMethodSignature(this.getMethod());
    }

    private AggregateFieldDescription getDescriptionForMethodSignature(MWMethod mWMethod) {
        final String string = mWMethod == null ? null : mWMethod.signature();
        return new AggregateFieldDescription(){

            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_METHOD_BASED_TRANSFORMER";
            }

            public Object[] getMessageArguments() {
                return new Object[]{string};
            }
        };
    }

    public boolean fieldIsWritten() {
        return true;
    }

    public String transformerDisplayString() {
        MWMethod mWMethod = this.getMethod();
        return mWMethod == null ? null : mWMethod.shortSignature();
    }

    public void addAttributeTransformerProblemsForMapping(List list, MWTransformationMapping mWTransformationMapping) {
        if (this.getMethod() == null) {
            list.add(this.buildProblem("0523"));
        } else {
            if (!this.getMethod().isCandidateAttributeTransformerMethod()) {
                list.add(this.buildProblem("0525", this.getMethod().signature()));
            }
            if (!CollectionTools.contains(mWTransformationMapping.getParentDescriptor().getMWClass().allMethods(), (Object)this.getMethod())) {
                list.add(this.buildProblem("0524", this.getMethod().signature()));
            }
        }
    }

    public void addFieldTransformerProblemsForAssociation(List list, MWFieldTransformerAssociation mWFieldTransformerAssociation) {
        if (this.getMethod() == null) {
            list.add(this.buildProblem("0531", mWFieldTransformerAssociation.fieldName()));
        } else {
            if (!this.getMethod().isCandidateFieldTransformerMethod()) {
                list.add(this.buildProblem("0533", this.getMethod().signature(), mWFieldTransformerAssociation.fieldName()));
            }
            if (!CollectionTools.contains(mWFieldTransformerAssociation.getMapping().getParentDescriptor().getMWClass().allMethods(), (Object)this.getMethod())) {
                list.add(this.buildProblem("0532", this.getMethod().signature(), mWFieldTransformerAssociation.fieldName()));
            }
        }
    }

    public void setRuntimeAttributeTransformer(AbstractTransformationMapping abstractTransformationMapping) {
        if (this.getMethod() != null) {
            abstractTransformationMapping.setAttributeTransformation(this.getMethod().getName());
        }
    }

    public void addRuntimeFieldTransformer(AbstractTransformationMapping abstractTransformationMapping, DatabaseField databaseField) {
        if (this.getMethod() != null) {
            abstractTransformationMapping.addFieldTransformation(databaseField, this.getMethod().getName());
        }
    }

    public void toString(StringBuffer stringBuffer) {
        this.getMethod().toString(stringBuffer);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMethodBasedTransformer.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWTransformer.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("methodHandle");
        xMLCompositeObjectMapping.setGetMethodName("getMethodHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setMethodHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping.setXPath("method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildMethodScrubber();
        this.methodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

