/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWClassBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMethodBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWTransformationMapping
extends MWMapping
implements MWIndirectableMapping,
MWTransformer.Parent {
    private volatile boolean mutable;
    public static final String MUTABLE_PROPERTY = "mutable";
    private volatile MWTransformer attributeTransformer;
    public static final String ATTRIBUTE_TRANSFORMER_PROPERTY = "attributeTransformer";
    private List fieldTransformerAssociations;
    public static final String FIELD_TRANSFORMER_ASSOCIATIONS_LIST = "fieldTransformerAssociations";
    private volatile String indirectionType;

    protected MWTransformationMapping() {
    }

    protected MWTransformationMapping(MWMappingDescriptor mWMappingDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWMappingDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.attributeTransformer = new MWNullTransformer(this);
        this.fieldTransformerAssociations = new Vector();
        this.indirectionType = "no-indirection";
        this.mutable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.attributeTransformer);
        List list2 = this.fieldTransformerAssociations;
        synchronized (list2) {
            list.addAll(this.fieldTransformerAssociations);
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        boolean bl2 = this.mutable;
        this.mutable = bl;
        this.firePropertyChanged(MUTABLE_PROPERTY, bl2, bl);
    }

    public MWTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    private void setAttributeTransformer(MWTransformer mWTransformer) {
        MWTransformer mWTransformer2 = this.attributeTransformer;
        this.attributeTransformer = mWTransformer;
        this.firePropertyChanged(ATTRIBUTE_TRANSFORMER_PROPERTY, mWTransformer2, mWTransformer);
    }

    public void clearAttributeTransformer() {
        this.setAttributeTransformer(new MWNullTransformer(this));
    }

    public void setAttributeTransformer(MWMethod mWMethod) {
        this.setAttributeTransformer(new MWMethodBasedTransformer((MWTransformer.Parent)this, mWMethod));
    }

    public void setAttributeTransformer(MWClass mWClass) {
        this.setAttributeTransformer(new MWClassBasedTransformer(this, mWClass));
    }

    public Iterator candidateAttributeTransformationMethods() {
        return this.getParentDescriptor().getMWClass().allInstanceMethods();
    }

    public ListIterator fieldTransformerAssociations() {
        return new CloneListIterator(this.fieldTransformerAssociations);
    }

    public int fieldTransformerAssociationsSize() {
        return this.fieldTransformerAssociations.size();
    }

    public void addFieldTransformerAssociation(MWFieldTransformerAssociation mWFieldTransformerAssociation) {
        this.addItemToList(mWFieldTransformerAssociation, this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public void removeFieldTransformerAssociation(MWFieldTransformerAssociation mWFieldTransformerAssociation) {
        int n = this.fieldTransformerAssociations.indexOf(mWFieldTransformerAssociation);
        if (n != -1) {
            this.removeNodeFromList(n, this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
            this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        }
    }

    public void clearFieldTransformerAssociations() {
        if (this.clearList(this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST)) {
            this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        }
    }

    public Iterator candidateFieldTransformationMethods() {
        return this.getParentDescriptor().getMWClass().allInstanceMethods();
    }

    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    private void setIndirectionType(String string) {
        String string2 = this.indirectionType;
        this.indirectionType = string;
        this.firePropertyChanged("indirection", string2, string);
    }

    public MWTransformationMapping transformationMapping() {
        return this;
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWTransformationMapping(this);
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping mWIndirectableMapping) {
        super.initializeFromMWIndirectableMapping(mWIndirectableMapping);
        if (mWIndirectableMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (mWIndirectableMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.attributeTransformer.addAttributeTransformerProblemsForMapping(list, this);
        this.addFieldTransformerProblemsTo(list);
        this.addIndirectionProblemsTo(list);
    }

    private void addFieldTransformerProblemsTo(List list) {
        if (this.fieldTransformerAssociations.size() == 0 && !this.isReadOnly()) {
            list.add(this.buildProblem("0526"));
        }
    }

    private void addIndirectionProblemsTo(List list) {
        if (this.getInstanceVariable().isValueHolder()) {
            if (!this.usesValueHolderIndirection()) {
                list.add(this.buildProblem("0550"));
            }
        } else if (!this.getProject().usesWeaving() && this.usesValueHolderIndirection()) {
            list.add(this.buildProblem("0551"));
        }
    }

    public DatabaseMapping runtimeMapping() {
        AbstractTransformationMapping abstractTransformationMapping = (AbstractTransformationMapping)super.runtimeMapping();
        this.attributeTransformer.setRuntimeAttributeTransformer(abstractTransformationMapping);
        ListIterator listIterator = this.fieldTransformerAssociations();
        while (listIterator.hasNext()) {
            ((MWFieldTransformerAssociation)listIterator.next()).addRuntimeFieldTransformer(abstractTransformationMapping);
        }
        if (this.usesValueHolderIndirection()) {
            abstractTransformationMapping.setUsesIndirection(true);
        }
        abstractTransformationMapping.setIsMutable(this.mutable);
        return abstractTransformationMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWTransformationMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(ATTRIBUTE_TRANSFORMER_PROPERTY);
        xMLCompositeObjectMapping.setGetMethodName("getAttributeTransformerForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setAttributeTransformerForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTransformer.class);
        xMLCompositeObjectMapping.setXPath("attribute-transformer");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWFieldTransformerAssociation.class);
        xMLCompositeCollectionMapping.setXPath("field-transformer-associations");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        objectTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("indirectionType");
        xMLDirectMapping.setXPath("indirection-type/text()");
        xMLDirectMapping.setNullValue((Object)"no-indirection");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        xMLDescriptor.addDirectMapping(MUTABLE_PROPERTY, "mutable/text()");
        return xMLDescriptor;
    }

    private MWTransformer getAttributeTransformerForTopLink() {
        return this.attributeTransformer.valueForTopLink();
    }

    private void setAttributeTransformerForTopLink(MWTransformer mWTransformer) {
        this.attributeTransformer = MWTransformer.buildTransformerForTopLink(mWTransformer);
    }
}

