/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregatePathToColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWAggregateMapping
extends MWMapping
implements MWReferenceObjectMapping {
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";
    private Collection pathsToFields;
    public static final String PATHS_TO_FIELDS_COLLECTION = "pathsToFields";
    private MWDescriptorHandle referenceDescriptorHandle;
    private static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    private MWAggregateMapping() {
    }

    MWAggregateMapping(MWMappingDescriptor mWMappingDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWMappingDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.pathsToFields = new Vector();
        this.referenceDescriptorHandle = new MWDescriptorHandle(this, this.buildReferenceDescriptorScrubber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.pathsToFields;
        synchronized (collection) {
            list.addAll(this.pathsToFields);
        }
        list.add(this.referenceDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWAggregateMapping.this.setReferenceDescriptor(null);
            }

            public String toString() {
                return "MWAggregateMapping.buildReferenceDescriptorScrubber()";
            }
        };
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        if (this.getReferenceDescriptor() == mWDescriptor) {
            this.setReferenceDescriptor(mWDescriptor2);
        }
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean bl) {
        boolean bl2 = this.allowsNull;
        this.allowsNull = bl;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, bl2, bl);
    }

    public Iterator pathsToFields() {
        return new CloneIterator(this.pathsToFields);
    }

    public int pathsToFieldsSize() {
        return this.pathsToFields.size();
    }

    private Collection getPathsToFieldsDeepCopy(MWAggregateMapping mWAggregateMapping) {
        Vector<MWAggregatePathToColumn> vector = new Vector<MWAggregatePathToColumn>(this.pathsToFields.size());
        Iterator iterator = this.pathsToFields();
        while (iterator.hasNext()) {
            vector.add(((MWAggregatePathToColumn)iterator.next()).copy(mWAggregateMapping));
        }
        return vector;
    }

    public MWDescriptor getReferenceDescriptor() {
        return this.referenceDescriptorHandle.getDescriptor();
    }

    public void setReferenceDescriptor(MWDescriptor mWDescriptor) {
        MWDescriptor mWDescriptor2 = this.getReferenceDescriptor();
        this.referenceDescriptorHandle.setDescriptor(mWDescriptor);
        this.firePropertyChanged("referenceDescriptor", mWDescriptor2, mWDescriptor);
        this.updatePathsToFields();
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor(), this);
        if (mWDescriptor != null) {
            mWDescriptor.getProject().notifyExpressionsToRecalculateQueryables();
        } else {
            this.getProject().notifyExpressionsToRecalculateQueryables();
        }
    }

    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor mWDescriptor) {
        return ((MWRelationalDescriptor)((Object)mWDescriptor)).isAggregateDescriptor();
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWAggregateMapping(this);
    }

    protected void initializeFromMWReferenceObjectMapping(MWReferenceObjectMapping mWReferenceObjectMapping) {
        super.initializeFromMWReferenceObjectMapping(mWReferenceObjectMapping);
        this.setReferenceDescriptor(mWReferenceObjectMapping.getReferenceDescriptor());
    }

    public MWAggregateMapping asMWAggregateMapping() {
        return this;
    }

    private void insertRootNodeIntoAll(MWMapping mWMapping, Collection collection) {
        for (MWAggregatePathToColumn mWAggregatePathToColumn : collection) {
            mWAggregatePathToColumn.insertRootMappingNode(mWMapping);
        }
    }

    private boolean compareAPTFs(MWAggregatePathToColumn mWAggregatePathToColumn, MWAggregatePathToColumn mWAggregatePathToColumn2) {
        return mWAggregatePathToColumn.getMappingNodes().containsAll(mWAggregatePathToColumn2.getMappingNodes()) && mWAggregatePathToColumn2.getMappingNodes().containsAll(mWAggregatePathToColumn.getMappingNodes()) && mWAggregatePathToColumn.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime().equals(mWAggregatePathToColumn2.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime());
    }

    private boolean collectionRemoveAPTF(Collection collection, MWAggregatePathToColumn mWAggregatePathToColumn) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.compareAPTFs((MWAggregatePathToColumn)iterator.next(), mWAggregatePathToColumn)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void mergePathsToFields(Collection collection) {
        Iterator iterator = this.pathsToFields.iterator();
        while (iterator.hasNext()) {
            MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)iterator.next();
            if (this.collectionRemoveAPTF(collection, mWAggregatePathToColumn)) continue;
            iterator.remove();
        }
        this.addItemsToCollection(collection, this.pathsToFields, PATHS_TO_FIELDS_COLLECTION);
    }

    private MWAggregatePathToColumn buildAPTF(MWMapping mWMapping, AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator) {
        MWAggregatePathToColumn mWAggregatePathToColumn = new MWAggregatePathToColumn(this);
        mWAggregatePathToColumn.addMappingNode(mWMapping);
        mWAggregatePathToColumn.setAggregateRuntimeFieldNameGenerator(aggregateRuntimeFieldNameGenerator);
        return mWAggregatePathToColumn;
    }

    private MWAggregatePathToColumn buildAPTF(AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator) {
        MWAggregatePathToColumn mWAggregatePathToColumn = new MWAggregatePathToColumn(this);
        mWAggregatePathToColumn.setAggregateRuntimeFieldNameGenerator(aggregateRuntimeFieldNameGenerator);
        return mWAggregatePathToColumn;
    }

    public void updatePathsToFields() {
        ArrayList<MWAggregatePathToColumn> arrayList = new ArrayList<MWAggregatePathToColumn>();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor() != this.getParentDescriptor()) {
            Iterator iterator = this.getReferenceDescriptor().mappingsIncludingInherited();
            while (iterator.hasNext()) {
                Object object;
                MWMapping mWMapping = (MWMapping)iterator.next();
                if (mWMapping instanceof MWAggregateMapping) {
                    ((MWAggregateMapping)mWMapping).updatePathsToFields();
                    object = ((MWAggregateMapping)mWMapping).getPathsToFieldsDeepCopy(this);
                    this.insertRootNodeIntoAll(mWMapping, (Collection)object);
                    arrayList.addAll((Collection<MWAggregatePathToColumn>)object);
                    continue;
                }
                object = mWMapping.aggregateFieldNameGenerators();
                while (object.hasNext()) {
                    arrayList.add(this.buildAPTF(mWMapping, (AggregateRuntimeFieldNameGenerator)object.next()));
                }
            }
            iterator = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.buildAPTF((AggregateRuntimeFieldNameGenerator)iterator.next()));
            }
        }
        this.mergePathsToFields(arrayList);
        this.fireCollectionChanged(PATHS_TO_FIELDS_COLLECTION);
    }

    public String initialValue(MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        String string = super.initialValue(mWClassCodeGenPolicy);
        if (!this.allowsNull()) {
            if (this.getReferenceDescriptor() != null) {
                string = this.getInstanceVariable().initialValueSourceCodeFor(this.getReferenceDescriptor().getMWClass());
            }
            if ("".equals(string)) {
                string = mWClassCodeGenPolicy.aggregateMappingDoesNotAllowNullImplementationClassNotDeterminedComment() + StringTools.CR + "\t\t" + null;
            }
            string = StringTools.CR + "\t\t" + mWClassCodeGenPolicy.aggregateMappingDoesNotAllowNullComment(this) + StringTools.CR + "\t\t" + string;
        }
        return string;
    }

    public boolean allowsChildren() {
        return true;
    }

    public boolean isLeaf(Filter filter) {
        return this.subQueryableElements(filter).size() == 0;
    }

    public List subQueryableElements(Filter filter) {
        List list = new ArrayList();
        if (this.getReferenceDescriptor() != null) {
            list = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).getQueryables(filter);
            Collections.sort(list, DEFAULT_COMPARATOR);
        }
        return list;
    }

    public MWQueryable subQueryableElementAt(int n, Filter filter) {
        return (MWQueryable)this.subQueryableElements(filter).get(n);
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    public String iconKey() {
        return "mapping.aggregate";
    }

    public void automap() {
        super.automap();
        this.automapReferenceDescriptor();
    }

    private void automapReferenceDescriptor() {
        if (this.getReferenceDescriptor() != null) {
            return;
        }
        MWDescriptor mWDescriptor = this.findReferenceDescriptor();
        if (mWDescriptor != null) {
            this.setReferenceDescriptor(mWDescriptor);
        }
    }

    private MWDescriptor findReferenceDescriptor() {
        MWClass mWClass = this.getInstanceVariable().getType();
        String string = mWClass.isPrimitive() || mWClass.isValueHolder() || mWClass.isAssignableToMap() || mWClass.isAssignableToCollection() || mWClass.isAssignableTo(this.typeFor(Number.class)) || mWClass == this.typeFor(String.class) ? this.getName() : mWClass.shortName();
        CollectionStringHolder[] collectionStringHolderArray = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore stringHolderScore = this.match(string.toLowerCase(), collectionStringHolderArray);
        if (stringHolderScore.getScore() < 0.8) {
            return null;
        }
        String string2 = this.getParentDescriptor().packageName();
        MWDescriptor mWDescriptor = null;
        Iterator iterator = ((CollectionStringHolder)stringHolderScore.getStringHolder()).iterator();
        while (iterator.hasNext()) {
            mWDescriptor = (MWDescriptor)iterator.next();
            if (!mWDescriptor.packageName().equals(string2)) continue;
            return mWDescriptor;
        }
        return mWDescriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        Collection collection = this.candidateReferenceDescriptors();
        HashMap<String, CollectionStringHolder> hashMap = new HashMap<String, CollectionStringHolder>(collection.size());
        for (MWDescriptor mWDescriptor : collection) {
            String string = mWDescriptor.shortName().toLowerCase();
            CollectionStringHolder collectionStringHolder = (CollectionStringHolder)hashMap.get(string);
            if (collectionStringHolder == null) {
                collectionStringHolder = new CollectionStringHolder(string);
                hashMap.put(string, collectionStringHolder);
            }
            collectionStringHolder.add(mWDescriptor);
        }
        return hashMap.values().toArray(new CollectionStringHolder[hashMap.size()]);
    }

    private Collection candidateReferenceDescriptors() {
        ArrayList<MWDescriptor> arrayList = new ArrayList<MWDescriptor>();
        Iterator iterator = this.getProject().descriptors();
        while (iterator.hasNext()) {
            MWDescriptor mWDescriptor = (MWDescriptor)iterator.next();
            if (!this.descriptorIsCandidateReferenceDescriptor(mWDescriptor)) continue;
            arrayList.add(mWDescriptor);
        }
        return arrayList;
    }

    private boolean descriptorIsCandidateReferenceDescriptor(MWDescriptor mWDescriptor) {
        return mWDescriptor != this.getParentDescriptor() && ((MWRelationalDescriptor)((Object)mWDescriptor)).isAggregateDescriptor();
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] collectionStringHolderArray) {
        return PARTIAL_STRING_MATCHER.match(string, collectionStringHolderArray);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkReferenceDescriptorIsValid(list);
        this.checkColumnsAreUnique(list);
        this.checkColumnsAreValid(list);
    }

    private void checkReferenceDescriptorIsValid(List list) {
        if (this.getReferenceDescriptor() == null) {
            list.add(this.buildProblem("0450"));
        } else if (!this.getReferenceDescriptor().isActive()) {
            list.add(this.buildProblem("0451", this.getInstanceVariable().getName(), this.getReferenceDescriptor().getMWClass().shortName()));
        } else if (!this.descriptorIsValidReferenceDescriptor(this.getReferenceDescriptor())) {
            list.add(this.buildProblem("0570"));
        }
    }

    private void checkColumnsAreUnique(List list) {
        if (this.getParentDescriptor() instanceof MWAggregateDescriptor) {
            return;
        }
        int n = this.pathsToFieldsSize();
        HashSet<MWColumn> hashSet = new HashSet<MWColumn>(n);
        Iterator iterator = this.pathsToFields();
        while (iterator.hasNext()) {
            MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)iterator.next();
            MWColumn mWColumn = mWAggregatePathToColumn.getColumn();
            if (mWColumn == null || !mWAggregatePathToColumn.fieldIsWritten() || hashSet.add(mWColumn)) continue;
            list.add(this.buildProblem("0572"));
        }
    }

    private void checkColumnsAreValid(List list) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        Iterator iterator = this.pathsToFields();
        while (iterator.hasNext()) {
            MWColumn mWColumn = ((MWAggregatePathToColumn)iterator.next()).getColumn();
            if (mWColumn == null) {
                list.add(this.buildProblem("0571"));
                continue;
            }
            if (CollectionTools.contains(((MWTableDescriptor)this.getParentDescriptor()).allAssociatedColumns(), (Object)mWColumn)) continue;
            list.add(this.buildProblem("0573"));
        }
    }

    public void addWrittenFieldsTo(Collection collection) {
        Iterator iterator = this.pathsToFields();
        while (iterator.hasNext()) {
            MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)iterator.next();
            if (mWAggregatePathToColumn.getColumn() == null || !mWAggregatePathToColumn.fieldIsWritten()) continue;
            collection.add(mWAggregatePathToColumn.getColumn());
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new AggregateObjectMapping();
    }

    public DatabaseMapping runtimeMapping() {
        AggregateObjectMapping aggregateObjectMapping = (AggregateObjectMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null) {
            aggregateObjectMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        aggregateObjectMapping.setIsNullAllowed(this.allowsNull());
        this.convertPathsToFieldsToRuntime(aggregateObjectMapping);
        return aggregateObjectMapping;
    }

    private void convertPathsToFieldsToRuntime(AggregateObjectMapping aggregateObjectMapping) {
        Iterator iterator = this.pathsToFields();
        while (iterator.hasNext()) {
            MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)iterator.next();
            mWAggregatePathToColumn.adjustRuntimeMapping(aggregateObjectMapping);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAggregateMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("referenceDescriptorHandle");
        xMLCompositeObjectMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorHandle.class);
        xMLCompositeObjectMapping.setXPath("reference-descriptor-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(PATHS_TO_FIELDS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getPathsToFieldsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setPathsToFieldsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWAggregatePathToColumn.class);
        xMLCompositeCollectionMapping.setXPath("paths-to-fields/aggregate-path-to-field");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private MWDescriptorHandle getReferenceDescriptorHandleForTopLink() {
        return this.referenceDescriptorHandle.getDescriptor() == null ? null : this.referenceDescriptorHandle;
    }

    private void setReferenceDescriptorHandleForTopLink(MWDescriptorHandle mWDescriptorHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReferenceDescriptorScrubber();
        this.referenceDescriptorHandle = mWDescriptorHandle == null ? new MWDescriptorHandle(this, nodeReferenceScrubber) : mWDescriptorHandle.setScrubber(nodeReferenceScrubber);
    }

    private Collection getPathsToFieldsForTopLink() {
        return this.pathsToFields;
    }

    private void setPathsToFieldsForTopLink(Collection collection) {
        this.pathsToFields = collection;
    }
}

