/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionOrdering;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWCollectionMapping
extends MWAbstractTableReferenceMapping
implements MWIndirectableContainerMapping,
MWMapContainerMapping {
    private volatile MWContainerPolicy containerPolicy;
    private List orderings;
    public static final String ORDERINGS_LIST = "orderings";
    public static final String EJB_INDIRECT_LIST_CLASS_NAME = "org.eclipse.persistence.indirection.EJBIndirectList";
    public static final String EJB_INDIRECT_SET_CLASS_NAME = "org.eclipse.persistence.indirection.EJBIndirectSet";
    public static final String INDIRECT_LIST_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectList";
    public static final String INDIRECT_MAP_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectMap";
    public static final String INDIRECT_SET_CLASS_NAME = "org.eclipse.persistence.indirection.IndirectSet";

    protected MWCollectionMapping() {
    }

    protected MWCollectionMapping(MWRelationalClassDescriptor mWRelationalClassDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWRelationalClassDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.orderings = new Vector();
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (mWClassAttribute.getDimensionality() > 0) {
            this.containerPolicy = new MWListContainerPolicy(this);
            this.setUseTransparentIndirection();
        } else {
            MWClass mWClass = null;
            if (mWClassAttribute.isValueHolder()) {
                this.setUseValueHolderIndirection();
                mWClass = mWClassAttribute.getValueType();
            } else {
                this.setUseTransparentIndirection();
                mWClass = mWClassAttribute.getType();
            }
            this.containerPolicy = mWClass.isAssignableToMap() ? new MWMapContainerPolicy(this) : (mWClass.isAssignableToList() ? new MWListContainerPolicy(this) : (mWClass.isAssignableToSet() ? new MWSetContainerPolicy(this) : (mWClass.isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.containerPolicy);
        List list2 = this.orderings;
        synchronized (list2) {
            list.addAll(this.orderings);
        }
    }

    public MWContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    private void setContainerPolicy(MWContainerPolicy mWContainerPolicy) {
        MWContainerPolicy mWContainerPolicy2 = this.containerPolicy;
        this.containerPolicy = mWContainerPolicy;
        this.firePropertyChanged("containerPolicy", mWContainerPolicy2, mWContainerPolicy);
    }

    public MWMapContainerPolicy setMapContainerPolicy() {
        if (this.containerPolicy instanceof MWMapContainerPolicy) {
            return (MWMapContainerPolicy)this.containerPolicy;
        }
        MWMapContainerPolicy mWMapContainerPolicy = new MWMapContainerPolicy(this);
        this.setContainerPolicy(mWMapContainerPolicy);
        return mWMapContainerPolicy;
    }

    public MWCollectionContainerPolicy setCollectionContainerPolicy() {
        if (this.containerPolicy instanceof MWCollectionContainerPolicy) {
            return (MWCollectionContainerPolicy)this.containerPolicy;
        }
        MWCollectionContainerPolicy mWCollectionContainerPolicy = new MWCollectionContainerPolicy(this);
        this.setContainerPolicy(mWCollectionContainerPolicy);
        return mWCollectionContainerPolicy;
    }

    public MWListContainerPolicy setListContainerPolicy() {
        if (this.containerPolicy instanceof MWListContainerPolicy) {
            return (MWListContainerPolicy)this.containerPolicy;
        }
        MWListContainerPolicy mWListContainerPolicy = new MWListContainerPolicy(this);
        this.setContainerPolicy(mWListContainerPolicy);
        return mWListContainerPolicy;
    }

    public MWSetContainerPolicy setSetContainerPolicy() {
        if (this.containerPolicy instanceof MWSetContainerPolicy) {
            return (MWSetContainerPolicy)this.containerPolicy;
        }
        MWSetContainerPolicy mWSetContainerPolicy = new MWSetContainerPolicy(this);
        this.setContainerPolicy(mWSetContainerPolicy);
        return mWSetContainerPolicy;
    }

    public Iterator candidateKeyMethods(Filter filter) {
        if (this.getReferenceDescriptor() != null) {
            return new FilteringIterator(this.getReferenceDescriptor().getMWClass().allInstanceMethods(), filter);
        }
        return NullIterator.instance();
    }

    protected void initializeFromMWCollectionMapping(MWCollectionMapping mWCollectionMapping) {
        super.initializeFromMWCollectionMapping(mWCollectionMapping);
        ListIterator listIterator = this.orderings();
        while (listIterator.hasNext()) {
            MWCollectionOrdering mWCollectionOrdering = (MWCollectionOrdering)listIterator.next();
            MWCollectionOrdering mWCollectionOrdering2 = mWCollectionMapping.addOrdering(mWCollectionOrdering.getQueryKey());
            mWCollectionOrdering2.setAscending(mWCollectionOrdering.isAscending());
        }
        this.getContainerPolicy().getDefaultingContainerClass().setContainerClass(mWCollectionMapping.getContainerPolicy().getDefaultingContainerClass().getContainerClass());
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping mWIndirectableContainerMapping) {
        super.initializeFromMWIndirectableContainerMapping(mWIndirectableContainerMapping);
        if (mWIndirectableContainerMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    public ListIterator orderings() {
        return new CloneListIterator(this.orderings);
    }

    public int orderingsSize() {
        return this.orderings.size();
    }

    public int indexOfOrdering(MWCollectionOrdering mWCollectionOrdering) {
        return this.orderings.indexOf(mWCollectionOrdering);
    }

    public void moveOrderingUp(MWCollectionOrdering mWCollectionOrdering) {
        int n = this.indexOfOrdering(mWCollectionOrdering);
        this.removeOrdering(n);
        this.addOrdering(n - 1, mWCollectionOrdering);
    }

    public void moveOrderingDown(MWCollectionOrdering mWCollectionOrdering) {
        int n = this.indexOfOrdering(mWCollectionOrdering);
        this.removeOrdering(mWCollectionOrdering);
        this.addOrdering(n + 1, mWCollectionOrdering);
    }

    public MWCollectionOrdering addOrdering(MWQueryKey mWQueryKey) {
        MWCollectionOrdering mWCollectionOrdering = new MWCollectionOrdering(this);
        mWCollectionOrdering.setQueryKey(mWQueryKey);
        this.addOrdering(this.orderingsSize(), mWCollectionOrdering);
        return mWCollectionOrdering;
    }

    private void addOrdering(int n, MWCollectionOrdering mWCollectionOrdering) {
        this.addItemToList(n, mWCollectionOrdering, this.orderings, ORDERINGS_LIST);
    }

    public void removeOrdering(MWCollectionOrdering mWCollectionOrdering) {
        this.removeOrdering(this.orderings.indexOf(mWCollectionOrdering));
    }

    public void removeOrdering(int n) {
        this.removeItemFromList(n, this.orderings, ORDERINGS_LIST);
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    public void setReferenceDescriptor(MWDescriptor mWDescriptor) {
        super.setReferenceDescriptor(mWDescriptor);
        this.getContainerPolicy().referenceDescriptorChanged(mWDescriptor);
    }

    public boolean usesAnyOf() {
        return true;
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return false;
    }

    public boolean usesTransparentIndirection() {
        return this.getIndirectionType() == "transparentIndirection";
    }

    public boolean isCollectionMapping() {
        return true;
    }

    protected void forceEjb20Indirection() {
        super.forceEjb20Indirection();
        this.setUseTransparentIndirection();
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection collection = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator iterator = this.getReference().columnPairs();
            while (iterator.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)iterator.next();
                collection.add(new MWAbstractTableReferenceMapping.ColumnPairAggregateRuntimeFieldNameGenerator(this, mWColumnPair, false));
            }
        }
        return collection;
    }

    protected boolean fieldIsWritten(MWColumnPair mWColumnPair) {
        return false;
    }

    public DatabaseMapping runtimeMapping() {
        CollectionMapping collectionMapping = (CollectionMapping)super.runtimeMapping();
        if (this.usesTransparentIndirection()) {
            collectionMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else if (this.usesValueHolderIndirection()) {
            collectionMapping.useBasicIndirection();
        } else {
            collectionMapping.dontUseIndirection();
        }
        collectionMapping.setContainerPolicy(this.containerPolicy.runtimeContainerPolicy());
        if (this.getContainerPolicy().usesSorting() && this.getContainerPolicy().getComparatorClass() != null) {
            collectionMapping.useSortedSetClassName(this.getContainerPolicy().getDefaultingContainerClass().getContainerClass().getName(), this.getContainerPolicy().getComparatorClass().getName());
        }
        ListIterator listIterator = this.orderings();
        while (listIterator.hasNext()) {
            ((MWCollectionOrdering)listIterator.next()).adjustRuntimeMapping(collectionMapping);
        }
        return collectionMapping;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkContainerClassIsValidForTransparentIndirection(list);
        this.addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(list);
    }

    public void addWrittenFieldsTo(Collection collection) {
    }

    protected void mappingAndVariableDontUseIndirectionTest(List list) {
        if (!this.usesValueHolderIndirection() && this.getInstanceVariable().isValueHolder()) {
            list.add(this.buildProblem("0550"));
        }
    }

    protected void mappingAndVariableUseIndirectionTest(List list) {
        if (!this.getProject().usesWeaving() && this.usesValueHolderIndirection() && !this.getInstanceVariable().isValueHolder()) {
            list.add(this.buildProblem("0551"));
        }
    }

    private void checkContainerClassIsValidForTransparentIndirection(List list) {
        if (!this.usesTransparentIndirection()) {
            return;
        }
        MWClass mWClass = this.getContainerPolicy().getDefaultingContainerClass().getContainerClass();
        if (mWClass != null && !mWClass.mightBeAssignableToIndirectContainer()) {
            list.add(this.buildProblem("0560"));
        }
    }

    private void addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(List list) {
        if (this.maintainsBidirectionalRelationship() && (this.usesNoIndirection() || this.usesValueHolderIndirection())) {
            list.add(this.buildProblem("0469"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWCollectionMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("containerPolicy");
        xMLCompositeObjectMapping.setReferenceClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        xMLCompositeObjectMapping.setXPath("container-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(ORDERINGS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWCollectionOrdering.class);
        xMLCompositeCollectionMapping.setXPath("orderings/ordering");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }
}

