/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWEisReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisOneToManyMapping
extends MWEisReferenceMapping
implements MWIndirectableContainerMapping,
MWXpathContext,
MWMapContainerMapping {
    private volatile String foreignKeyLocation;
    public static final String FOREIGN_KEY_LOCATION_PROPERTY = "foreignKeyLocation";
    public static final String KEYS_ON_TARGET = "keysOnTarget";
    public static final String KEYS_ON_SOURCE = "keysOnSource";
    private MWXmlField foreignKeyGroupingElement;
    private volatile MWContainerPolicy containerPolicy;
    private volatile MWEisInteraction deleteAllInteraction;

    private MWEisOneToManyMapping() {
    }

    public MWEisOneToManyMapping(MWEisDescriptor mWEisDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWEisDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.foreignKeyLocation = KEYS_ON_TARGET;
        this.foreignKeyGroupingElement = new MWXmlField(this);
        this.deleteAllInteraction = new MWEisInteraction(this);
    }

    protected boolean requiresSelectionInteraction() {
        return true;
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (mWClassAttribute.isValueHolder()) {
            this.containerPolicy = mWClassAttribute.getValueType().isAssignableToMap() ? new MWMapContainerPolicy(this) : (mWClassAttribute.getValueType().isAssignableToList() ? new MWListContainerPolicy(this) : (mWClassAttribute.getValueType().isAssignableToSet() ? new MWSetContainerPolicy(this) : (mWClassAttribute.getValueType().isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
            this.setUseValueHolderIndirection();
        } else {
            this.containerPolicy = mWClassAttribute.isAssignableToMap() ? new MWMapContainerPolicy(this) : (mWClassAttribute.isAssignableToList() ? new MWListContainerPolicy(this) : (mWClassAttribute.isAssignableToSet() ? new MWSetContainerPolicy(this) : (mWClassAttribute.isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
            this.setUseTransparentIndirection();
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.foreignKeyGroupingElement);
        list.add(this.containerPolicy);
        list.add(this.deleteAllInteraction);
    }

    public boolean foreignKeysAreOnSource() {
        return this.foreignKeyLocation == KEYS_ON_SOURCE;
    }

    public boolean foreignKeysAreOnTarget() {
        return this.foreignKeyLocation == KEYS_ON_TARGET;
    }

    public void setForeignKeysOnSource() {
        this.setForeignKeyLocation(KEYS_ON_SOURCE);
    }

    public void setForeignKeysOnTarget() {
        this.setForeignKeyLocation(KEYS_ON_TARGET);
        this.getForeignKeyGroupingElement().setXpath("");
        this.clearXmlFieldPairs();
    }

    private void setForeignKeyLocation(String string) {
        String string2 = this.foreignKeyLocation;
        this.foreignKeyLocation = string;
        this.firePropertyChanged(FOREIGN_KEY_LOCATION_PROPERTY, string2, string);
    }

    public MWXmlField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public MWContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    private void setContainerPolicy(MWContainerPolicy mWContainerPolicy) {
        MWContainerPolicy mWContainerPolicy2 = this.containerPolicy;
        this.containerPolicy = mWContainerPolicy;
        this.firePropertyChanged("containerPolicy", mWContainerPolicy2, mWContainerPolicy);
    }

    public MWMapContainerPolicy setMapContainerPolicy() {
        if (this.containerPolicy instanceof MWMapContainerPolicy) {
            return (MWMapContainerPolicy)this.containerPolicy;
        }
        MWMapContainerPolicy mWMapContainerPolicy = new MWMapContainerPolicy(this);
        this.setContainerPolicy(mWMapContainerPolicy);
        return mWMapContainerPolicy;
    }

    public MWCollectionContainerPolicy setCollectionContainerPolicy() {
        if (this.containerPolicy instanceof MWCollectionContainerPolicy) {
            return (MWCollectionContainerPolicy)this.containerPolicy;
        }
        MWCollectionContainerPolicy mWCollectionContainerPolicy = new MWCollectionContainerPolicy(this);
        this.setContainerPolicy(mWCollectionContainerPolicy);
        return mWCollectionContainerPolicy;
    }

    public MWListContainerPolicy setListContainerPolicy() {
        if (this.containerPolicy instanceof MWListContainerPolicy) {
            return (MWListContainerPolicy)this.containerPolicy;
        }
        MWListContainerPolicy mWListContainerPolicy = new MWListContainerPolicy(this);
        this.setContainerPolicy(mWListContainerPolicy);
        return mWListContainerPolicy;
    }

    public MWSetContainerPolicy setSetContainerPolicy() {
        if (this.containerPolicy instanceof MWSetContainerPolicy) {
            return (MWSetContainerPolicy)this.containerPolicy;
        }
        MWSetContainerPolicy mWSetContainerPolicy = new MWSetContainerPolicy(this);
        this.setContainerPolicy(mWSetContainerPolicy);
        return mWSetContainerPolicy;
    }

    public Iterator candidateKeyMethods(Filter filter) {
        return this.getReferenceDescriptor() == null ? NullIterator.instance() : new FilteringIterator(this.getReferenceDescriptor().getMWClass().allInstanceMethods(), filter);
    }

    public MWEisInteraction getDeleteAllInteraction() {
        return this.deleteAllInteraction;
    }

    public MWXmlField firstMappedXmlField() {
        return this.getForeignKeyGroupingElement().isResolved() ? this.getForeignKeyGroupingElement() : super.firstMappedXmlField();
    }

    public MWSchemaContextComponent schemaContext(MWXmlField mWXmlField) {
        return this.eisDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField mWXmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return true;
            }

            public boolean mayUseComplexData() {
                return true;
            }

            public boolean mayUseSimpleData() {
                return false;
            }
        };
    }

    public boolean sourceFieldMayUseCollectionXpath() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return this.getIndirectionType() == "transparentIndirection";
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkFieldPairs(list);
        this.checkGroupingElement(list);
        this.checkGroupingElementForeignKeys(list);
        this.checkSelectionInteraction(list);
        this.checkDeleteAllInteraction(list);
        this.addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(list);
    }

    private void checkFieldPairs(List list) {
        if (this.foreignKeysAreOnSource() && this.xmlFieldPairsSize() == 0) {
            list.add(this.buildProblem("0600"));
        }
    }

    private void checkGroupingElement(List list) {
        if (this.xmlFieldPairsSize() > 1 && this.getForeignKeyGroupingElement() == null) {
            list.add(this.buildProblem("0601"));
        }
    }

    private void checkGroupingElementForeignKeys(List list) {
        MWXmlField mWXmlField = this.getForeignKeyGroupingElement();
        if (!mWXmlField.isSpecified() || !mWXmlField.isResolved()) {
            return;
        }
        ListIterator listIterator = this.xmlFieldPairs();
        while (listIterator.hasNext()) {
            MWXmlField mWXmlField2 = ((MWXmlFieldPair)listIterator.next()).getSourceXmlField();
            if (!mWXmlField2.isSpecified() || mWXmlField.containsXmlField(mWXmlField2)) continue;
            list.add(this.buildProblem("0602"));
            break;
        }
    }

    private void checkSelectionInteraction(List list) {
        if (!this.getSelectionInteraction().isSpecified()) {
            list.add(this.buildProblem("0603"));
        }
    }

    private void checkDeleteAllInteraction(List list) {
        if (this.getDeleteAllInteraction().isSpecified() && !this.isPrivateOwned()) {
            list.add(this.buildProblem("0604"));
        }
    }

    private void addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(List list) {
        if (this.maintainsBidirectionalRelationship() && (this.usesNoIndirection() || this.usesValueHolderIndirection())) {
            list.add(this.buildProblem("0469"));
        }
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWEisOneToManyMapping(this);
    }

    public void initializeFromMWCompositeCollectionMapping(MWCompositeCollectionMapping mWCompositeCollectionMapping) {
        super.initializeFromMWCompositeCollectionMapping(mWCompositeCollectionMapping);
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping mWIndirectableContainerMapping) {
        super.initializeFromMWIndirectableContainerMapping(mWIndirectableContainerMapping);
        if (mWIndirectableContainerMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    public void resolveXpaths() {
        super.resolveXpaths();
        this.foreignKeyGroupingElement.resolveXpaths();
    }

    public void schemaChanged(SchemaChange schemaChange) {
        super.schemaChanged(schemaChange);
        this.foreignKeyGroupingElement.schemaChanged(schemaChange);
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new EISOneToManyMapping();
    }

    public DatabaseMapping runtimeMapping() {
        EISOneToManyMapping eISOneToManyMapping = (EISOneToManyMapping)super.runtimeMapping();
        if (this.getForeignKeyGroupingElement().isSpecified()) {
            eISOneToManyMapping.setForeignKeyGroupingElement(this.getForeignKeyGroupingElement().runtimeField().getName());
        }
        ListIterator listIterator = this.xmlFieldPairs();
        while (listIterator.hasNext()) {
            ((MWXmlFieldPair)listIterator.next()).addRuntimeForeignKeyField(eISOneToManyMapping, this.getForeignKeyGroupingElement());
        }
        if (this.usesTransparentIndirection()) {
            eISOneToManyMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        }
        eISOneToManyMapping.setContainerPolicy(this.getContainerPolicy().runtimeContainerPolicy());
        if (this.getDeleteAllInteraction().isSpecified()) {
            eISOneToManyMapping.setDeleteAllCall((Call)this.getDeleteAllInteraction().runtimeInteraction());
        }
        return eISOneToManyMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWEisOneToManyMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWEisReferenceMapping.class);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)KEYS_ON_TARGET, (Object)KEYS_ON_TARGET);
        objectTypeConverter.addConversionValue((Object)KEYS_ON_SOURCE, (Object)KEYS_ON_SOURCE);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(FOREIGN_KEY_LOCATION_PROPERTY);
        xMLDirectMapping.setXPath("foreign-key-location/text()");
        xMLDirectMapping.setNullValue((Object)KEYS_ON_SOURCE);
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("foreignKeyGroupingElement");
        xMLCompositeObjectMapping.setReferenceClass(MWXmlField.class);
        xMLCompositeObjectMapping.setGetMethodName("getGroupingElementForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setGroupingElementForTopLink");
        xMLCompositeObjectMapping.setXPath("foreign-key-grouping-element");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("containerPolicy");
        xMLCompositeObjectMapping2.setReferenceClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        xMLCompositeObjectMapping2.setXPath("container-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("deleteAllInteraction");
        xMLCompositeObjectMapping3.setReferenceClass(MWEisInteraction.class);
        xMLCompositeObjectMapping3.setXPath("delete-all-interaction");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        return xMLDescriptor;
    }

    private MWXmlField getGroupingElementForTopLink() {
        return "".equals(this.foreignKeyGroupingElement.getXpath()) ? null : this.foreignKeyGroupingElement;
    }

    private void setGroupingElementForTopLink(MWXmlField mWXmlField) {
        this.foreignKeyGroupingElement = mWXmlField == null ? new MWXmlField(this) : mWXmlField;
    }
}

