/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWAttributeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethod
extends MWModel
implements MWModifiable {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWModifier modifier;
    public static final String SIGNATURE_PROPERTY = "signature";
    private MWTypeDeclaration returnTypeDeclaration;
    public static final String RETURN_TYPE_PROPERTY = "returnType";
    public static final String RETURN_TYPE_DIMENSIONALITY_PROPERTY = "returnTypeDimensionality";
    private List methodParameters;
    public static final String METHOD_PARAMETERS_LIST = "methodParameters";
    private Collection exceptionTypeHandles;
    public static final String EXCEPTION_TYPES_COLLECTION = "exceptionTypes";
    private MWHandle.NodeReferenceScrubber exceptionTypeScrubber;
    private volatile boolean constructor;
    public static final String CONSTRUCTOR_PROPERTY = "constructor";
    private MWAttributeHandle accessedAttributeHandle;
    private static final MWClass[] EMPTY_TYPE_ARRAY = new MWClass[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int ALLOWED_MODIFIERS_FLAGS = 3386;

    private MWMethod() {
    }

    MWMethod(MWClass mWClass, String string) {
        super(mWClass);
        this.name = string;
        this.setConstructor(string.equals(this.getDeclaringType().shortName()));
    }

    MWMethod(MWClass mWClass, String string, MWClass mWClass2) {
        this(mWClass, string);
        this.setReturnType(mWClass2);
    }

    MWMethod(MWClass mWClass, String string, MWClass mWClass2, int n) {
        this(mWClass, string);
        this.setReturnTypeDeclaration(mWClass2, n);
    }

    MWMethod(MWClass mWClass, ExternalConstructor externalConstructor) {
        this(mWClass, MWMethod.shortNameFor(externalConstructor));
        this.setConstructor(true);
        this.initializeParameterTypeDeclarations(externalConstructor.getParameterTypes());
        this.refresh(externalConstructor);
    }

    MWMethod(MWClass mWClass, ExternalMethod externalMethod) {
        this(mWClass, externalMethod.getName());
        this.setConstructor(false);
        this.initializeParameterTypeDeclarations(externalMethod.getParameterTypes());
        this.refresh(externalMethod);
    }

    private static String shortNameFor(ExternalConstructor externalConstructor) {
        return ClassTools.shortNameForClassNamed(externalConstructor.getName());
    }

    static MWMethod buildZeroArgumentConstructor(MWClass mWClass) {
        MWMethod mWMethod = new MWMethod(mWClass, mWClass.shortName());
        mWMethod.setConstructor(true);
        return mWMethod;
    }

    protected void initialize() {
        super.initialize();
        this.modifier = new MWModifier(this);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.returnTypeDeclaration = this.buildDefaultReturnTypeDeclaration();
        this.methodParameters = new Vector();
        this.exceptionTypeHandles = new Vector();
        this.accessedAttributeHandle = new MWAttributeHandle(this, this.buildAccessedAttributeScrubber());
    }

    private void initializeParameterTypeDeclarations(ExternalClassDescription[] externalClassDescriptionArray) {
        int n = externalClassDescriptionArray.length;
        for (int i = 0; i < n; ++i) {
            this.methodParameters.add(this.buildMethodParameter(externalClassDescriptionArray[i]));
        }
    }

    public MWClass getDeclaringType() {
        return (MWClass)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.setConstructor(string.equals(this.getDeclaringType().shortName()));
            this.getProject().nodeRenamed(this);
            this.firePropertyChanged(SIGNATURE_PROPERTY, NAME_PROPERTY);
        }
    }

    public MWModifier getModifier() {
        return this.modifier;
    }

    MWTypeDeclaration getReturnTypeDeclaration() {
        return this.returnTypeDeclaration;
    }

    public MWClass getReturnType() {
        if (this.isConstructor()) {
            throw new IllegalStateException("A constructor \"" + this + "\" does not have a return type.");
        }
        return this.returnTypeDeclaration.getType();
    }

    public int getReturnTypeDimensionality() {
        if (this.isConstructor()) {
            throw new IllegalStateException("A constructor \"" + this + "\" does not have a return type.");
        }
        return this.returnTypeDeclaration.getDimensionality();
    }

    private void setReturnTypeDeclaration(MWTypeDeclaration mWTypeDeclaration) {
        this.returnTypeDeclaration = mWTypeDeclaration;
    }

    public void setReturnType(MWClass mWClass) {
        MWClass mWClass2 = this.getReturnType();
        this.returnTypeDeclaration.setType(mWClass);
        this.firePropertyChanged(RETURN_TYPE_PROPERTY, mWClass2, mWClass);
        if (this.attributeValueHasChanged(mWClass2, mWClass)) {
            if (mWClass.isVoid()) {
                this.setReturnTypeDimensionality(0);
            }
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_PROPERTY);
        }
    }

    private void setReturnTypeDeclaration(MWClass mWClass, int n) {
        this.setReturnType(mWClass);
        this.setReturnTypeDimensionality(n);
    }

    public void setReturnTypeDimensionality(int n) {
        int n2 = this.getReturnTypeDimensionality();
        this.returnTypeDeclaration.setDimensionality(n);
        this.firePropertyChanged(RETURN_TYPE_DIMENSIONALITY_PROPERTY, n2, n);
        if (n2 != n) {
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_DIMENSIONALITY_PROPERTY);
        }
    }

    public ListIterator methodParameters() {
        return new CloneListIterator(this.methodParameters){

            protected void remove(int n) {
                MWMethod.this.removeMethodParameter(n);
            }

            public String toString() {
                return "MWMethod.methodParameters()";
            }
        };
    }

    public int methodParametersSize() {
        return this.methodParameters.size();
    }

    public MWMethodParameter getMethodParameter(int n) {
        return (MWMethodParameter)this.methodParameters.get(n);
    }

    public MWMethodParameter getMethodParameter() {
        if (this.methodParametersSize() != 1) {
            throw new IllegalStateException("This method \"" + this + "\" contains more than one parameter type declaration.");
        }
        return this.getMethodParameter(0);
    }

    public MWMethodParameter addMethodParameter(MWClass mWClass) {
        return this.addMethodParameter(mWClass, 0);
    }

    public MWMethodParameter addMethodParameter(MWClass mWClass, int n) {
        return this.addMethodParameter(this.buildMethodParameter(mWClass, n));
    }

    private MWMethodParameter addMethodParameter(MWMethodParameter mWMethodParameter) {
        if (mWMethodParameter.getType().isVoid()) {
            throw new IllegalArgumentException("Cannot add a parameter with type void");
        }
        this.addItemToList(mWMethodParameter, this.methodParameters, METHOD_PARAMETERS_LIST);
        this.parameterChanged();
        return mWMethodParameter;
    }

    public void removeMethodParameter(int n) {
        this.removeMethodParameter(this.getMethodParameter(n));
    }

    public void removeMethodParameter(MWMethodParameter mWMethodParameter) {
        this.removeItemFromList(mWMethodParameter, this.methodParameters, METHOD_PARAMETERS_LIST);
        this.parameterChanged();
    }

    public void removeMethodParameters(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeMethodParameter((MWMethodParameter)iterator.next());
        }
    }

    public void removeMethodParameters(Collection collection) {
        this.removeMethodParameters(collection.iterator());
    }

    public void clearMethodParameters() {
        this.removeMethodParameters(this.methodParameters());
    }

    void parameterChanged() {
        this.getProject().nodeRenamed(this);
        this.firePropertyChanged(SIGNATURE_PROPERTY, METHOD_PARAMETERS_LIST);
    }

    private Iterator exceptionTypeHandles() {
        return new CloneIterator(this.exceptionTypeHandles){

            protected void remove(Object object) {
                MWMethod.this.removeExceptionTypeHandle((MWClassHandle)object);
            }

            public String toString() {
                return "MWMethod.exceptionTypeHandles()";
            }
        };
    }

    void removeExceptionTypeHandle(MWClassHandle mWClassHandle) {
        this.exceptionTypeHandles.remove(mWClassHandle);
        this.fireItemRemoved(EXCEPTION_TYPES_COLLECTION, mWClassHandle.getType());
    }

    public Iterator exceptionTypes() {
        return new TransformationIterator(this.exceptionTypeHandles()){

            protected Object transform(Object object) {
                return ((MWClassHandle)object).getType();
            }

            public String toString() {
                return "MWMethod.exceptionTypes()";
            }
        };
    }

    public int exceptionTypesSize() {
        return this.exceptionTypeHandles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsExceptionType(MWClass mWClass) {
        Collection collection = this.exceptionTypeHandles;
        synchronized (collection) {
            Iterator iterator = this.exceptionTypeHandles.iterator();
            while (iterator.hasNext()) {
                if (((MWClassHandle)iterator.next()).getType() != mWClass) continue;
                return true;
            }
            return false;
        }
    }

    public void addExceptionType(MWClass mWClass) {
        if (!this.containsExceptionType(mWClass)) {
            this.exceptionTypeHandles.add(new MWClassHandle(this, mWClass, this.exceptionTypeScrubber()));
            this.fireItemAdded(EXCEPTION_TYPES_COLLECTION, mWClass);
        }
    }

    public void addExceptionTypes(Collection collection) {
        this.addExceptionTypes(collection.iterator());
    }

    public void addExceptionTypes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addExceptionType((MWClass)iterator.next());
        }
    }

    public void removeExceptionType(MWClass mWClass) {
        Iterator iterator = this.exceptionTypes();
        while (iterator.hasNext()) {
            if (iterator.next() != mWClass) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWClass.toString());
    }

    public void removeExceptionTypes(Collection collection) {
        this.removeExceptionTypes(collection.iterator());
    }

    public void removeExceptionTypes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeExceptionType((MWClass)iterator.next());
        }
    }

    public void clearExceptionTypes() {
        Iterator iterator = this.exceptionTypeHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public void setConstructor(boolean bl) {
        boolean bl2 = this.constructor;
        this.constructor = bl;
        this.firePropertyChanged(CONSTRUCTOR_PROPERTY, bl2, bl);
        if (bl2 != bl) {
            if (bl) {
                this.setReturnTypeDeclaration(null);
                this.getModifier().setAbstract(false);
                this.getModifier().setFinal(false);
                this.getModifier().setSynchronized(false);
                this.getModifier().setStatic(false);
                this.getModifier().setNative(false);
            } else {
                this.setReturnTypeDeclaration(this.buildDefaultReturnTypeDeclaration());
            }
            this.allowedModifiersChanged();
            this.firePropertyChanged(SIGNATURE_PROPERTY, CONSTRUCTOR_PROPERTY);
        }
    }

    MWClassAttribute getAccessedAttribute() {
        return this.accessedAttributeHandle.getAttribute();
    }

    void setAccessedAttribute(MWClassAttribute mWClassAttribute) {
        if (this.getAccessedAttribute() != null) {
            this.getAccessedAttribute().removeAccessorMethod(this);
        }
        this.accessedAttributeHandle.setAttribute(mWClassAttribute);
    }

    public boolean supportsAbstract() {
        return true;
    }

    public boolean canBeSetAbstract() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getModifier().isPrivate()) {
            return false;
        }
        if (this.getModifier().isStatic()) {
            return false;
        }
        if (this.isFinal()) {
            return false;
        }
        if (this.getModifier().isNative()) {
            return false;
        }
        if (this.isStrict()) {
            return false;
        }
        if (this.getModifier().isSynchronized()) {
            return false;
        }
        return this.getDeclaringType().isAbstract();
    }

    public boolean canBeSetFinal() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    public boolean supportsInterface() {
        return false;
    }

    public boolean canBeSetInterface() {
        return false;
    }

    public boolean supportsNative() {
        return true;
    }

    public boolean canBeSetNative() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.isAbstract()) {
            return false;
        }
        return !this.isStrict();
    }

    public boolean canBeSetPackage() {
        return true;
    }

    public boolean canBeSetPrivate() {
        return !this.isAbstract();
    }

    public boolean canBeSetProtected() {
        return true;
    }

    public boolean canBeSetPublic() {
        return true;
    }

    public boolean canBeSetStatic() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    public boolean supportsStrict() {
        return true;
    }

    public boolean canBeSetStrict() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.isAbstract()) {
            return false;
        }
        return !this.getModifier().isNative();
    }

    public boolean supportsSynchronized() {
        return true;
    }

    public boolean canBeSetSynchronized() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    public boolean supportsTransient() {
        return false;
    }

    public boolean canBeSetTransient() {
        return false;
    }

    public boolean supportsVolatile() {
        return false;
    }

    public boolean canBeSetVolatile() {
        return false;
    }

    public void modifierChanged(int n, int n2) {
        this.firePropertyChanged("modifierCode", n, n2);
        this.firePropertyChanged(SIGNATURE_PROPERTY, "modifier");
        if (MWModifier.anyFlagsAreDifferent(3386, n, n2)) {
            this.allowedModifiersChanged();
        }
    }

    void allowedModifiersChanged() {
        this.modifier.allowedModifiersChanged();
    }

    public void accessLevelChanged(String string, String string2) {
        this.firePropertyChanged("modifierAccessLevel", string, string2);
    }

    boolean hasSameSignatureAs(ExternalConstructor externalConstructor) {
        if (!this.isConstructor()) {
            return false;
        }
        String string = MWMethod.shortNameFor(externalConstructor);
        return this.hasSameSignatureAs(string, externalConstructor.getParameterTypes());
    }

    boolean hasSameSignatureAs(ExternalMethod externalMethod) {
        if (this.isConstructor()) {
            return false;
        }
        return this.hasSameSignatureAs(externalMethod.getName(), externalMethod.getParameterTypes());
    }

    private boolean hasSameSignatureAs(String string, ExternalClassDescription[] externalClassDescriptionArray) {
        if (!this.getName().equals(string)) {
            return false;
        }
        int n = externalClassDescriptionArray.length;
        if (this.methodParametersSize() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getMethodParameter(i).hasSameSignatureAs(externalClassDescriptionArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameSignatureAs(MWMethod mWMethod) {
        if (!this.getName().equals(mWMethod.getName())) {
            return false;
        }
        int n = mWMethod.methodParametersSize();
        if (this.methodParametersSize() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getMethodParameter(i).hasSameSignatureAs(mWMethod.getMethodParameter(i))) continue;
            return false;
        }
        return true;
    }

    boolean hasSignature(String string) {
        return this.hasSignature(string, EMPTY_TYPE_ARRAY, EMPTY_INT_ARRAY);
    }

    boolean hasSignature(String string, MWClass mWClass, int n) {
        return this.hasSignature(string, new MWClass[]{mWClass}, new int[]{n});
    }

    boolean hasSignature(String string, MWClass mWClass, int n, MWClass mWClass2, int n2) {
        return this.hasSignature(string, new MWClass[]{mWClass, mWClass2}, new int[]{n, n2});
    }

    boolean hasSignature(String string, MWClass[] mWClassArray, int[] nArray) {
        if (mWClassArray.length != nArray.length) {
            throw new IllegalArgumentException("arrays are different lengths: " + mWClassArray.length + " vs. " + nArray.length);
        }
        if (!this.getName().equals(string)) {
            return false;
        }
        if (this.methodParametersSize() != mWClassArray.length) {
            return false;
        }
        int n = mWClassArray.length;
        while (n-- > 0) {
            MWMethodParameter mWMethodParameter = this.getMethodParameter(n);
            if (mWMethodParameter.getType() != mWClassArray[n]) {
                return false;
            }
            if (mWMethodParameter.getDimensionality() == nArray[n]) continue;
            return false;
        }
        return true;
    }

    public boolean isAbstract() {
        return this.getModifier().isAbstract() || this.getDeclaringType().isInterface();
    }

    public boolean isStatic() {
        return this.getModifier().isStatic();
    }

    public boolean isFinal() {
        return this.getModifier().isFinal() || this.getModifier().isPrivate() || this.getDeclaringType().getModifier().isFinal();
    }

    public boolean isStrict() {
        return this.getModifier().isStrict() || this.getDeclaringType().isStrict();
    }

    public boolean isInstanceMethod() {
        return !this.isConstructor() && !this.isStatic();
    }

    public boolean returnTypeIsVoid() {
        return this.returnTypeDeclaration.isVoid();
    }

    public boolean returnTypeIsArray() {
        return this.returnTypeDeclaration.isArray();
    }

    public boolean throwsException(MWClass mWClass) {
        return this.containsExceptionType(mWClass);
    }

    private boolean looksLikeAGetMethod() {
        return this.isInstanceMethod() && !this.returnTypeIsVoid() && this.methodParametersSize() == 0 && this.getName().startsWith("get");
    }

    public boolean isEjb20GetMethod() {
        return this.looksLikeAGetMethod() && this.isAbstract();
    }

    private boolean looksLikeASetMethod() {
        return this.isInstanceMethod() && this.returnTypeIsVoid() && this.methodParametersSize() == 1 && this.getName().startsWith("set");
    }

    boolean isEjb20SetMethodFor(MWMethod mWMethod) {
        return this.looksLikeASetMethod() && this.isAbstract() && this.getName().endsWith(mWMethod.getName().substring(3)) && this.methodParametersSize() == 1 && this.getMethodParameter(0).matches(mWMethod.returnTypeDeclaration);
    }

    public boolean isAccessor() {
        return this.getAccessedAttribute() != null;
    }

    public boolean isZeroArgumentConstructor() {
        return this.isConstructor() && this.methodParametersSize() == 0;
    }

    boolean isCandidateTopLinkGetMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && !this.returnTypeDeclaration.isVoid();
    }

    boolean isCandidateTopLinkSetMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 1;
    }

    boolean isCandidateGetMethodFor(MWClassAttribute mWClassAttribute) {
        return this.isCandidateGetMethodFor(mWClassAttribute.getType(), mWClassAttribute.getDimensionality());
    }

    boolean isCandidateGetMethodFor(MWClass mWClass) {
        return this.isCandidateGetMethodFor(mWClass, 0);
    }

    boolean isCandidateGetMethodFor(MWClass mWClass, int n) {
        return this.isZeroArgumentInstanceMethodWithCompatibleReturnType(mWClass, n);
    }

    private boolean isZeroArgumentInstanceMethodWithCompatibleReturnType(MWClass mWClass, int n) {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(mWClass, n);
    }

    boolean isCandidateSetMethodFor(MWClassAttribute mWClassAttribute) {
        return this.isCandidateSetMethodFor(mWClassAttribute.getType(), mWClassAttribute.getDimensionality());
    }

    boolean isCandidateSetMethodFor(MWClass mWClass) {
        return this.isCandidateSetMethodFor(mWClass, 0);
    }

    boolean isCandidateSetMethodFor(MWClass mWClass, int n) {
        return this.isInstanceMethodWithCompatibleArgument(mWClass, n);
    }

    private boolean isInstanceMethodWithCompatibleArgument(MWClass mWClass, int n) {
        return this.isInstanceMethod() && this.methodParametersSize() == 1 && this.getMethodParameter().mightBeAssignableFrom(mWClass, n);
    }

    boolean isCandidateAddMethodFor(MWClass mWClass) {
        return this.isInstanceMethodWithCompatibleArgument(mWClass, 0);
    }

    boolean isCandidateAddMethodFor(MWClass mWClass, MWClass mWClass2) {
        return this.isInstanceMethod() && this.methodParametersSize() == 2 && this.getMethodParameter(0).mightBeAssignableFrom(mWClass, 0) && this.getMethodParameter(1).mightBeAssignableFrom(mWClass2, 0);
    }

    boolean isCandidateRemoveMethodFor(MWClass mWClass) {
        return this.isInstanceMethodWithCompatibleArgument(mWClass, 0);
    }

    public boolean isCandidateMapContainerPolicyKeyMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && !this.returnTypeDeclaration.isVoid();
    }

    public boolean isCandidateClassExtractionMethod() {
        return this.isStatic() && this.methodParametersSize() == 1 && this.getMethodParameter().getDimensionality() == 0 && this.getMethodParameter().getType() == this.typeFor(Record.class) && this.returnTypeDeclaration.isAssignableFrom(this.typeFor(Class.class));
    }

    public boolean isCandidateCloneMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(this.getDeclaringType());
    }

    public boolean isCandidateDescriptorEventMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 1 && (this.getMethodParameter().getType() == this.typeFor(DescriptorEvent.class) || this.getMethodParameter().getType() == this.typeFor(Session.class));
    }

    public boolean isCandidateFactoryMethod() {
        return this.isCandidateInstantiationMethod();
    }

    public boolean isCandidateInstantiationMethod() {
        return this.isCandidateInstantiationMethodFor(this.getDeclaringType());
    }

    private boolean isCandidateInstantiationMethodFor(MWClass mWClass) {
        return this.isStatic() && this.isCandidateFactoryInstantiationMethodFor(mWClass);
    }

    public boolean isCandidateFactoryInstantiationMethodFor(MWClass mWClass) {
        return !this.isConstructor() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(mWClass);
    }

    public boolean isCandidateDescriptorAfterLoadMethod() {
        return this.isStatic() && this.methodParametersSize() == 1 && this.getMethodParameter().getDimensionality() == 0 && this.getMethodParameter().getType() == this.typeFor(ClassDescriptor.class);
    }

    public boolean isCandidateAttributeTransformerMethod() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getReturnType().isVoid()) {
            return false;
        }
        if (this.methodParametersSize() == 1) {
            MWMethodParameter mWMethodParameter = this.getMethodParameter(0);
            if (mWMethodParameter.getDimensionality() == 0) {
                return mWMethodParameter.getType().isAssignableTo(this.typeFor(Record.class));
            }
            return false;
        }
        if (this.methodParametersSize() == 2) {
            MWMethodParameter mWMethodParameter = this.getMethodParameter(0);
            MWMethodParameter mWMethodParameter2 = this.getMethodParameter(1);
            if (mWMethodParameter.getDimensionality() == 0 && mWMethodParameter2.getDimensionality() == 0) {
                return mWMethodParameter.getType().isAssignableTo(this.typeFor(Record.class)) && mWMethodParameter2.getType() == this.typeFor(Session.class);
            }
            return false;
        }
        return false;
    }

    public boolean isCandidateFieldTransformerMethod() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getReturnType().isVoid()) {
            return false;
        }
        if (this.methodParametersSize() == 0) {
            return true;
        }
        if (this.methodParametersSize() == 1) {
            MWMethodParameter mWMethodParameter = this.getMethodParameter(0);
            if (mWMethodParameter.getDimensionality() == 0) {
                return mWMethodParameter.getType() == this.typeFor(Session.class);
            }
            return false;
        }
        return false;
    }

    NonreflectiveMethodDefinition methodDefinition(MWMethodCodeGenPolicy mWMethodCodeGenPolicy) {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setAccessLevel(this.getModifier().accessLevel());
        nonreflectiveMethodDefinition.setIsConstructor(this.isConstructor());
        nonreflectiveMethodDefinition.setIsAbstract(this.isAbstract());
        if (!this.isConstructor()) {
            nonreflectiveMethodDefinition.setReturnType(this.returnTypeDeclaration.declaration());
        }
        nonreflectiveMethodDefinition.setName(this.getName());
        mWMethodCodeGenPolicy.insertArguments(nonreflectiveMethodDefinition);
        Iterator iterator = this.exceptionTypes();
        while (iterator.hasNext()) {
            nonreflectiveMethodDefinition.addException(((MWClass)iterator.next()).getName());
        }
        mWMethodCodeGenPolicy.insertMethodBody(nonreflectiveMethodDefinition);
        return nonreflectiveMethodDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.modifier);
        if (!this.isConstructor()) {
            list.add(this.returnTypeDeclaration);
        }
        Collection collection = this.methodParameters;
        synchronized (collection) {
            list.addAll(this.methodParameters);
        }
        list.add(this.accessedAttributeHandle);
        collection = this.exceptionTypeHandles;
        synchronized (collection) {
            list.addAll(this.exceptionTypeHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber buildAccessedAttributeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWMethod.this.setAccessedAttribute(null);
            }

            public String toString() {
                return "MWMethod.buildAccessedAttributeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber exceptionTypeScrubber() {
        if (this.exceptionTypeScrubber == null) {
            this.exceptionTypeScrubber = this.buildExceptionTypeScrubber();
        }
        return this.exceptionTypeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildExceptionTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWMethod.this.removeExceptionTypeHandle((MWClassHandle)mWHandle);
            }

            public String toString() {
                return "MWMethod.buildExceptionTypeScrubber()";
            }
        };
    }

    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.isConstructor()) {
            if (this.getDeclaringType() == node) {
                this.setName(this.getDeclaringType().shortName());
            }
        } else if (this.getReturnType() == node) {
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_PROPERTY);
        }
    }

    void refresh(ExternalConstructor externalConstructor) {
        if (!this.hasSameSignatureAs(externalConstructor)) {
            throw new IllegalArgumentException(externalConstructor.toString());
        }
        this.getModifier().refresh(externalConstructor.getModifiers());
        this.refreshExceptionTypes(externalConstructor.getExceptionTypes());
    }

    void refresh(ExternalMethod externalMethod) {
        if (!this.hasSameSignatureAs(externalMethod)) {
            throw new IllegalArgumentException(externalMethod.toString());
        }
        this.getModifier().refresh(externalMethod.getModifiers());
        this.returnTypeDeclaration.refresh(externalMethod.getReturnType());
        this.refreshExceptionTypes(externalMethod.getExceptionTypes());
    }

    private void refreshExceptionTypes(ExternalClassDescription[] externalClassDescriptionArray) {
        Collection collection = CollectionTools.collection(this.exceptionTypes());
        int n = externalClassDescriptionArray.length;
        while (n-- > 0) {
            if (collection.remove(this.typeNamed(externalClassDescriptionArray[n].getName()))) continue;
            this.addExceptionType(this.typeNamed(externalClassDescriptionArray[n].getName()));
        }
        this.removeExceptionTypes(collection);
    }

    private MWMethodParameter buildMethodParameter(ExternalClassDescription externalClassDescription) {
        return new MWMethodParameter(this, externalClassDescription);
    }

    private MWMethodParameter buildMethodParameter(MWClass mWClass, int n) {
        return new MWMethodParameter(this, mWClass, n);
    }

    private MWTypeDeclaration buildDefaultReturnTypeDeclaration() {
        return new MWTypeDeclaration((MWModel)this, this.typeFor(Void.TYPE));
    }

    public int compareTo(Object object) {
        MWMethod mWMethod = null;
        try {
            mWMethod = (MWMethod)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Object \"" + object + "\" must be an instance of MWMethod.");
        }
        if (this.isConstructor() && !mWMethod.isConstructor()) {
            return -1;
        }
        if (!this.isConstructor() && mWMethod.isConstructor()) {
            return 1;
        }
        return super.compareTo(object);
    }

    public String displayString() {
        return this.signature();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.shortSignature());
    }

    public String signature() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printSignatureOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String signatureWithReturnType() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printSignatureWithReturnTypeOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String shortSignature() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printShortSignatureOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String shortSignatureWithReturnType() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printShortSignatureWithReturnTypeOn(stringBuffer);
        return stringBuffer.toString();
    }

    public void printSignatureWithReturnTypeOn(StringBuffer stringBuffer) {
        this.printSignatureOn(stringBuffer);
        this.printReturnTypeOn(stringBuffer, true);
    }

    public void printSignatureOn(StringBuffer stringBuffer) {
        this.printSignatureOn(stringBuffer, true);
    }

    public void printShortSignatureWithReturnTypeOn(StringBuffer stringBuffer) {
        this.printShortSignatureOn(stringBuffer);
        this.printReturnTypeOn(stringBuffer, false);
    }

    public void printShortSignatureOn(StringBuffer stringBuffer) {
        this.printSignatureOn(stringBuffer, false);
    }

    private void printReturnTypeOn(StringBuffer stringBuffer, boolean bl) {
        if (!this.isConstructor()) {
            stringBuffer.append(" : ");
            if (bl) {
                this.returnTypeDeclaration.printSignatureOn(stringBuffer);
            } else {
                this.returnTypeDeclaration.printShortSignatureOn(stringBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSignatureOn(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        List list = this.methodParameters;
        synchronized (list) {
            Iterator iterator = this.methodParameters.iterator();
            while (iterator.hasNext()) {
                MWMethodParameter mWMethodParameter = (MWMethodParameter)iterator.next();
                if (bl) {
                    mWMethodParameter.printSignatureOn(stringBuffer);
                } else {
                    mWMethodParameter.printShortSignatureOn(stringBuffer);
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(')');
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMethod.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(CONSTRUCTOR_PROPERTY, "constructor/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        xMLDirectMapping2.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("returnTypeDeclaration");
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath("return-type-declaration");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(METHOD_PARAMETERS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWMethodParameter.class);
        xMLCompositeCollectionMapping.setXPath("method-parameters/method-parameter");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("exceptionTypeHandles");
        xMLCompositeCollectionMapping2.setGetMethodName("getExceptionTypeHandlesForTopLink");
        xMLCompositeCollectionMapping2.setSetMethodName("setExceptionTypeHandlesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWClassHandle.class);
        xMLCompositeCollectionMapping2.setXPath("exception-type-handles/class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("accessedAttributeHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getAccessedAttributeHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setAccessedAttributeHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWAttributeHandle.class);
        xMLCompositeObjectMapping2.setXPath("accessed-attribute-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private int getModifierForTopLink() {
        return this.modifier.getCode();
    }

    private void setModifierForTopLink(int n) {
        this.modifier.setCodeForTopLink(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getExceptionTypeHandlesForTopLink() {
        Collection collection = this.exceptionTypeHandles;
        synchronized (collection) {
            return new TreeSet(this.exceptionTypeHandles);
        }
    }

    private void setExceptionTypeHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWClassHandle)iterator.next()).setScrubber(this.exceptionTypeScrubber());
        }
        this.exceptionTypeHandles = collection;
    }

    private MWAttributeHandle getAccessedAttributeHandleForTopLink() {
        return this.accessedAttributeHandle.getAttribute() == null ? null : this.accessedAttributeHandle;
    }

    private void setAccessedAttributeHandleForTopLink(MWAttributeHandle mWAttributeHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildAccessedAttributeScrubber();
        this.accessedAttributeHandle = mWAttributeHandle == null ? new MWAttributeHandle(this, nodeReferenceScrubber) : mWAttributeHandle.setScrubber(nodeReferenceScrubber);
    }
}

