/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodParameter
extends MWModel {
    private MWTypeDeclaration typeDeclaration;
    public static final String TYPE_PROPERTY = "type";
    public static final String DIMENSIONALITY_PROPERTY = "dimensionality";

    private MWMethodParameter() {
    }

    private MWMethodParameter(MWMethod mWMethod) {
        super(mWMethod);
    }

    MWMethodParameter(MWMethod mWMethod, MWClass mWClass) {
        this(mWMethod, mWClass, 0);
    }

    MWMethodParameter(MWMethod mWMethod, MWClass mWClass, int n) {
        this(mWMethod);
        this.typeDeclaration = new MWTypeDeclaration(this, mWClass, n);
    }

    MWMethodParameter(MWMethod mWMethod, ExternalClassDescription externalClassDescription) {
        this(mWMethod);
        this.typeDeclaration = new MWTypeDeclaration((MWModel)this, externalClassDescription);
    }

    MWMethodParameter(MWMethod mWMethod, MWTypeDeclaration mWTypeDeclaration) {
        this(mWMethod);
        this.typeDeclaration = mWTypeDeclaration;
    }

    MWMethod getMethod() {
        return (MWMethod)this.getParent();
    }

    MWTypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public MWClass getType() {
        return this.typeDeclaration.getType();
    }

    public void setType(MWClass mWClass) {
        if (mWClass.isVoid()) {
            throw new IllegalArgumentException("A method parameter cannot have a type of 'void'");
        }
        MWClass mWClass2 = this.typeDeclaration.getType();
        this.typeDeclaration.setType(mWClass);
        this.firePropertyChanged(TYPE_PROPERTY, mWClass2, mWClass);
        if (this.attributeValueHasChanged(mWClass2, mWClass)) {
            this.getMethod().parameterChanged();
        }
    }

    public int getDimensionality() {
        return this.typeDeclaration.getDimensionality();
    }

    public void setDimensionality(int n) {
        int n2 = this.typeDeclaration.getDimensionality();
        this.typeDeclaration.setDimensionality(n);
        this.firePropertyChanged(DIMENSIONALITY_PROPERTY, n2, n);
        if (n2 != n) {
            this.getMethod().parameterChanged();
        }
    }

    boolean isAssignableFrom(MWClass mWClass) {
        return this.typeDeclaration.isAssignableFrom(mWClass);
    }

    boolean mightBeAssignableFrom(MWClass mWClass) {
        return this.typeDeclaration.mightBeAssignableFrom(mWClass);
    }

    boolean isAssignableFrom(MWClass mWClass, int n) {
        return this.typeDeclaration.isAssignableFrom(mWClass, n);
    }

    boolean mightBeAssignableFrom(MWClass mWClass, int n) {
        return this.typeDeclaration.mightBeAssignableFrom(mWClass, n);
    }

    boolean isAssignableFrom(MWTypeDeclaration mWTypeDeclaration) {
        return this.typeDeclaration.isAssignableFrom(mWTypeDeclaration);
    }

    boolean mightBeAssignableFrom(MWTypeDeclaration mWTypeDeclaration) {
        return this.typeDeclaration.mightBeAssignableFrom(mWTypeDeclaration);
    }

    boolean isAssignableTo(MWClass mWClass) {
        return this.typeDeclaration.isAssignableTo(mWClass);
    }

    boolean mightBeAssignableTo(MWClass mWClass) {
        return this.typeDeclaration.mightBeAssignableTo(mWClass);
    }

    boolean isAssignableTo(MWClass mWClass, int n) {
        return this.typeDeclaration.isAssignableTo(mWClass, n);
    }

    boolean mightBeAssignableTo(MWClass mWClass, int n) {
        return this.typeDeclaration.mightBeAssignableTo(mWClass, n);
    }

    boolean isAssignableTo(MWTypeDeclaration mWTypeDeclaration) {
        return this.typeDeclaration.isAssignableTo(mWTypeDeclaration);
    }

    boolean mightBeAssignableTo(MWTypeDeclaration mWTypeDeclaration) {
        return this.typeDeclaration.mightBeAssignableTo(mWTypeDeclaration);
    }

    boolean matches(MWTypeDeclaration mWTypeDeclaration) {
        return this.typeDeclaration.matches(mWTypeDeclaration);
    }

    boolean hasSameSignatureAs(ExternalClassDescription externalClassDescription) {
        return this.typeDeclaration.hasSameSignatureAs(externalClassDescription);
    }

    boolean hasSameSignatureAs(MWMethodParameter mWMethodParameter) {
        return this.typeDeclaration.hasSameSignatureAs(mWMethodParameter);
    }

    public String declaration() {
        return this.typeDeclaration.declaration();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.typeDeclaration);
    }

    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.getType() == node) {
            this.getMethod().parameterChanged();
        }
    }

    public void toString(StringBuffer stringBuffer) {
        this.typeDeclaration.toString(stringBuffer);
    }

    void printSignatureOn(StringBuffer stringBuffer) {
        this.typeDeclaration.printSignatureOn(stringBuffer);
    }

    void printShortSignatureOn(StringBuffer stringBuffer) {
        this.typeDeclaration.printShortSignatureOn(stringBuffer);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMethodParameter.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("typeDeclaration");
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath("type-declaration");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }
}

