/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.ManifestInterrogator;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.AffixStrippingPartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.ExhaustivePartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;

public abstract class MWProject
extends MWModel
implements ProjectSubFileComponentContainer {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private SPIManager spiManager;
    private Collection descriptors;
    public static final String DESCRIPTORS_COLLECTION = "descriptors";
    private MWClassRepository classRepository;
    private MWProjectDefaultsPolicy defaultsPolicy;
    private volatile String deploymentXMLFileName;
    public static final String DEPLOYMENT_XML_FILE_NAME_PROPERTY = "deploymentXMLFileName";
    private volatile String projectSourceClassName;
    public static final String PROJECT_SOURCE_CLASS_NAME_PROPERTY = "projectSourceClassName";
    private volatile String projectSourceDirectoryName;
    public static final String PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY = "projectSourceDirectoryName";
    private volatile String modelSourceDirectoryName;
    public static final String MODEL_SOURCE_DIRECTORY_NAME_PROPERTY = "modelSourceDirectoryName";
    private volatile File saveDirectory;
    public static final String SAVE_DIRECTORY_PROPERTY = "saveDirectory";
    private Collection descriptorNames;
    private static final String DESCRIPTOR_NAMES_COLLECTION = "descriptorNames";
    private String version;
    private volatile boolean legacyProject;
    private ChangeNotifier changeNotifier;
    private Node.Validator validator;
    private volatile boolean validating;
    public static final String VALIDATING_PROPERTY = "validating";
    private volatile boolean usesWeaving;
    public static final String USES_WEAVING_PROPERTY = "usesWeaving";
    public static final String CURRENT_PROJECT_ROOT_ELEMENT_NAME = "project";
    public static final String CURRENT_SCHEMA_VERSION_ELEMENT_NAME = "schema-version";
    public static final String CURRENT_SCHEMA_VERSION = "7.0";
    private static final String SUB_DIRECTORY_NAME = "descriptors";
    public static final String FILE_NAME_EXTENSION = ".mwp";
    private static final ManifestInterrogator MANIFEST_INTERROGATOR = new ManifestInterrogator(MWProject.class, new LocalManifestDefaults());
    protected static final float CLASS_META_DATA_PARTIAL_STRING_AFFIX_THRESHOLD = 0.8f;
    protected static final PartialStringComparatorEngine CLASS_META_DATA_NAME_COMPARATOR_ENGINE = AffixStrippingPartialStringComparatorEngine.forPrefixStripping(AffixStrippingPartialStringComparatorEngine.forSuffixStripping((PartialStringComparatorEngine)new ExhaustivePartialStringComparatorEngine(PartialStringComparator.DEFAULT_COMPARATOR), 0.8f), 0.8f);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWProject.class);
        xMLDescriptor.setDefaultRootElement(CURRENT_PROJECT_ROOT_ELEMENT_NAME);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalProject.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWOXProject.class, (Object)"o-x");
        inheritancePolicy.addClassIndicator(MWEisProject.class, (Object)"eis");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        xMLDescriptor.addDirectMapping("version", "getProductVersionForTopLink", "setProductVersionForTopLink", "product-version/text()");
        xMLDescriptor.addDirectMapping("schemaVersion", "getSchemaVersionForTopLink", "setSchemaVersionForTopLink", "schema-version/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("classRepository");
        xMLCompositeObjectMapping.setReferenceClass(MWClassRepository.class);
        xMLCompositeObjectMapping.setXPath("class-repository");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(DESCRIPTOR_NAMES_COLLECTION);
        xMLCompositeDirectCollectionMapping.setSetMethodName("setDescriptorNamesForTopLink");
        xMLCompositeDirectCollectionMapping.setGetMethodName("getDescriptorNamesForTopLink");
        xMLCompositeDirectCollectionMapping.useCollectionClass(HashSet.class);
        xMLCompositeDirectCollectionMapping.setXPath("descriptor-names/descriptor-name/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("defaultsPolicy");
        xMLCompositeObjectMapping2.setReferenceClass(MWProjectDefaultsPolicy.class);
        xMLCompositeObjectMapping2.setXPath("defaults-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(DEPLOYMENT_XML_FILE_NAME_PROPERTY);
        xMLDirectMapping.setSetMethodName("setDeploymentXMLFileNameForTopLink");
        xMLDirectMapping.setGetMethodName("getDeploymentXMLFileNameForTopLink");
        xMLDirectMapping.setXPath("deployment-xml-file/text()");
        xMLDirectMapping.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(PROJECT_SOURCE_CLASS_NAME_PROPERTY);
        xMLDirectMapping2.setXPath("project-source/class/text()");
        xMLDirectMapping2.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY);
        xMLDirectMapping3.setSetMethodName("setProjectSourceDirectoryNameForTopLink");
        xMLDirectMapping3.setGetMethodName("getProjectSourceDirectoryNameForTopLink");
        xMLDirectMapping3.setXPath("project-source/directory/text()");
        xMLDirectMapping3.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY);
        xMLDirectMapping4.setSetMethodName("setModelSourceDirectoryNameForTopLink");
        xMLDirectMapping4.setGetMethodName("getModelSourceDirectoryNameForTopLink");
        xMLDirectMapping4.setXPath("model-source/directory/text()");
        xMLDirectMapping4.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName(USES_WEAVING_PROPERTY);
        xMLDirectMapping5.setXPath("use-weaving/text()");
        xMLDirectMapping5.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        return xMLDescriptor;
    }

    public static XMLDescriptor buildLegacy60Descriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWProject.class);
        xMLDescriptor.setDefaultRootElement(CURRENT_PROJECT_ROOT_ELEMENT_NAME);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalProject.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWOXProject.class, (Object)"o-x");
        inheritancePolicy.addClassIndicator(MWEisProject.class, (Object)"eis");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        xMLDescriptor.addDirectMapping("version", "getProductVersionForTopLink", "setProductVersionForTopLink", "product-version/text()");
        xMLDescriptor.addDirectMapping("schemaVersion", "getSchemaVersionForTopLink", "setSchemaVersionForTopLink", "schema-version/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("classRepository");
        xMLCompositeObjectMapping.setReferenceClass(MWClassRepository.class);
        xMLCompositeObjectMapping.setXPath("class-repository");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(DESCRIPTOR_NAMES_COLLECTION);
        xMLCompositeDirectCollectionMapping.setSetMethodName("setDescriptorNamesForTopLink");
        xMLCompositeDirectCollectionMapping.setGetMethodName("getDescriptorNamesForTopLink");
        xMLCompositeDirectCollectionMapping.useCollectionClass(HashSet.class);
        xMLCompositeDirectCollectionMapping.setXPath("descriptor-names/descriptor-name/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("defaultsPolicy");
        xMLCompositeObjectMapping2.setReferenceClass(MWProjectDefaultsPolicy.class);
        xMLCompositeObjectMapping2.setXPath("defaults-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(DEPLOYMENT_XML_FILE_NAME_PROPERTY);
        xMLDirectMapping.setSetMethodName("setDeploymentXMLFileNameForTopLink");
        xMLDirectMapping.setGetMethodName("getDeploymentXMLFileNameForTopLink");
        xMLDirectMapping.setXPath("deployment-xml-file/text()");
        xMLDirectMapping.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(PROJECT_SOURCE_CLASS_NAME_PROPERTY);
        xMLDirectMapping2.setXPath("project-source/class/text()");
        xMLDirectMapping2.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY);
        xMLDirectMapping3.setSetMethodName("setProjectSourceDirectoryNameForTopLink");
        xMLDirectMapping3.setGetMethodName("getProjectSourceDirectoryNameForTopLink");
        xMLDirectMapping3.setXPath("project-source/directory/text()");
        xMLDirectMapping3.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY);
        xMLDirectMapping4.setSetMethodName("setModelSourceDirectoryNameForTopLink");
        xMLDirectMapping4.setGetMethodName("getModelSourceDirectoryNameForTopLink");
        xMLDirectMapping4.setXPath("model-source/directory/text()");
        xMLDirectMapping4.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        return xMLDescriptor;
    }

    protected MWProject() {
    }

    protected MWProject(String string, SPIManager sPIManager) {
        super(null);
        this.name = string;
        this.spiManager = sPIManager;
    }

    protected void initialize() {
        super.initialize();
        this.descriptors = new Vector();
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
        this.validating = false;
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.descriptorNames = new HashSet();
        this.classRepository = new MWClassRepository(this);
        this.defaultsPolicy = this.buildDefaultsPolicy();
        this.deploymentXMLFileName = "";
        this.projectSourceClassName = "";
        this.projectSourceDirectoryName = "";
        this.modelSourceDirectoryName = "";
        this.usesWeaving = false;
    }

    protected abstract MWProjectDefaultsPolicy buildDefaultsPolicy();

    protected void checkParent(Node node) {
        if (node != null) {
            throw new IllegalArgumentException("An MWProject should not have a parent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.descriptors;
        synchronized (collection) {
            list.addAll(this.descriptors);
        }
        list.add(this.classRepository);
        list.add(this.defaultsPolicy);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
    }

    public SPIManager getSPIManager() {
        return this.spiManager;
    }

    public Iterator descriptors() {
        return new CloneIterator(this.descriptors){

            protected void remove(Object object) {
                MWProject.this.removeDescriptor((MWDescriptor)object);
            }
        };
    }

    private void setDescriptors(Collection collection) {
        this.descriptors = collection;
    }

    public int descriptorsSize() {
        return this.descriptors.size();
    }

    protected MWDescriptor addDescriptor(MWDescriptor mWDescriptor) {
        mWDescriptor.applyAdvancedPolicyDefaults(this.getDefaultsPolicy());
        this.addItemToCollection(mWDescriptor, this.descriptors, "descriptors");
        return mWDescriptor;
    }

    public MWDescriptor addDescriptorForType(MWClass mWClass) throws InterfaceDescriptorCreationException {
        return this.addDescriptor(this.createDescriptorForType(mWClass));
    }

    protected abstract MWDescriptor createDescriptorForType(MWClass var1) throws InterfaceDescriptorCreationException;

    public void removeDescriptor(MWDescriptor mWDescriptor) {
        this.removeNodeFromCollection(mWDescriptor, this.descriptors, "descriptors");
    }

    public void removeDescriptorForType(MWClass mWClass) {
        MWDescriptor mWDescriptor = this.descriptorForType(mWClass);
        if (mWDescriptor != null) {
            this.removeDescriptor(mWDescriptor);
        }
    }

    public void removeDescriptors(Collection collection) {
        this.removeNodesFromCollection(collection, this.descriptors, "descriptors");
    }

    public void removeDescriptors(Iterator iterator) {
        this.removeNodesFromCollection(iterator, this.descriptors, "descriptors");
    }

    public void replaceDescriptor(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        this.removeItemFromCollection(mWDescriptor, this.descriptors, "descriptors");
        this.descriptorReplaced(mWDescriptor, mWDescriptor2);
    }

    public MWClassRepository getClassRepository() {
        return this.classRepository;
    }

    public MWProjectDefaultsPolicy getDefaultsPolicy() {
        return this.defaultsPolicy;
    }

    public String getDeploymentXMLFileName() {
        return this.deploymentXMLFileName;
    }

    public void setDeploymentXMLFileName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.deploymentXMLFileName;
        this.deploymentXMLFileName = string;
        this.firePropertyChanged(DEPLOYMENT_XML_FILE_NAME_PROPERTY, string2, string);
    }

    public String getProjectSourceClassName() {
        return this.projectSourceClassName;
    }

    public void setProjectSourceClassName(String string) {
        String string2 = this.projectSourceClassName;
        this.projectSourceClassName = string;
        this.firePropertyChanged(PROJECT_SOURCE_CLASS_NAME_PROPERTY, string2, string);
    }

    public String getProjectSourceDirectoryName() {
        return this.projectSourceDirectoryName;
    }

    public void setProjectSourceDirectoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.projectSourceDirectoryName;
        this.projectSourceDirectoryName = string;
        this.firePropertyChanged(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY, string2, string);
    }

    public String getModelSourceDirectoryName() {
        return this.modelSourceDirectoryName;
    }

    public void setModelSourceDirectoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.modelSourceDirectoryName;
        this.modelSourceDirectoryName = string;
        this.firePropertyChanged(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY, string2, string);
    }

    public File getSaveDirectory() {
        return this.saveDirectory;
    }

    public void setSaveDirectory(File file) {
        File file2 = this.saveDirectory;
        this.saveDirectory = file;
        this.firePropertyChanged(SAVE_DIRECTORY_PROPERTY, file2, file);
        if (this.attributeValueHasChanged(file2, file)) {
            this.markEntireBranchDirty();
        }
    }

    public boolean isLegacyProject() {
        return this.legacyProject;
    }

    public void setIsLegacyProject(boolean bl) {
        this.legacyProject = bl;
    }

    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    private void setIsValidating(boolean bl) {
        boolean bl2 = this.validating;
        this.validating = bl;
        this.firePropertyChanged(VALIDATING_PROPERTY, bl2, bl);
    }

    public Iterator mappingDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object object) {
                return object instanceof MWMappingDescriptor;
            }
        };
    }

    public Iterator interfaceDescriptorsThatImplement(MWMappingDescriptor mWMappingDescriptor) {
        return NullIterator.instance();
    }

    public Iterator descriptorsInPackage(final String string) {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object object) {
                return ((MWDescriptor)object).packageName().equals(string);
            }
        };
    }

    public ExternalClassLoadFailureContainer addDescriptorsForExternalClassDescriptions(Iterator iterator, DescriptorCreationFailureListener descriptorCreationFailureListener) {
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = new ExternalClassLoadFailureContainer();
        while (iterator.hasNext()) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)iterator.next();
            try {
                this.classRepository.refreshTypeFor(externalClassDescription);
            }
            catch (ExternalClassNotFoundException externalClassNotFoundException) {
                externalClassLoadFailureContainer.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, externalClassDescription.getName(), externalClassNotFoundException));
                continue;
            }
            MWClass mWClass = this.typeNamed(externalClassDescription.getName());
            MWDescriptor mWDescriptor = this.descriptorForType(mWClass);
            if (mWDescriptor != null) continue;
            try {
                mWDescriptor = this.addDescriptorForType(mWClass);
            }
            catch (InterfaceDescriptorCreationException interfaceDescriptorCreationException) {
                descriptorCreationFailureListener.descriptorCreationFailure(new DescriptorCreationFailureEvent(this, mWClass.getName(), "DESCRIPTOR_CREATION_ERROR_MESSAGE"));
            }
        }
        return externalClassLoadFailureContainer;
    }

    public Iterator activeDescriptors() {
        return new FilteringIterator(this.descriptors()){

            public boolean accept(Object object) {
                return ((MWDescriptor)object).isActive();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWDescriptor descriptorForType(MWClass mWClass) {
        Collection collection = this.descriptors;
        synchronized (collection) {
            for (MWDescriptor mWDescriptor : this.descriptors) {
                if (mWDescriptor.getMWClass() != mWClass) continue;
                return mWDescriptor;
            }
        }
        return null;
    }

    public MWDescriptor descriptorForTypeNamed(String string) {
        return this.descriptorForType(this.typeNamed(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWDescriptor descriptorNamed(String string) {
        Collection collection = this.descriptors;
        synchronized (collection) {
            for (MWDescriptor mWDescriptor : this.descriptors) {
                if (!mWDescriptor.getName().equals(string)) continue;
                return mWDescriptor;
            }
        }
        return null;
    }

    public void implementorsChangedFor(MWInterfaceDescriptor mWInterfaceDescriptor) {
        Iterator iterator = this.mappingDescriptors();
        while (iterator.hasNext()) {
            ((MWMappingDescriptor)iterator.next()).implementorsChangedFor(mWInterfaceDescriptor);
        }
    }

    public MWProject getDescriptorRepository() {
        return this;
    }

    public Iterator allWriteableMappings() {
        return new FilteringIterator(this.allMappings()){

            protected boolean accept(Object object) {
                return !((MWMapping)object).isReadOnly();
            }
        };
    }

    public Iterator allMappings() {
        return new CompositeIterator(new TransformationIterator(this.activeDescriptors()){

            protected Object transform(Object object) {
                return ((MWDescriptor)object).mappings();
            }
        });
    }

    public DescriptorStringHolder[] descriptorStringHolders() {
        return DescriptorStringHolder.buildHolders(this.descriptors);
    }

    public void exportDeploymentXML() {
        File file = this.deploymentXMLFile();
        file.getParentFile().mkdirs();
        XMLProjectWriter.write((String)file.getAbsolutePath(), (Project)this.buildRuntimeProject());
    }

    public File deploymentXMLFile() {
        File file = new File(this.deploymentXMLFileName);
        return FileTools.convertToAbsoluteFile(file, this.getSaveDirectory());
    }

    public void exportProjectSource() {
        File file = this.projectSourceFile();
        file.getParentFile().mkdirs();
        ProjectClassGenerator projectClassGenerator = new ProjectClassGenerator();
        projectClassGenerator.setProject(this.buildRuntimeProject());
        projectClassGenerator.setClassName(this.projectSourceClassName);
        projectClassGenerator.setPackageName(this.projectSourcePackageName());
        projectClassGenerator.setOutputFileName(file.getAbsolutePath());
        projectClassGenerator.generate();
    }

    public File projectSourceFile() {
        return new File(this.absoluteProjectSourceDirectory(), Classpath.convertToJavaFileName(this.projectSourceClassName));
    }

    public File absoluteProjectSourceDirectory() {
        File file = new File(this.projectSourceDirectoryName);
        return FileTools.convertToAbsoluteFile(file, this.getSaveDirectory());
    }

    public String projectSourcePackageName() {
        return ClassTools.packageNameForClassNamed(this.projectSourceClassName);
    }

    public File absoluteModelSourceDirectory() {
        File file = new File(this.modelSourceDirectoryName);
        return FileTools.convertToAbsoluteFile(file, this.getSaveDirectory());
    }

    public abstract boolean canAutomapDescriptors();

    public void automap(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWDescriptor)iterator.next()).automapInheritanceHierarchy(collection);
        }
        this.matchClassesAndMetaData(collection);
        for (MWDescriptor mWDescriptor : collection) {
            mWDescriptor.automap();
        }
    }

    protected void matchClassesAndMetaData(Collection collection) {
    }

    protected DescriptorStringHolder[] buildMetaDataDescriptorStringHolders(Collection collection) {
        ArrayList<MWDescriptor> arrayList = new ArrayList<MWDescriptor>(collection.size());
        for (MWDescriptor mWDescriptor : collection) {
            if (!mWDescriptor.autoMapRequiresMetaData()) continue;
            arrayList.add(mWDescriptor);
        }
        return DescriptorStringHolder.buildHolders(arrayList);
    }

    public Project buildRuntimeProject() {
        Project project = new Project();
        project.setName(this.getName());
        project.setLogin((Login)this.buildRuntimeLogin());
        Iterator iterator = CollectionTools.sortedSet(this.activeDescriptors()).iterator();
        while (iterator.hasNext()) {
            project.addDescriptor(((MWDescriptor)iterator.next()).buildRuntimeDescriptor());
        }
        this.defaultsPolicy.adjustRuntimeProject(project);
        return project;
    }

    protected abstract DatasourceLogin buildRuntimeLogin();

    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.descriptors.contains(node)) {
            this.fireCollectionChanged(DESCRIPTOR_NAMES_COLLECTION);
        }
    }

    public abstract MWModel getMetaDataRepository();

    public ProjectSubFileComponentContainer getMetaDataSubComponentContainer() {
        return (ProjectSubFileComponentContainer)((Object)this.getMetaDataRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator packageNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.descriptors;
        synchronized (collection) {
            Iterator iterator = this.descriptors.iterator();
            while (iterator.hasNext()) {
                hashSet.add(((MWDescriptor)iterator.next()).packageName());
            }
        }
        return hashSet.iterator();
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor mWMappingDescriptor) {
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor mWMappingDescriptor, MWAggregateMapping mWAggregateMapping) {
    }

    public File saveFile() {
        File file = this.getSaveDirectory();
        return file == null ? null : new File(file, FileTools.FILE_NAME_ENCODER.encode(this.getName()) + FILE_NAME_EXTENSION);
    }

    public void notifyExpressionsToRecalculateQueryables() {
    }

    public void hierarchyChanged(MWClass mWClass) {
        Iterator iterator = this.mappingDescriptors();
        while (iterator.hasNext()) {
            ((MWMappingDescriptor)iterator.next()).hierarchyChanged(mWClass);
        }
    }

    protected void addTransientAspectNamesTo(Set set) {
        super.addTransientAspectNamesTo(set);
        set.add(VALIDATING_PROPERTY);
    }

    protected void addInsignificantAspectNamesTo(Set set) {
        super.addInsignificantAspectNamesTo(set);
        set.add(VALIDATING_PROPERTY);
    }

    public void validateBranch() {
        this.setIsValidating(true);
        super.validateBranch();
        this.setIsValidating(false);
    }

    public Iterator projectSubFileComponents() {
        return this.descriptors();
    }

    public void setProjectSubFileComponents(Collection collection) {
        this.setDescriptors(collection);
    }

    public Iterator originalProjectSubFileComponentNames() {
        return this.descriptorNames.iterator();
    }

    public void setOriginalProjectSubFileComponentNames(Collection collection) {
        this.descriptorNames = collection;
    }

    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            if (!this.childHasChangedTheSaveFile(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheSaveFile(Object object) {
        if (this.descriptors.contains(object)) {
            return false;
        }
        if (object instanceof ProjectSubFileComponentContainer) {
            return ((ProjectSubFileComponentContainer)object).hasChangedMainProjectSaveFile();
        }
        return ((Node)object).isDirtyBranch();
    }

    private String getProductVersionForTopLink() {
        return MANIFEST_INTERROGATOR.getVersionNumber();
    }

    public void setProductVersionForTopLink(String string) {
        this.version = string;
    }

    private String getSchemaVersionForTopLink() {
        return CURRENT_SCHEMA_VERSION;
    }

    private void setSchemaVersionForTopLink(String string) {
    }

    private String getDeploymentXMLFileNameForTopLink() {
        return this.deploymentXMLFileName.replace('\\', '/');
    }

    private void setDeploymentXMLFileNameForTopLink(String string) {
        this.deploymentXMLFileName = new File(string).getPath();
    }

    private String getProjectSourceDirectoryNameForTopLink() {
        return this.projectSourceDirectoryName.replace('\\', '/');
    }

    private void setProjectSourceDirectoryNameForTopLink(String string) {
        this.projectSourceDirectoryName = new File(string).getPath();
    }

    private String getModelSourceDirectoryNameForTopLink() {
        return this.modelSourceDirectoryName.replace('\\', '/');
    }

    private void setModelSourceDirectoryNameForTopLink(String string) {
        this.modelSourceDirectoryName = new File(string).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getDescriptorNamesForTopLink() {
        ArrayList<String> arrayList = new ArrayList<String>(this.descriptors.size());
        Collection collection = this.descriptors;
        synchronized (collection) {
            Iterator iterator = this.descriptors.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((MWDescriptor)iterator.next()).getName());
            }
        }
        return CollectionTools.sort(arrayList, (Comparator)Collator.getInstance());
    }

    private void setDescriptorNamesForTopLink(Collection collection) {
        this.descriptorNames = collection;
    }

    public void postProjectBuild() {
        this.setChildBackpointers();
        this.resolveInternalReferences();
        super.postProjectBuild();
        this.buildBasicTypes();
        if (this.version != null) {
            this.markEntireBranchClean();
        }
    }

    protected void resolveInternalReferences() {
        this.resolveHandles();
    }

    private void resolveHandles() {
        this.resolveClassHandles();
        this.resolveMetadataHandles();
        this.resolveColumnHandles();
        this.resolveReferenceHandles();
        this.resolveDescriptorHandles();
        this.resolveMethodHandles();
    }

    private void setSaveDirectoryForIOManager(File file) {
        this.saveDirectory = file;
    }

    private void setSPIManagerForIOManager(SPIManager sPIManager) {
        this.spiManager = sPIManager;
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public boolean usesWeaving() {
        return this.usesWeaving;
    }

    public void setUsesWeaving(boolean bl) {
        boolean bl2 = this.usesWeaving;
        this.usesWeaving = bl;
        this.firePropertyChanged(USES_WEAVING_PROPERTY, bl2, bl);
    }

    private static class LocalManifestDefaults
    implements ManifestInterrogator.Defaults {
        private LocalManifestDefaults() {
        }

        public String defaultSpecificationTitle() {
            return "EclipseLink";
        }

        public String defaultSpecificationVendor() {
            return "Eclipse";
        }

        public String defaultReleaseDesignation() {
            return "Version 1.0.0";
        }

        public String defaultLibraryDesignation() {
            return "Workbench";
        }

        public String defaultSpecificationVersion() {
            return "1.0.0";
        }

        public String defaultImplementationVersion() {
            return this.defaultSpecificationVersion();
        }
    }
}

