/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational;

import java.util.List;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalProjectDefaultsPolicy
extends MWTransactionalProjectDefaultsPolicy {
    public static final String MULTI_TABLE_INFO_POLICY = "Multi-Table Info";
    public static final String INTERFACE_ALIAS_POLICY = "Interface Alias";
    private volatile boolean queriesCacheAllStatements;
    public static final String QUERIES_CACHE_ALL_STATEMENTS_PROPERTY = "queriesCacheAllStatements";
    private volatile boolean queriesBindAllParameters;
    public static final String QUERIES_BIND_ALL_PARAMETERS_PROPERTY = "queriesBindAllParameters";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalProjectDefaultsPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWTransactionalProjectDefaultsPolicy.class);
        xMLDescriptor.addDirectMapping(QUERIES_CACHE_ALL_STATEMENTS_PROPERTY, "cache-all-statements/text()");
        xMLDescriptor.addDirectMapping(QUERIES_BIND_ALL_PARAMETERS_PROPERTY, "bind-all-parameters/text()");
        return xMLDescriptor;
    }

    private MWRelationalProjectDefaultsPolicy() {
    }

    MWRelationalProjectDefaultsPolicy(MWModel mWModel) {
        super(mWModel);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queriesBindAllParameters = true;
    }

    protected void initializePolicyDescriptors() {
        super.initializePolicyDescriptors();
        this.addPolicyDescriptor(MULTI_TABLE_INFO_POLICY, new MultiTableInfoPolicyDescriptor());
        this.addPolicyDescriptor(INTERFACE_ALIAS_POLICY, new InterfaceAliasPolicyDescriptor());
    }

    public boolean shouldQueriesBindAllParameters() {
        return this.queriesBindAllParameters;
    }

    public void setQueriesBindAllParameters(boolean bl) {
        boolean bl2 = bl;
        this.queriesBindAllParameters = bl;
        this.firePropertyChanged(QUERIES_BIND_ALL_PARAMETERS_PROPERTY, bl2, this.queriesBindAllParameters);
    }

    public boolean shouldQueriesCacheAllStatements() {
        return this.queriesCacheAllStatements;
    }

    public void setQueriesCacheAllStatements(boolean bl) {
        boolean bl2 = bl;
        this.queriesCacheAllStatements = bl;
        this.firePropertyChanged(QUERIES_CACHE_ALL_STATEMENTS_PROPERTY, bl2, this.queriesCacheAllStatements);
    }

    protected void adjustRuntimeProject(Project project) {
        project.getLogin().setShouldBindAllParameters(this.shouldQueriesBindAllParameters());
        project.getLogin().setShouldCacheAllStatements(this.shouldQueriesCacheAllStatements());
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkCacheAllStatementsAndBindAllParameters(list);
    }

    private void checkCacheAllStatementsAndBindAllParameters(List list) {
        if (this.queriesCacheAllStatements && !this.queriesBindAllParameters) {
            list.add(this.buildProblem("0100"));
        }
    }

    private class InterfaceAliasPolicyDescriptor
    implements MWProjectDefaultsPolicy.PolicyDescriptor {
        private InterfaceAliasPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (((MWRelationalClassDescriptor)mWMappingDescriptor).supportsInterfaceAliasPolicy()) {
                ((MWTableDescriptor)mWMappingDescriptor).addInterfaceAliasPolicy();
            }
        }
    }

    private class MultiTableInfoPolicyDescriptor
    implements MWProjectDefaultsPolicy.PolicyDescriptor {
        private MultiTableInfoPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (((MWRelationalClassDescriptor)mWMappingDescriptor).supportsMultitablePolicy()) {
                ((MWTableDescriptor)mWMappingDescriptor).addMultiTableInfoPolicy();
            }
        }
    }
}

