/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWSequencingPolicy
extends MWModel {
    private volatile String sequencingType;
    public static final String SEQUENCING_TYPE_PROPERTY = "SequencingType";
    public static final String DEFAULT_SEQUENCING = "Use default sequencing";
    public static final String NATIVE_SEQUENCING = "Use native sequencing";
    public static final String SEQUENCE_TABLE = "Use sequencing table";
    private volatile int preallocationSize;
    public static final String PREALLOCATION_SIZE_PROPERTY = "preallocationSize";
    private MWTableHandle tableHandle;
    public static final String SEQUENCING_TABLE_PROPERTY = "table";
    private MWColumnHandle nameColumnHandle;
    public static final String NAME_COLUMN_PROPERTY = "nameColumn";
    private MWColumnHandle counterColumnHandle;
    public static final String COUNTER_COLUMN_PROPERTY = "counterColumn";

    private MWSequencingPolicy() {
    }

    MWSequencingPolicy(MWRelationalProject mWRelationalProject) {
        super(mWRelationalProject);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.tableHandle = new MWTableHandle(this, this.buildTableScrubber());
        this.nameColumnHandle = new MWColumnHandle(this, this.buildNameColumnScrubber());
        this.counterColumnHandle = new MWColumnHandle(this, this.buildCounterColumnScrubber());
        this.preallocationSize = 50;
        this.sequencingType = DEFAULT_SEQUENCING;
    }

    public MWTable getTable() {
        return this.tableHandle.getTable();
    }

    public void setTable(MWTable mWTable) {
        MWTable mWTable2 = this.tableHandle.getTable();
        this.tableHandle.setTable(mWTable);
        this.firePropertyChanged(SEQUENCING_TABLE_PROPERTY, mWTable2, this.tableHandle.getTable());
        this.setNameColumn(null);
        this.setCounterColumn(null);
    }

    public MWColumn getCounterColumn() {
        return this.counterColumnHandle.getColumn();
    }

    public void setCounterColumn(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.counterColumnHandle.getColumn();
        this.counterColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(COUNTER_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public MWColumn getNameColumn() {
        return this.nameColumnHandle.getColumn();
    }

    public void setNameColumn(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.nameColumnHandle.getColumn();
        this.nameColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(NAME_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public int getPreallocationSize() {
        return this.preallocationSize;
    }

    public void setPreallocationSize(int n) {
        int n2 = this.preallocationSize;
        this.preallocationSize = n;
        this.firePropertyChanged(PREALLOCATION_SIZE_PROPERTY, n2, this.preallocationSize);
    }

    public String getSequencingType() {
        return this.sequencingType;
    }

    public void setSequencingType(String string) {
        this.checkSequencingType(this.sequencingType);
        String string2 = this.sequencingType;
        this.sequencingType = string;
        this.firePropertyChanged(SEQUENCING_TYPE_PROPERTY, string2, this.sequencingType);
    }

    private void checkSequencingType(String string) {
        if (string != DEFAULT_SEQUENCING && string != NATIVE_SEQUENCING && string != SEQUENCE_TABLE) {
            throw new IllegalArgumentException("MWSequencingPolicy: sequencingType must be one of MWSequencingPolicy.DEFAULT_SEQUENCING, MWSequencingPolicy.NATIVE_SEQUENCING or MWSequencingPolicy.SEQUENCE_TABLE");
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.nameColumnHandle);
        list.add(this.counterColumnHandle);
        list.add(this.tableHandle);
    }

    private MWHandle.NodeReferenceScrubber buildNameColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWSequencingPolicy.this.setNameColumn(null);
            }

            public String toString() {
                return "MWSequencingPolicy.buildNameColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildCounterColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWSequencingPolicy.this.setCounterColumn(null);
            }

            public String toString() {
                return "MWSequencingPolicy.buildCounterColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWSequencingPolicy.this.setTable(null);
            }

            public String toString() {
                return "MWSequencingPolicy.buildTableScrubber()";
            }
        };
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.sequencingType == SEQUENCE_TABLE) {
            this.checkSequenceTable(list);
        }
    }

    private void checkSequenceTable(List list) {
        if (this.getCounterColumn() == null) {
            list.add(this.buildProblem("0101"));
        }
        if (this.getNameColumn() == null) {
            list.add(this.buildProblem("0102"));
        }
    }

    void adjustRuntimeLogin(DatabaseLogin databaseLogin) {
        if (this.getSequencingType().equals(NATIVE_SEQUENCING)) {
            databaseLogin.useNativeSequencing();
        } else if (this.getSequencingType().equals(SEQUENCE_TABLE)) {
            if (this.getTable() != null) {
                ((TableSequence)databaseLogin.getDefaultSequence()).setTableName(this.getTable().getName());
            }
            if (this.getNameColumn() != null) {
                ((TableSequence)databaseLogin.getDefaultSequence()).setNameFieldName(this.getNameColumn().getName());
            }
            if (this.getCounterColumn() != null) {
                ((TableSequence)databaseLogin.getDefaultSequence()).setCounterFieldName(this.getCounterColumn().getName());
            }
        }
        databaseLogin.getDefaultSequence().setPreallocationSize(this.getPreallocationSize());
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getSequencingType());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWSequencingPolicy.class);
        xMLDescriptor.addDirectMapping(PREALLOCATION_SIZE_PROPERTY, "preallocation-size/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)DEFAULT_SEQUENCING, (Object)DEFAULT_SEQUENCING);
        objectTypeConverter.addConversionValue((Object)NATIVE_SEQUENCING, (Object)NATIVE_SEQUENCING);
        objectTypeConverter.addConversionValue((Object)SEQUENCE_TABLE, (Object)SEQUENCE_TABLE);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("sequencingType");
        xMLDirectMapping.setXPath("sequencing-type/text()");
        xMLDirectMapping.setNullValue((Object)DEFAULT_SEQUENCING);
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("nameColumnHandle");
        xMLCompositeObjectMapping.setSetMethodName("setNameColumnHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getNameColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("name-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("counterColumnHandle");
        xMLCompositeObjectMapping2.setSetMethodName("setCounterColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setGetMethodName("getCounterColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping2.setXPath("counter-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("tableHandle");
        xMLCompositeObjectMapping3.setSetMethodName("setTableHandleForTopLink");
        xMLCompositeObjectMapping3.setGetMethodName("getTableHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping3.setXPath("table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        return xMLDescriptor;
    }

    private MWColumnHandle getNameColumnHandleForTopLink() {
        return this.nameColumnHandle.getColumn() == null ? null : this.nameColumnHandle;
    }

    private void setNameColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildNameColumnScrubber();
        this.nameColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWColumnHandle getCounterColumnHandleForTopLink() {
        return this.counterColumnHandle.getColumn() == null ? null : this.counterColumnHandle;
    }

    private void setCounterColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildCounterColumnScrubber();
        this.counterColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWTableHandle getTableHandleForTopLink() {
        return this.tableHandle.getTable() == null ? null : this.tableHandle;
    }

    private void setTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTableScrubber();
        this.tableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }
}

