/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWProperty;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisLoginSpec
extends MWModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile String userName;
    public static final String USER_NAME_PROPERTY = "userName";
    private volatile String password;
    public static final String PASSWORD_PROPERTY = "password";
    private volatile boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private MWClassHandle connectionSpecClassHandle;
    public static final String CONNECTION_SPEC_CLASS_PROPERTY = "connectionSpecClass";
    private volatile String connectionFactoryUrl;
    public static final String CONNECTION_FACTORY_URL_PROPERTY = "connectionFactoryUrl";
    private volatile Collection properties;
    public static final String PROPERTY_COLLECTION = "property";
    private volatile String j2cAdapterName;
    public static String J2C_ADAPTER_NAME_PROPERTY = "j2cAdapter";
    public static String AQ_ADAPTER_NAME = "Oracle AQ";
    public static String JMS_ADAPTER_NAME = "JMS";
    public static String XML_FILE_ADAPTER_NAME = "XML File";
    public static String DEFAULT_ADAPTER_NAME = AQ_ADAPTER_NAME;
    public static String[] j2cAdapterNames = new String[]{AQ_ADAPTER_NAME, JMS_ADAPTER_NAME, XML_FILE_ADAPTER_NAME};
    public static final String J2C_ADAPTER_NAMES_COLLECTION = "j2cAdapterNames";
    public static String JMS_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.jms.JMSPlatform";
    public static String ORACLE_AQ_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.aq.AQPlatform";
    public static String XML_FILE_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.xmlfile.XMLFilePlatform";
    public static final String PLATFORM_PREFERENCE = "eis platform";
    public static final String PLATFORM_PREFERENCE_DEFAULT = AQ_ADAPTER_NAME;
    private static transient JCEEncryptor ENCRYPTOR;

    private static JCEEncryptor getEncryptor() {
        if (ENCRYPTOR == null) {
            try {
                ENCRYPTOR = new JCEEncryptor();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return ENCRYPTOR;
    }

    private MWEisLoginSpec() {
    }

    MWEisLoginSpec(MWEisProject mWEisProject, String string) {
        super(mWEisProject);
        this.initialize(string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.connectionSpecClassHandle = new MWClassHandle(this, this.buildConnectionSpecClassScrubber());
        this.savePassword = false;
        this.properties = new Vector();
    }

    protected void initialize(String string) {
        this.j2cAdapterName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public String getConnectionFactoryURL() {
        return this.connectionFactoryUrl;
    }

    public void setConnectionFactoryURL(String string) {
        String string2 = this.connectionFactoryUrl;
        this.connectionFactoryUrl = string;
        this.firePropertyChanged(CONNECTION_FACTORY_URL_PROPERTY, string2, string);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        String string2 = this.userName;
        this.userName = string;
        this.firePropertyChanged(USER_NAME_PROPERTY, string2, string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        String string2 = this.password;
        this.password = string;
        this.firePropertyChanged(PASSWORD_PROPERTY, string2, string);
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean bl) {
        boolean bl2 = this.savePassword;
        this.savePassword = bl;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, bl2, bl);
    }

    public MWClass getConnectionSpecClass() {
        return this.connectionSpecClassHandle.getType();
    }

    public void setConnectionSpecClass(MWClass mWClass) {
        MWClass mWClass2 = this.getConnectionSpecClass();
        this.connectionSpecClassHandle.setType(mWClass);
        this.firePropertyChanged(CONNECTION_SPEC_CLASS_PROPERTY, mWClass2, this.connectionSpecClassHandle.getType());
    }

    public Collection getProperties() {
        return this.properties;
    }

    public Iterator properties() {
        return this.getProperties().iterator();
    }

    public int propertySize() {
        return this.getProperties().size();
    }

    protected void removeAllProperties() {
        Vector vector = new Vector(this.properties);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.removeProperty((MWProperty)iterator.next());
        }
    }

    public MWProperty addProperty(String string, String string2) {
        MWProperty mWProperty = new MWProperty(this);
        mWProperty.setKey(string);
        mWProperty.setValue(string2);
        this.addItemToCollection(mWProperty, this.getProperties(), PROPERTY_COLLECTION);
        return mWProperty;
    }

    public void removeProperty(MWProperty mWProperty) {
        this.removeItemFromCollection(mWProperty, this.getProperties(), PROPERTY_COLLECTION);
    }

    public String getJ2CAdapterName() {
        return this.j2cAdapterName;
    }

    public void setJ2CAdapterName(String string) {
        String string2 = this.j2cAdapterName;
        this.j2cAdapterName = string;
        this.firePropertyChanged(J2C_ADAPTER_NAME_PROPERTY, string2, string);
    }

    public static Iterator j2CAdapterNames() {
        return CollectionTools.iterator(j2cAdapterNames);
    }

    public static Collection getJ2CAdapterNames() {
        return CollectionTools.collection(j2cAdapterNames);
    }

    public static int j2CAdapterNamesSize() {
        return j2cAdapterNames.length;
    }

    private String encryptedPassword() {
        return this.password == null ? null : MWEisLoginSpec.getEncryptor().encryptPassword(this.password);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }

    public String displayString() {
        return this.name;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.connectionSpecClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildConnectionSpecClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWEisLoginSpec.this.setConnectionSpecClass(null);
            }

            public String toString() {
                return "MWEisLoginSpec.buildConnectionSpecClassScrubber()";
            }
        };
    }

    public DatasourceLogin buildRuntimeLogin() {
        EISLogin eISLogin = new EISLogin();
        if (this.getJ2CAdapterName().equals(AQ_ADAPTER_NAME)) {
            eISLogin.setPlatformClassName(ORACLE_AQ_ADAPTER_CLASS_NAME);
        } else if (this.getJ2CAdapterName().equals(JMS_ADAPTER_NAME)) {
            eISLogin.setPlatformClassName(JMS_ADAPTER_CLASS_NAME);
        } else if (this.getJ2CAdapterName().equals(XML_FILE_ADAPTER_NAME)) {
            eISLogin.setPlatformClassName(XML_FILE_ADAPTER_CLASS_NAME);
        } else {
            throw new UnsupportedOperationException("The j2cAdapterName is not valid");
        }
        MWClass mWClass = this.getConnectionSpecClass();
        if (mWClass != null) {
            eISLogin.setConnectionSpec(this.newInstance(mWClass));
        }
        eISLogin.setConnectionFactoryURL(this.getConnectionFactoryURL());
        String string = this.getUserName();
        if (string != null) {
            eISLogin.setUserName(string);
        }
        String string2 = this.getPassword();
        if (this.savePassword && string2 != null) {
            eISLogin.setPassword(string2);
        }
        for (MWProperty mWProperty : this.getProperties()) {
            eISLogin.setProperty(mWProperty.getKey(), (Object)mWProperty.getValue());
        }
        return eISLogin;
    }

    private EISConnectionSpec newInstance(MWClass mWClass) {
        try {
            return (EISConnectionSpec)ClassTools.newInstance(mWClass.getName(), this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public Collection getPropertiesForTopLink() {
        return this.getProperties();
    }

    public void setPropertiesForTopLink(Collection collection) {
        this.properties = collection == null ? new Vector() : collection;
    }

    public String getJ2CAdapterNameForTopLink() {
        return this.j2cAdapterName;
    }

    public void setJ2CAdapterNameForTopLink(String string) {
        if (string == null) {
            string = DEFAULT_ADAPTER_NAME;
        }
        this.j2cAdapterName = string;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWEisLoginSpec.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        xMLDescriptor.addDirectMapping("j2cAdapterName", "getJ2CAdapterNameForTopLink", "setJ2CAdapterNameForTopLink", "j2c-adapter-name/text()");
        xMLDescriptor.addDirectMapping(USER_NAME_PROPERTY, "user-name/text()");
        xMLDescriptor.addDirectMapping(PASSWORD_PROPERTY, "getPasswordForTopLink", "setPasswordForTopLink", "password/text()");
        xMLDescriptor.addDirectMapping(CONNECTION_FACTORY_URL_PROPERTY, "connection-factory-url/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(SAVE_PASSWORD_PROPERTY, "save-password/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("connectionSpecClassHandle");
        xMLCompositeObjectMapping.setGetMethodName("getConnectionSpecClassHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setConnectionSpecClassHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("connection-spec-class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setReferenceClass(MWProperty.class);
        xMLCompositeCollectionMapping.setAttributeName("properties");
        xMLCompositeCollectionMapping.setGetMethodName("getPropertiesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setPropertiesForTopLink");
        xMLCompositeCollectionMapping.setXPath(PROPERTY_COLLECTION);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private String getPasswordForTopLink() {
        return this.savePassword ? this.encryptedPassword() : null;
    }

    private void setPasswordForTopLink(String string) {
        this.password = string == null ? null : MWEisLoginSpec.getEncryptor().decryptPassword(string);
    }

    private MWClassHandle getConnectionSpecClassHandleForTopLink() {
        return this.connectionSpecClassHandle.getType() == null ? null : this.connectionSpecClassHandle;
    }

    private void setConnectionSpecClassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildConnectionSpecClassScrubber();
        this.connectionSpecClassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }
}

