/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryParameter
extends MWModel
implements MWQueryItem {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWClassHandle typeHandle;
    public static final String TYPE_PROPERTY = "type";

    private MWQueryParameter() {
    }

    MWQueryParameter(MWAbstractQuery mWAbstractQuery, String string, MWClass mWClass) {
        super(mWAbstractQuery);
        this.name = string;
        this.typeHandle.setType(mWClass);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.typeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWQueryParameter.this.setType(null);
            }

            public String toString() {
                return "MWQueryParameter.buildTypeScrubber()";
            }
        };
    }

    public MWQuery getQuery() {
        return (MWQuery)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(NAME_PROPERTY, string2, string);
            this.getProject().nodeRenamed(this);
        }
    }

    public MWClass getType() {
        return this.typeHandle.getType();
    }

    public void setType(MWClass mWClass) {
        if (mWClass == null) {
            throw new NullPointerException();
        }
        MWClass mWClass2 = this.typeHandle.getType();
        this.typeHandle.setType(mWClass);
        if (this.attributeValueHasChanged(mWClass2, mWClass)) {
            this.firePropertyChanged(TYPE_PROPERTY, mWClass2, mWClass);
            this.getQuery().signatureChanged();
        }
    }

    public void removeSelfFromParent() {
        this.getQuery().removeParameter(this);
    }

    void convertToRuntime(ObjectLevelReadQuery objectLevelReadQuery) {
        objectLevelReadQuery.addArgumentByTypeName(this.getName(), this.getType().getName());
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWQueryParameter.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("typeHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTypeHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTypeHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        DatabaseMapping databaseMapping = xMLDescriptor.addDirectMapping("typeName", "legacyDP4GetTypeName", "legacyDP4SetTypeName", "type/text()");
        databaseMapping.setIsReadOnly(true);
        return xMLDescriptor;
    }

    private MWClassHandle getTypeHandleForTopLink() {
        return this.typeHandle.getType() == null ? null : this.typeHandle;
    }

    private void setTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTypeScrubber();
        this.typeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private String legacyDP4GetTypeName() {
        throw new UnsupportedOperationException();
    }

    private void legacyDP4SetTypeName(String string) {
        if (string != null) {
            this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
            this.typeHandle.legacySetTypeNameForTopLink(string);
        }
    }
}

